/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.api.protocol.packet;

import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.protocol.Protocol;
import com.viaversion.viaversion.api.protocol.packet.Direction;
import com.viaversion.viaversion.api.protocol.packet.PacketType;
import com.viaversion.viaversion.api.protocol.packet.State;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandler;
import com.viaversion.viaversion.api.type.Type;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface PacketWrapper {
    public static PacketWrapper create(@Nullable PacketType packetType, UserConnection userConnection) {
        return PacketWrapper.create(packetType, null, userConnection);
    }

    public static PacketWrapper create(@Nullable PacketType packetType, @Nullable ByteBuf byteBuf, UserConnection userConnection) {
        return Via.getManager().getProtocolManager().createPacketWrapper(packetType, byteBuf, userConnection);
    }

    public <T> T get(Type<T> var1, int var2);

    public boolean is(Type var1, int var2);

    public boolean isReadable(Type var1, int var2);

    public <T> void set(Type<T> var1, int var2, T var3);

    public <T> T read(Type<T> var1);

    public <T> void write(Type<T> var1, T var2);

    public <T> T passthrough(Type<T> var1);

    public void writeToBuffer(ByteBuf var1);

    public void clearInputBuffer();

    public void clearPacket();

    default public void send(Class<? extends Protocol> clazz) {
        this.send(clazz, true);
    }

    public void send(Class<? extends Protocol> var1, boolean var2);

    default public void scheduleSend(Class<? extends Protocol> clazz) {
        this.scheduleSend(clazz, true);
    }

    public void scheduleSend(Class<? extends Protocol> var1, boolean var2);

    public ChannelFuture sendFuture(Class<? extends Protocol> var1);

    default public PacketWrapper create(PacketType packetType) {
        return this.create(packetType.getId());
    }

    default public PacketWrapper create(PacketType packetType, PacketHandler packetHandler) {
        return this.create(packetType.getId(), packetHandler);
    }

    public PacketWrapper create(int var1);

    public PacketWrapper create(int var1, PacketHandler var2);

    public PacketWrapper apply(Direction var1, State var2, int var3, List<Protocol> var4, boolean var5);

    public boolean isCancelled();

    default public void cancel() {
        this.setCancelled(true);
    }

    public void setCancelled(boolean var1);

    public UserConnection user();

    public void resetReader();

    default public void sendToServer(Class<? extends Protocol> clazz) {
        this.sendToServer(clazz, true);
    }

    public void sendToServer(Class<? extends Protocol> var1, boolean var2);

    default public void scheduleSendToServer(Class<? extends Protocol> clazz) {
        this.scheduleSendToServer(clazz, true);
    }

    public void scheduleSendToServer(Class<? extends Protocol> var1, boolean var2);

    public @Nullable PacketType getPacketType();

    public void setPacketType(@Nullable PacketType var1);

    public int getId();

    @Deprecated
    public void setId(int var1);
}

