/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.api.protocol.packet;

import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.configuration.ViaVersionConfig;
import com.viaversion.viaversion.api.connection.UserConnection;

public class PacketTracker {
    private final UserConnection connection;
    private long sentPackets;
    private long receivedPackets;
    private long startTime;
    private long intervalPackets;
    private long packetsPerSecond = -1L;
    private int secondsObserved;
    private int warnings;

    public PacketTracker(UserConnection userConnection) {
        this.connection = userConnection;
    }

    public void incrementSent() {
        ++this.sentPackets;
    }

    public boolean incrementReceived() {
        long l2 = System.currentTimeMillis() - this.startTime;
        if (l2 >= 1000L) {
            this.packetsPerSecond = this.intervalPackets;
            this.startTime = System.currentTimeMillis();
            this.intervalPackets = 1L;
            return true;
        }
        ++this.intervalPackets;
        ++this.receivedPackets;
        return false;
    }

    public boolean exceedsMaxPPS() {
        if (this.connection.isClientSide()) {
            return false;
        }
        ViaVersionConfig viaVersionConfig = Via.getConfig();
        if (viaVersionConfig.getMaxPPS() > 0 && this.packetsPerSecond >= (long)viaVersionConfig.getMaxPPS()) {
            this.connection.disconnect(viaVersionConfig.getMaxPPSKickMessage().replace("%pps", Long.toString(this.packetsPerSecond)));
            return true;
        }
        if (viaVersionConfig.getMaxWarnings() > 0 && viaVersionConfig.getTrackingPeriod() > 0) {
            if (this.secondsObserved > viaVersionConfig.getTrackingPeriod()) {
                this.warnings = 0;
                this.secondsObserved = 1;
            } else {
                ++this.secondsObserved;
                if (this.packetsPerSecond >= (long)viaVersionConfig.getWarningPPS()) {
                    ++this.warnings;
                }
                if (this.warnings >= viaVersionConfig.getMaxWarnings()) {
                    this.connection.disconnect(viaVersionConfig.getMaxWarningsKickMessage().replace("%pps", Long.toString(this.packetsPerSecond)));
                    return true;
                }
            }
        }
        return false;
    }
}

