/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.api.minecraft.nbt;

import com.viaversion.viaversion.api.minecraft.nbt.Tokens;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.ByteArrayTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.ByteTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.CompoundTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.DoubleTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.FloatTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.IntArrayTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.IntTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.ListTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.LongArrayTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.LongTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.NumberTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.ShortTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.StringTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.Tag;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;

final class TagStringWriter
implements AutoCloseable {
    private final Appendable out;
    private int level;
    private boolean needsSeparator;

    public TagStringWriter(Appendable appendable) {
        this.out = appendable;
    }

    public TagStringWriter writeTag(Tag tag) {
        if (tag instanceof CompoundTag) {
            return this.writeCompound((CompoundTag)tag);
        }
        if (tag instanceof ListTag) {
            return this.writeList((ListTag)tag);
        }
        if (tag instanceof ByteArrayTag) {
            return this.writeByteArray((ByteArrayTag)tag);
        }
        if (tag instanceof IntArrayTag) {
            return this.writeIntArray((IntArrayTag)tag);
        }
        if (tag instanceof LongArrayTag) {
            return this.writeLongArray((LongArrayTag)tag);
        }
        if (tag instanceof StringTag) {
            return this.value(((StringTag)tag).getValue(), '\u0000');
        }
        if (tag instanceof ByteTag) {
            return this.value(Byte.toString(((NumberTag)tag).asByte()), 'b');
        }
        if (tag instanceof ShortTag) {
            return this.value(Short.toString(((NumberTag)tag).asShort()), 's');
        }
        if (tag instanceof IntTag) {
            return this.value(Integer.toString(((NumberTag)tag).asInt()), 'i');
        }
        if (tag instanceof LongTag) {
            return this.value(Long.toString(((NumberTag)tag).asLong()), Character.toUpperCase('l'));
        }
        if (tag instanceof FloatTag) {
            return this.value(Float.toString(((NumberTag)tag).asFloat()), 'f');
        }
        if (tag instanceof DoubleTag) {
            return this.value(Double.toString(((NumberTag)tag).asDouble()), 'd');
        }
        throw new IOException("Unknown tag type: " + tag.getClass().getSimpleName());
    }

    private TagStringWriter writeCompound(CompoundTag compoundTag) {
        this.beginCompound();
        for (Map.Entry<String, Tag> entry : compoundTag.entrySet()) {
            this.key(entry.getKey());
            this.writeTag(entry.getValue());
        }
        this.endCompound();
        return this;
    }

    private TagStringWriter writeList(ListTag listTag) {
        this.beginList();
        for (Tag tag : listTag) {
            this.printAndResetSeparator();
            this.writeTag(tag);
        }
        this.endList();
        return this;
    }

    private TagStringWriter writeByteArray(ByteArrayTag byteArrayTag) {
        this.beginArray('b');
        byte[] byArray = byteArrayTag.getValue();
        int n2 = byArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.printAndResetSeparator();
            this.value(Byte.toString(byArray[i2]), 'b');
        }
        this.endArray();
        return this;
    }

    private TagStringWriter writeIntArray(IntArrayTag intArrayTag) {
        this.beginArray('i');
        int[] nArray = intArrayTag.getValue();
        int n2 = nArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.printAndResetSeparator();
            this.value(Integer.toString(nArray[i2]), 'i');
        }
        this.endArray();
        return this;
    }

    private TagStringWriter writeLongArray(LongArrayTag longArrayTag) {
        this.beginArray('l');
        long[] lArray = longArrayTag.getValue();
        int n2 = lArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.printAndResetSeparator();
            this.value(Long.toString(lArray[i2]), 'l');
        }
        this.endArray();
        return this;
    }

    public TagStringWriter beginCompound() {
        this.printAndResetSeparator();
        ++this.level;
        this.out.append('{');
        return this;
    }

    public TagStringWriter endCompound() {
        this.out.append('}');
        --this.level;
        this.needsSeparator = true;
        return this;
    }

    public TagStringWriter key(String string) {
        this.printAndResetSeparator();
        this.writeMaybeQuoted(string, false);
        this.out.append(':');
        return this;
    }

    public TagStringWriter value(String string, char c2) {
        if (c2 == '\u0000') {
            this.writeMaybeQuoted(string, true);
        } else {
            this.out.append(string);
            if (c2 != 'i') {
                this.out.append(c2);
            }
        }
        this.needsSeparator = true;
        return this;
    }

    public TagStringWriter beginList() {
        this.printAndResetSeparator();
        ++this.level;
        this.out.append('[');
        return this;
    }

    public TagStringWriter endList() {
        this.out.append(']');
        --this.level;
        this.needsSeparator = true;
        return this;
    }

    private TagStringWriter beginArray(char c2) {
        this.beginList().out.append(c2).append(';');
        return this;
    }

    private TagStringWriter endArray() {
        return this.endList();
    }

    private void writeMaybeQuoted(String string, boolean bl2) {
        if (!bl2) {
            for (int i2 = 0; i2 < string.length(); ++i2) {
                if (Tokens.id(string.charAt(i2))) continue;
                bl2 = true;
                break;
            }
        }
        if (bl2) {
            this.out.append('\"');
            this.out.append(TagStringWriter.escape(string, '\"'));
            this.out.append('\"');
        } else {
            this.out.append(string);
        }
    }

    private static String escape(String string, char c2) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c3 = string.charAt(i2);
            if (c3 == c2 || c3 == '\\') {
                stringBuilder.append('\\');
            }
            stringBuilder.append(c3);
        }
        return stringBuilder.toString();
    }

    private void printAndResetSeparator() {
        if (this.needsSeparator) {
            this.out.append(',');
            this.needsSeparator = false;
        }
    }

    @Override
    public void close() {
        if (this.level != 0) {
            throw new IllegalStateException("Document finished with unbalanced start and end objects");
        }
        if (this.out instanceof Writer) {
            ((Writer)this.out).flush();
        }
    }
}

