/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.api.minecraft.nbt;

import com.viaversion.viaversion.api.minecraft.nbt.CharBuffer;
import com.viaversion.viaversion.api.minecraft.nbt.StringTagParseException;
import com.viaversion.viaversion.api.minecraft.nbt.TagStringReader;
import com.viaversion.viaversion.api.minecraft.nbt.TagStringWriter;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.CompoundTag;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class BinaryTagIO {
    public static @NonNull CompoundTag readInputStream(@NonNull InputStream inputStream) {
        try (DataInputStream dataInputStream = new DataInputStream(inputStream);){
            CompoundTag compoundTag = BinaryTagIO.readDataInput(dataInputStream);
            return compoundTag;
        }
    }

    public static @NonNull CompoundTag readDataInput(@NonNull DataInput dataInput) {
        byte by2 = dataInput.readByte();
        if (by2 != 10) {
            throw new IOException(String.format("Expected root tag to be a CompoundTag, was %s", by2));
        }
        dataInput.skipBytes(dataInput.readUnsignedShort());
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.read(dataInput);
        return compoundTag;
    }

    public static @NonNull CompoundTag readString(@NonNull String string) {
        try {
            CharBuffer charBuffer = new CharBuffer(string);
            TagStringReader tagStringReader = new TagStringReader(charBuffer);
            CompoundTag compoundTag = tagStringReader.compound();
            if (charBuffer.skipWhitespace().hasMore()) {
                throw new IOException("Document had trailing content after first CompoundTag");
            }
            return compoundTag;
        }
        catch (StringTagParseException stringTagParseException) {
            throw new IOException(stringTagParseException);
        }
    }

    public static @NonNull String writeString(@NonNull CompoundTag compoundTag) {
        StringBuilder stringBuilder = new StringBuilder();
        try (TagStringWriter tagStringWriter = new TagStringWriter(stringBuilder);){
            tagStringWriter.writeTag(compoundTag);
        }
        return stringBuilder.toString();
    }
}

