/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.api.minecraft.item;

import com.viaversion.viaversion.api.minecraft.item.Item;
import com.viaversion.viaversion.libs.gson.annotations.SerializedName;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.CompoundTag;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DataItem
implements Item {
    @SerializedName(value="identifier", alternate={"id"})
    private int identifier;
    private byte amount;
    private short data;
    private CompoundTag tag;

    public DataItem() {
    }

    public DataItem(int n2, byte by2, short s2, @Nullable CompoundTag compoundTag) {
        this.identifier = n2;
        this.amount = by2;
        this.data = s2;
        this.tag = compoundTag;
    }

    public DataItem(Item item) {
        this(item.identifier(), (byte)item.amount(), item.data(), item.tag());
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public void setIdentifier(int n2) {
        this.identifier = n2;
    }

    @Override
    public int amount() {
        return this.amount;
    }

    @Override
    public void setAmount(int n2) {
        if (n2 > 127 || n2 < -128) {
            throw new IllegalArgumentException("Invalid item amount: " + n2);
        }
        this.amount = (byte)n2;
    }

    @Override
    public short data() {
        return this.data;
    }

    @Override
    public void setData(short s2) {
        this.data = s2;
    }

    @Override
    public @Nullable CompoundTag tag() {
        return this.tag;
    }

    @Override
    public void setTag(@Nullable CompoundTag compoundTag) {
        this.tag = compoundTag;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        DataItem dataItem = (DataItem)object;
        if (this.identifier != dataItem.identifier) {
            return false;
        }
        if (this.amount != dataItem.amount) {
            return false;
        }
        if (this.data != dataItem.data) {
            return false;
        }
        return Objects.equals(this.tag, dataItem.tag);
    }

    public int hashCode() {
        int n2 = this.identifier;
        n2 = 31 * n2 + this.amount;
        n2 = 31 * n2 + this.data;
        n2 = 31 * n2 + (this.tag != null ? this.tag.hashCode() : 0);
        return n2;
    }

    public String toString() {
        return "Item{identifier=" + this.identifier + ", amount=" + this.amount + ", data=" + this.data + ", tag=" + this.tag + '}';
    }
}

