/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.api.minecraft.chunks;

import com.viaversion.viaversion.api.minecraft.chunks.ChunkSection;

public class NibbleArray {
    private final byte[] handle;

    public NibbleArray(int n2) {
        if (n2 == 0 || n2 % 2 != 0) {
            throw new IllegalArgumentException("Length of nibble array must be a positive number dividable by 2!");
        }
        this.handle = new byte[n2 / 2];
    }

    public NibbleArray(byte[] byArray) {
        if (byArray.length == 0 || byArray.length % 2 != 0) {
            throw new IllegalArgumentException("Length of nibble array must be a positive number dividable by 2!");
        }
        this.handle = byArray;
    }

    public byte get(int n2, int n3, int n4) {
        return this.get(ChunkSection.index(n2, n3, n4));
    }

    public byte get(int n2) {
        byte by2 = this.handle[n2 / 2];
        if (n2 % 2 == 0) {
            return (byte)(by2 & 0xF);
        }
        return (byte)(by2 >> 4 & 0xF);
    }

    public void set(int n2, int n3, int n4, int n5) {
        this.set(ChunkSection.index(n2, n3, n4), n5);
    }

    public void set(int n2, int n3) {
        this.handle[n2 /= 2] = n2 % 2 == 0 ? (byte)(this.handle[n2] & 0xF0 | n3 & 0xF) : (byte)(this.handle[n2] & 0xF | (n3 & 0xF) << 4);
    }

    public byte[] getHandle() {
        return this.handle;
    }

    public void setHandle(byte[] byArray) {
        if (byArray.length != this.handle.length) {
            throw new IllegalArgumentException("Length of handle must equal to size of nibble array!");
        }
        System.arraycopy(byArray, 0, this.handle, 0, byArray.length);
    }
}

