/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.api.minecraft.chunks;

import com.viaversion.viaversion.api.minecraft.chunks.DataPalette;
import com.viaversion.viaversion.libs.fastutil.ints.Int2IntMap;
import com.viaversion.viaversion.libs.fastutil.ints.Int2IntOpenHashMap;
import com.viaversion.viaversion.libs.fastutil.ints.IntArrayList;
import com.viaversion.viaversion.libs.fastutil.ints.IntList;

public final class DataPaletteImpl
implements DataPalette {
    private final IntList palette;
    private final Int2IntMap inversePalette;
    private final int[] values;
    private final int sizeBits;

    public DataPaletteImpl(int n2) {
        this(n2, 8);
    }

    public DataPaletteImpl(int n2, int n3) {
        this.values = new int[n2];
        this.sizeBits = Integer.numberOfTrailingZeros(n2) / 3;
        this.palette = new IntArrayList(n3);
        this.inversePalette = new Int2IntOpenHashMap(n3);
        this.inversePalette.defaultReturnValue(-1);
    }

    @Override
    public int index(int n2, int n3, int n4) {
        return (n3 << this.sizeBits | n4) << this.sizeBits | n2;
    }

    @Override
    public int idAt(int n2) {
        int n3 = this.values[n2];
        return this.palette.getInt(n3);
    }

    @Override
    public void setIdAt(int n2, int n3) {
        int n4 = this.inversePalette.get(n3);
        if (n4 == -1) {
            n4 = this.palette.size();
            this.palette.add(n3);
            this.inversePalette.put(n3, n4);
        }
        this.values[n2] = n4;
    }

    @Override
    public int paletteIndexAt(int n2) {
        return this.values[n2];
    }

    @Override
    public void setPaletteIndexAt(int n2, int n3) {
        this.values[n2] = n3;
    }

    @Override
    public int size() {
        return this.palette.size();
    }

    @Override
    public int idByIndex(int n2) {
        return this.palette.getInt(n2);
    }

    @Override
    public void setIdByIndex(int n2, int n3) {
        int n4 = this.palette.set(n2, n3);
        if (n4 == n3) {
            return;
        }
        this.inversePalette.put(n3, n2);
        if (this.inversePalette.get(n4) == n2) {
            this.inversePalette.remove(n4);
            for (int i2 = 0; i2 < this.palette.size(); ++i2) {
                if (this.palette.getInt(i2) != n4) continue;
                this.inversePalette.put(n4, i2);
                break;
            }
        }
    }

    @Override
    public void replaceId(int n2, int n3) {
        int n4 = this.inversePalette.remove(n2);
        if (n4 == -1) {
            return;
        }
        this.inversePalette.put(n3, n4);
        for (int i2 = 0; i2 < this.palette.size(); ++i2) {
            if (this.palette.getInt(i2) != n2) continue;
            this.palette.set(i2, n3);
        }
    }

    @Override
    public void addId(int n2) {
        this.inversePalette.put(n2, this.palette.size());
        this.palette.add(n2);
    }
}

