/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.api.data;

import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.data.FullMappings;
import com.viaversion.viaversion.api.data.FullMappingsBase;
import com.viaversion.viaversion.api.data.IdentityMappings;
import com.viaversion.viaversion.api.data.IntArrayMappings;
import com.viaversion.viaversion.api.data.MappingDataLoader$AddConsumer;
import com.viaversion.viaversion.api.data.MappingDataLoader$MappingHolderSupplier;
import com.viaversion.viaversion.api.data.MappingDataLoader$MappingsSupplier;
import com.viaversion.viaversion.api.data.Mappings;
import com.viaversion.viaversion.libs.gson.JsonIOException;
import com.viaversion.viaversion.libs.gson.JsonObject;
import com.viaversion.viaversion.libs.gson.JsonSyntaxException;
import com.viaversion.viaversion.libs.opennbt.NBTIO;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.ByteTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.CompoundTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.IntArrayTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.IntTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.ListTag;
import com.viaversion.viaversion.util.GsonUtil;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class MappingDataLoader {
    private static final Map<String, CompoundTag> MAPPINGS_CACHE = new HashMap<String, CompoundTag>();
    private static boolean cacheValid = true;

    public static void clearCache() {
        MAPPINGS_CACHE.clear();
        cacheValid = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static @Nullable JsonObject loadFromDataDir(String string) {
        File file = new File(Via.getPlatform().getDataFolder(), string);
        if (!file.exists()) {
            return MappingDataLoader.loadData(string);
        }
        try (FileReader fileReader = new FileReader(file);){
            JsonObject jsonObject = GsonUtil.getGson().fromJson((Reader)fileReader, JsonObject.class);
            return jsonObject;
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            Via.getPlatform().getLogger().warning(string + " is badly formatted!");
            throw new RuntimeException(jsonSyntaxException);
        }
        catch (JsonIOException | IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static @Nullable JsonObject loadData(String string) {
        InputStream inputStream = MappingDataLoader.getResource(string);
        if (inputStream == null) {
            return null;
        }
        try (InputStreamReader inputStreamReader = new InputStreamReader(inputStream);){
            JsonObject jsonObject = GsonUtil.getGson().fromJson((Reader)inputStreamReader, JsonObject.class);
            return jsonObject;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static @Nullable CompoundTag loadNBT(String string, boolean bl2) {
        if (!cacheValid) {
            return MappingDataLoader.loadNBTFromFile(string);
        }
        CompoundTag compoundTag = MAPPINGS_CACHE.get(string);
        if (compoundTag != null) {
            return compoundTag;
        }
        compoundTag = MappingDataLoader.loadNBTFromFile(string);
        if (bl2 && compoundTag != null) {
            MAPPINGS_CACHE.put(string, compoundTag);
        }
        return compoundTag;
    }

    public static @Nullable CompoundTag loadNBT(String string) {
        return MappingDataLoader.loadNBT(string, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static @Nullable CompoundTag loadNBTFromFile(String string) {
        InputStream inputStream = MappingDataLoader.getResource(string);
        if (inputStream == null) {
            return null;
        }
        try (InputStream inputStream2 = inputStream;){
            CompoundTag compoundTag = NBTIO.readTag(inputStream2);
            return compoundTag;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static @Nullable Mappings loadMappings(CompoundTag compoundTag, String string) {
        return MappingDataLoader.loadMappings(compoundTag, string, n2 -> {
            int[] nArray = new int[n2];
            Arrays.fill(nArray, -1);
            return nArray;
        }, (nArray, n2, n3) -> {
            nArray[n2] = n3;
        }, IntArrayMappings::of);
    }

    public static <M extends Mappings, V> @Nullable Mappings loadMappings(CompoundTag compoundTag, String string, MappingDataLoader$MappingHolderSupplier<V> mappingDataLoader$MappingHolderSupplier, MappingDataLoader$AddConsumer<V> mappingDataLoader$AddConsumer, MappingDataLoader$MappingsSupplier<M, V> mappingDataLoader$MappingsSupplier) {
        V v2;
        CompoundTag compoundTag2 = (CompoundTag)compoundTag.get(string);
        if (compoundTag2 == null) {
            return null;
        }
        ByteTag byteTag = (ByteTag)compoundTag2.get("id");
        IntTag intTag = (IntTag)compoundTag2.get("mappedSize");
        byte by2 = byteTag.asByte();
        if (by2 == 0) {
            IntArrayTag intArrayTag = (IntArrayTag)compoundTag2.get("val");
            return IntArrayMappings.of(intArrayTag.getValue(), intTag.asInt());
        }
        if (by2 == 1) {
            int n2;
            int n3;
            IntArrayTag intArrayTag = (IntArrayTag)compoundTag2.get("at");
            IntArrayTag intArrayTag2 = (IntArrayTag)compoundTag2.get("to");
            IntTag intTag2 = (IntTag)compoundTag2.get("size");
            int[] nArray = intArrayTag.getValue();
            int[] nArray2 = intArrayTag2.getValue();
            int n4 = intTag2.asInt();
            v2 = mappingDataLoader$MappingHolderSupplier.get(n4);
            if (nArray[0] != 0) {
                n3 = nArray[0];
                for (n2 = 0; n2 < n3; ++n2) {
                    mappingDataLoader$AddConsumer.addTo(v2, n2, n2);
                }
            }
            for (n3 = 0; n3 < nArray.length; ++n3) {
                n2 = nArray[n3];
                int n5 = n3 == nArray.length - 1 ? n4 : nArray[n3 + 1];
                int n6 = nArray2[n3];
                for (int i2 = n2; i2 < n5; ++i2) {
                    mappingDataLoader$AddConsumer.addTo(v2, i2, n6++);
                }
            }
        } else if (by2 == 2) {
            IntArrayTag intArrayTag = (IntArrayTag)compoundTag2.get("at");
            IntArrayTag intArrayTag3 = (IntArrayTag)compoundTag2.get("val");
            IntTag intTag3 = (IntTag)compoundTag2.get("size");
            boolean bl2 = compoundTag2.get("nofill") == null;
            int[] nArray = intArrayTag.getValue();
            int[] nArray3 = intArrayTag3.getValue();
            v2 = mappingDataLoader$MappingHolderSupplier.get(intTag3.asInt());
            for (int i3 = 0; i3 < nArray.length; ++i3) {
                int n7 = nArray[i3];
                if (bl2) {
                    int n8;
                    for (int i4 = n8 = i3 != 0 ? nArray[i3 - 1] + 1 : 0; i4 < n7; ++i4) {
                        mappingDataLoader$AddConsumer.addTo(v2, i4, i4);
                    }
                }
                mappingDataLoader$AddConsumer.addTo(v2, n7, nArray3[i3]);
            }
        } else {
            if (by2 == 3) {
                IntTag intTag4 = (IntTag)compoundTag2.get("size");
                return new IdentityMappings(intTag4.asInt(), intTag.asInt());
            }
            throw new IllegalArgumentException("Unknown serialization strategy: " + by2);
        }
        return mappingDataLoader$MappingsSupplier.create(v2, intTag.asInt());
    }

    public static FullMappings loadFullMappings(CompoundTag compoundTag, CompoundTag compoundTag2, CompoundTag compoundTag3, String string) {
        ListTag listTag = (ListTag)compoundTag2.get(string);
        ListTag listTag2 = (ListTag)compoundTag3.get(string);
        if (listTag == null || listTag2 == null) {
            return null;
        }
        Mappings mappings = MappingDataLoader.loadMappings(compoundTag, string);
        if (mappings == null) {
            mappings = new IdentityMappings(listTag.size(), listTag2.size());
        }
        return new FullMappingsBase(listTag.getValue().stream().map(tag -> (String)tag.getValue()).collect(Collectors.toList()), listTag2.getValue().stream().map(tag -> (String)tag.getValue()).collect(Collectors.toList()), mappings);
    }

    public static @Nullable InputStream getResource(String string) {
        return MappingDataLoader.class.getClassLoader().getResourceAsStream("assets/viaversion/data/" + string);
    }
}

