/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.api.connection;

import com.viaversion.viaversion.api.connection.ProtocolInfo;
import com.viaversion.viaversion.api.connection.StorableObject;
import com.viaversion.viaversion.api.data.entity.EntityTracker;
import com.viaversion.viaversion.api.protocol.Protocol;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface UserConnection {
    public <T extends StorableObject> @Nullable T get(Class<T> var1);

    public boolean has(Class<? extends StorableObject> var1);

    public <T extends StorableObject> @Nullable T remove(Class<T> var1);

    public void put(StorableObject var1);

    public <T extends EntityTracker> @Nullable T getEntityTracker(Class<? extends Protocol> var1);

    public void addEntityTracker(Class<? extends Protocol> var1, EntityTracker var2);

    public void sendRawPacket(ByteBuf var1);

    public void scheduleSendRawPacket(ByteBuf var1);

    public ChannelFuture sendRawPacketFuture(ByteBuf var1);

    public void disconnect(String var1);

    public void sendRawPacketToServer(ByteBuf var1);

    public boolean checkServerboundPacket();

    public boolean checkClientboundPacket();

    default public boolean checkIncomingPacket() {
        return this.isClientSide() ? this.checkClientboundPacket() : this.checkServerboundPacket();
    }

    default public boolean checkOutgoingPacket() {
        return this.isClientSide() ? this.checkServerboundPacket() : this.checkClientboundPacket();
    }

    public boolean shouldTransformPacket();

    public void transformClientbound(ByteBuf var1, Function<Throwable, Exception> var2);

    public void transformServerbound(ByteBuf var1, Function<Throwable, Exception> var2);

    default public void transformOutgoing(ByteBuf byteBuf, Function<Throwable, Exception> function) {
        if (this.isClientSide()) {
            this.transformServerbound(byteBuf, function);
        } else {
            this.transformClientbound(byteBuf, function);
        }
    }

    default public void transformIncoming(ByteBuf byteBuf, Function<Throwable, Exception> function) {
        if (this.isClientSide()) {
            this.transformClientbound(byteBuf, function);
        } else {
            this.transformServerbound(byteBuf, function);
        }
    }

    public @Nullable Channel getChannel();

    public ProtocolInfo getProtocolInfo();

    public void setActive(boolean var1);

    public boolean isClientSide();

    public boolean shouldApplyBlockProtocol();
}

