/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viabackwards.api.rewriters;

import com.viaversion.viabackwards.ViaBackwards;
import com.viaversion.viabackwards.api.BackwardsProtocol;
import com.viaversion.viabackwards.api.data.VBMappingDataLoader;
import com.viaversion.viabackwards.api.rewriters.TranslatableRewriter$1;
import com.viaversion.viabackwards.api.rewriters.TranslatableRewriter$2;
import com.viaversion.viabackwards.api.rewriters.TranslatableRewriter$3;
import com.viaversion.viaversion.api.protocol.packet.ClientboundPacketType;
import com.viaversion.viaversion.api.protocol.packet.State;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.libs.gson.JsonElement;
import com.viaversion.viaversion.libs.gson.JsonObject;
import com.viaversion.viaversion.rewriter.ComponentRewriter;
import java.util.HashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TranslatableRewriter<C extends ClientboundPacketType>
extends ComponentRewriter<C> {
    private static final Map<String, Map<String, String>> TRANSLATABLES = new HashMap<String, Map<String, String>>();
    private final Map<String, String> newTranslatables;

    public static void loadTranslatables() {
        JsonObject jsonObject = VBMappingDataLoader.loadFromDataDir("translation-mappings.json");
        for (Map.Entry<String, JsonElement> entry : jsonObject.entrySet()) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            TRANSLATABLES.put(entry.getKey(), hashMap);
            for (Map.Entry<String, JsonElement> entry2 : entry.getValue().getAsJsonObject().entrySet()) {
                hashMap.put(entry2.getKey(), entry2.getValue().getAsString());
            }
        }
    }

    public TranslatableRewriter(BackwardsProtocol<C, ?, ?, ?> backwardsProtocol) {
        this(backwardsProtocol, backwardsProtocol.getClass().getSimpleName().split("To")[1].replace("_", "."));
    }

    public TranslatableRewriter(BackwardsProtocol<C, ?, ?, ?> backwardsProtocol, String string) {
        super(backwardsProtocol);
        Map<String, String> map = TRANSLATABLES.get(string);
        if (map == null) {
            ViaBackwards.getPlatform().getLogger().warning("Error loading " + string + " translatables!");
            this.newTranslatables = new HashMap<String, String>();
        } else {
            this.newTranslatables = map;
        }
    }

    public void registerPing() {
        this.protocol.registerClientbound(State.LOGIN, 0, 0, packetWrapper -> this.processText(packetWrapper.passthrough(Type.COMPONENT)));
    }

    public void registerDisconnect(C c2) {
        this.protocol.registerClientbound(c2, packetWrapper -> this.processText(packetWrapper.passthrough(Type.COMPONENT)));
    }

    public void registerLegacyOpenWindow(C c2) {
        this.protocol.registerClientbound(c2, new TranslatableRewriter$1(this));
    }

    public void registerOpenWindow(C c2) {
        this.protocol.registerClientbound(c2, new TranslatableRewriter$2(this));
    }

    public void registerTabList(C c2) {
        this.protocol.registerClientbound(c2, packetWrapper -> {
            this.processText(packetWrapper.passthrough(Type.COMPONENT));
            this.processText(packetWrapper.passthrough(Type.COMPONENT));
        });
    }

    public void registerCombatKill(C c2) {
        this.protocol.registerClientbound(c2, new TranslatableRewriter$3(this));
    }

    @Override
    protected void handleTranslate(JsonObject jsonObject, String string) {
        String string2 = this.mappedTranslationKey(string);
        if (string2 != null) {
            jsonObject.addProperty("translate", string2);
        }
    }

    public @Nullable String mappedTranslationKey(String string) {
        return this.newTranslatables.get(string);
    }
}

