/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viabackwards.api.rewriters;

import com.viaversion.viabackwards.ViaBackwards;
import com.viaversion.viabackwards.api.BackwardsProtocol;
import com.viaversion.viabackwards.api.entities.storage.EntityData;
import com.viaversion.viabackwards.api.entities.storage.EntityObjectData;
import com.viaversion.viabackwards.api.entities.storage.WrappedMetadata;
import com.viaversion.viabackwards.api.rewriters.EntityRewriterBase;
import com.viaversion.viabackwards.api.rewriters.LegacyEntityRewriter$1;
import com.viaversion.viabackwards.api.rewriters.LegacyEntityRewriter$2;
import com.viaversion.viabackwards.api.rewriters.LegacyEntityRewriter$3;
import com.viaversion.viaversion.api.minecraft.entities.EntityType;
import com.viaversion.viaversion.api.minecraft.entities.ObjectType;
import com.viaversion.viaversion.api.minecraft.metadata.MetaType;
import com.viaversion.viaversion.api.minecraft.metadata.Metadata;
import com.viaversion.viaversion.api.minecraft.metadata.types.MetaType1_9;
import com.viaversion.viaversion.api.protocol.packet.ClientboundPacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandler;
import com.viaversion.viaversion.api.type.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class LegacyEntityRewriter<C extends ClientboundPacketType, T extends BackwardsProtocol<C, ?, ?, ?>>
extends EntityRewriterBase<C, T> {
    private final Map<ObjectType, EntityData> objectTypes = new HashMap<ObjectType, EntityData>();

    protected LegacyEntityRewriter(T t2) {
        this(t2, MetaType1_9.String, MetaType1_9.Boolean);
    }

    protected LegacyEntityRewriter(T t2, MetaType metaType, MetaType metaType2) {
        super(t2, metaType, 2, metaType2, 3);
    }

    protected EntityObjectData mapObjectType(ObjectType objectType, ObjectType objectType2, int n2) {
        EntityObjectData entityObjectData = new EntityObjectData((BackwardsProtocol)this.protocol, objectType.getType().name(), objectType.getId(), objectType2.getId(), n2);
        this.objectTypes.put(objectType, entityObjectData);
        return entityObjectData;
    }

    protected @Nullable EntityData getObjectData(ObjectType objectType) {
        return this.objectTypes.get(objectType);
    }

    protected void registerRespawn(C c2) {
        ((BackwardsProtocol)this.protocol).registerClientbound(c2, new LegacyEntityRewriter$1(this));
    }

    protected void registerJoinGame(C c2, EntityType entityType) {
        ((BackwardsProtocol)this.protocol).registerClientbound(c2, new LegacyEntityRewriter$2(this, entityType));
    }

    @Override
    public void registerMetadataRewriter(C c2, Type<List<Metadata>> type, Type<List<Metadata>> type2) {
        ((BackwardsProtocol)this.protocol).registerClientbound(c2, new LegacyEntityRewriter$3(this, type, type2));
    }

    @Override
    public void registerMetadataRewriter(C c2, Type<List<Metadata>> type) {
        this.registerMetadataRewriter(c2, null, type);
    }

    protected PacketHandler getMobSpawnRewriter(Type<List<Metadata>> type) {
        return packetWrapper -> {
            int n2 = packetWrapper.get(Type.VAR_INT, 0);
            EntityType entityType = this.tracker(packetWrapper.user()).entityType(n2);
            List list = (List)packetWrapper.get(type, 0);
            this.handleMetadata(n2, list, packetWrapper.user());
            EntityData entityData = this.entityDataForType(entityType);
            if (entityData != null) {
                packetWrapper.set(Type.VAR_INT, 1, entityData.replacementId());
                if (entityData.hasBaseMeta()) {
                    entityData.defaultMeta().createMeta(new WrappedMetadata(list));
                }
            }
        };
    }

    protected PacketHandler getObjectTrackerHandler() {
        return packetWrapper -> this.addTrackedEntity(packetWrapper, packetWrapper.get(Type.VAR_INT, 0), this.getObjectTypeFromId(packetWrapper.get(Type.BYTE, 0).byteValue()));
    }

    protected PacketHandler getTrackerAndMetaHandler(Type<List<Metadata>> type, EntityType entityType) {
        return packetWrapper -> {
            this.addTrackedEntity(packetWrapper, packetWrapper.get(Type.VAR_INT, 0), entityType);
            List list = (List)packetWrapper.get(type, 0);
            this.handleMetadata(packetWrapper.get(Type.VAR_INT, 0), list, packetWrapper.user());
        };
    }

    protected PacketHandler getObjectRewriter(Function<Byte, ObjectType> function) {
        return packetWrapper -> {
            ObjectType objectType = (ObjectType)function.apply(packetWrapper.get(Type.BYTE, 0));
            if (objectType == null) {
                ViaBackwards.getPlatform().getLogger().warning("Could not find Entity Type" + packetWrapper.get(Type.BYTE, 0));
                return;
            }
            EntityData entityData = this.getObjectData(objectType);
            if (entityData != null) {
                packetWrapper.set(Type.BYTE, 0, (byte)entityData.replacementId());
                if (entityData.objectData() != -1) {
                    packetWrapper.set(Type.INT, 0, entityData.objectData());
                }
            }
        };
    }

    protected EntityType getObjectTypeFromId(int n2) {
        return this.typeFromId(n2);
    }

    @Deprecated
    protected void addTrackedEntity(PacketWrapper packetWrapper, int n2, EntityType entityType) {
        this.tracker(packetWrapper.user()).addEntity(n2, entityType);
    }
}

