/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viabackwards.api.rewriters;

import com.viaversion.viabackwards.api.BackwardsProtocol;
import com.viaversion.viabackwards.api.data.MappedLegacyBlockItem;
import com.viaversion.viabackwards.api.data.VBMappingDataLoader;
import com.viaversion.viabackwards.api.rewriters.ItemRewriterBase;
import com.viaversion.viabackwards.api.rewriters.LegacyBlockItemRewriter$Pos;
import com.viaversion.viabackwards.protocol.protocol1_11_1to1_12.data.BlockColors;
import com.viaversion.viabackwards.utils.Block;
import com.viaversion.viaversion.api.minecraft.chunks.Chunk;
import com.viaversion.viaversion.api.minecraft.chunks.ChunkSection;
import com.viaversion.viaversion.api.minecraft.chunks.PaletteType;
import com.viaversion.viaversion.api.minecraft.item.Item;
import com.viaversion.viaversion.api.protocol.packet.ClientboundPacketType;
import com.viaversion.viaversion.api.protocol.packet.ServerboundPacketType;
import com.viaversion.viaversion.libs.fastutil.ints.Int2ObjectMap;
import com.viaversion.viaversion.libs.fastutil.ints.Int2ObjectOpenHashMap;
import com.viaversion.viaversion.libs.gson.JsonElement;
import com.viaversion.viaversion.libs.gson.JsonObject;
import com.viaversion.viaversion.libs.gson.JsonPrimitive;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.ByteTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.CompoundTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.IntTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.NumberTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.StringTag;
import com.viaversion.viaversion.protocols.protocol1_13to1_12_2.ChatRewriter;
import java.util.HashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class LegacyBlockItemRewriter<C extends ClientboundPacketType, S extends ServerboundPacketType, T extends BackwardsProtocol<C, ?, ?, S>>
extends ItemRewriterBase<C, S, T> {
    private static final Map<String, Int2ObjectMap<MappedLegacyBlockItem>> LEGACY_MAPPINGS = new HashMap<String, Int2ObjectMap<MappedLegacyBlockItem>>();
    protected final Int2ObjectMap<MappedLegacyBlockItem> replacementData;

    protected LegacyBlockItemRewriter(T t2) {
        super(t2, false);
        this.replacementData = LEGACY_MAPPINGS.get(t2.getClass().getSimpleName().split("To")[1].replace("_", "."));
    }

    @Override
    public @Nullable Item handleItemToClient(@Nullable Item item) {
        if (item == null) {
            return null;
        }
        MappedLegacyBlockItem mappedLegacyBlockItem = (MappedLegacyBlockItem)this.replacementData.get(item.identifier());
        if (mappedLegacyBlockItem == null) {
            return super.handleItemToClient(item);
        }
        short s2 = item.data();
        item.setIdentifier(mappedLegacyBlockItem.getId());
        if (mappedLegacyBlockItem.getData() != -1) {
            item.setData(mappedLegacyBlockItem.getData());
        }
        if (mappedLegacyBlockItem.getName() != null) {
            String string;
            StringTag stringTag;
            CompoundTag compoundTag;
            if (item.tag() == null) {
                item.setTag(new CompoundTag());
            }
            if ((compoundTag = (CompoundTag)item.tag().get("display")) == null) {
                compoundTag = new CompoundTag();
                item.tag().put("display", compoundTag);
            }
            if ((stringTag = (StringTag)compoundTag.get("Name")) == null) {
                stringTag = new StringTag(mappedLegacyBlockItem.getName());
                compoundTag.put("Name", stringTag);
                compoundTag.put(this.nbtTagName + "|customName", new ByteTag());
            }
            if ((string = stringTag.getValue()).contains("%vb_color%")) {
                compoundTag.put("Name", new StringTag(string.replace("%vb_color%", BlockColors.get(s2))));
            }
        }
        return item;
    }

    public int handleBlockID(int n2) {
        int n3 = n2 >> 4;
        int n4 = n2 & 0xF;
        Block block = this.handleBlock(n3, n4);
        if (block == null) {
            return n2;
        }
        return block.getId() << 4 | block.getData() & 0xF;
    }

    public @Nullable Block handleBlock(int n2, int n3) {
        MappedLegacyBlockItem mappedLegacyBlockItem = (MappedLegacyBlockItem)this.replacementData.get(n2);
        if (mappedLegacyBlockItem == null || !mappedLegacyBlockItem.isBlock()) {
            return null;
        }
        Block block = mappedLegacyBlockItem.getBlock();
        if (block.getData() == -1) {
            return block.withData(n3);
        }
        return block;
    }

    protected void handleChunk(Chunk chunk) {
        int n2;
        MappedLegacyBlockItem mappedLegacyBlockItem;
        Object object;
        HashMap<LegacyBlockItemRewriter$Pos, CompoundTag> hashMap = new HashMap<LegacyBlockItemRewriter$Pos, CompoundTag>();
        for (CompoundTag object2 : chunk.getBlockEntities()) {
            int n7;
            ChunkSection i4;
            Object t2;
            Object t3 = object2.get("x");
            if (t3 == null || (object = object2.get("y")) == null || (t2 = object2.get("z")) == null) continue;
            LegacyBlockItemRewriter$Pos i3 = new LegacyBlockItemRewriter$Pos(((NumberTag)t3).asInt() & 0xF, ((NumberTag)object).asInt(), ((NumberTag)t2).asInt() & 0xF, null);
            hashMap.put(i3, object2);
            if (i3.getY() < 0 || i3.getY() > 255 || (i4 = chunk.getSections()[i3.getY() >> 4]) == null || (mappedLegacyBlockItem = (MappedLegacyBlockItem)this.replacementData.get(n7 = (n2 = i4.palette(PaletteType.BLOCKS).idAt(i3.getX(), i3.getY() & 0xF, i3.getZ())) >> 4)) == null || !mappedLegacyBlockItem.hasBlockEntityHandler()) continue;
            mappedLegacyBlockItem.getBlockEntityHandler().handleOrNewCompoundTag(n2, object2);
        }
        for (int i2 = 0; i2 < chunk.getSections().length; ++i2) {
            int n3;
            ChunkSection chunkSection = chunk.getSections()[i2];
            if (chunkSection == null) continue;
            boolean bl2 = false;
            object = chunkSection.palette(PaletteType.BLOCKS);
            for (n3 = 0; n3 < object.size(); ++n3) {
                int n4 = object.idByIndex(n3);
                int n5 = n4 >> 4;
                Block block = this.handleBlock(n5, n2 = n4 & 0xF);
                if (block != null) {
                    object.setIdByIndex(n3, block.getId() << 4 | block.getData() & 0xF);
                }
                if (bl2 || (mappedLegacyBlockItem = (MappedLegacyBlockItem)this.replacementData.get(n5)) == null || !mappedLegacyBlockItem.hasBlockEntityHandler()) continue;
                bl2 = true;
            }
            if (!bl2) continue;
            for (n3 = 0; n3 < 16; ++n3) {
                for (int i3 = 0; i3 < 16; ++i3) {
                    for (int i4 = 0; i4 < 16; ++i4) {
                        LegacyBlockItemRewriter$Pos legacyBlockItemRewriter$Pos;
                        n2 = object.idAt(n3, i3, i4);
                        int n6 = n2 >> 4;
                        int n7 = n2 & 0xF;
                        MappedLegacyBlockItem mappedLegacyBlockItem2 = (MappedLegacyBlockItem)this.replacementData.get(n6);
                        if (mappedLegacyBlockItem2 == null || !mappedLegacyBlockItem2.hasBlockEntityHandler() || hashMap.containsKey(legacyBlockItemRewriter$Pos = new LegacyBlockItemRewriter$Pos(n3, i3 + (i2 << 4), i4, null))) continue;
                        CompoundTag compoundTag = new CompoundTag();
                        compoundTag.put("x", new IntTag(n3 + (chunk.getX() << 4)));
                        compoundTag.put("y", new IntTag(i3 + (i2 << 4)));
                        compoundTag.put("z", new IntTag(i4 + (chunk.getZ() << 4)));
                        mappedLegacyBlockItem2.getBlockEntityHandler().handleOrNewCompoundTag(n2, compoundTag);
                        chunk.getBlockEntities().add(compoundTag);
                    }
                }
            }
        }
    }

    protected CompoundTag getNamedTag(String string) {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.put("display", new CompoundTag());
        string = "\u00a7r" + string;
        ((CompoundTag)compoundTag.get("display")).put("Name", new StringTag(this.jsonNameFormat ? ChatRewriter.legacyTextToJsonString(string) : string));
        return compoundTag;
    }

    static {
        JsonObject jsonObject = VBMappingDataLoader.loadFromDataDir("legacy-mappings.json");
        for (Map.Entry<String, JsonElement> entry : jsonObject.entrySet()) {
            Int2ObjectOpenHashMap<MappedLegacyBlockItem> int2ObjectOpenHashMap = new Int2ObjectOpenHashMap<MappedLegacyBlockItem>(8);
            LEGACY_MAPPINGS.put(entry.getKey(), int2ObjectOpenHashMap);
            for (Map.Entry<String, JsonElement> entry2 : entry.getValue().getAsJsonObject().entrySet()) {
                boolean bl2;
                JsonObject jsonObject2 = entry2.getValue().getAsJsonObject();
                int n2 = jsonObject2.getAsJsonPrimitive("id").getAsInt();
                JsonPrimitive jsonPrimitive = jsonObject2.getAsJsonPrimitive("data");
                short s2 = jsonPrimitive != null ? jsonPrimitive.getAsShort() : (short)0;
                String string = jsonObject2.getAsJsonPrimitive("name").getAsString();
                JsonPrimitive jsonPrimitive2 = jsonObject2.getAsJsonPrimitive("block");
                boolean bl3 = bl2 = jsonPrimitive2 != null && jsonPrimitive2.getAsBoolean();
                if (entry2.getKey().indexOf(45) != -1) {
                    String[] stringArray = entry2.getKey().split("-", 2);
                    int n3 = Integer.parseInt(stringArray[0]);
                    int n4 = Integer.parseInt(stringArray[1]);
                    if (string.contains("%color%")) {
                        for (int i2 = n3; i2 <= n4; ++i2) {
                            int2ObjectOpenHashMap.put(i2, new MappedLegacyBlockItem(n2, s2, string.replace("%color%", BlockColors.get(i2 - n3)), bl2));
                        }
                        continue;
                    }
                    MappedLegacyBlockItem mappedLegacyBlockItem = new MappedLegacyBlockItem(n2, s2, string, bl2);
                    for (int i3 = n3; i3 <= n4; ++i3) {
                        int2ObjectOpenHashMap.put(i3, mappedLegacyBlockItem);
                    }
                    continue;
                }
                int2ObjectOpenHashMap.put(Integer.parseInt(entry2.getKey()), new MappedLegacyBlockItem(n2, s2, string, bl2));
            }
        }
    }
}

