/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viabackwards.api.rewriters;

import com.google.common.base.X;
import com.viaversion.viabackwards.ViaBackwards;
import com.viaversion.viabackwards.api.BackwardsProtocol;
import com.viaversion.viabackwards.api.entities.storage.EntityData;
import com.viaversion.viabackwards.api.entities.storage.WrappedMetadata;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.data.Int2IntMapMappings;
import com.viaversion.viaversion.api.data.entity.StoredEntityData;
import com.viaversion.viaversion.api.data.entity.TrackedEntity;
import com.viaversion.viaversion.api.minecraft.entities.EntityType;
import com.viaversion.viaversion.api.minecraft.item.Item;
import com.viaversion.viaversion.api.minecraft.metadata.MetaType;
import com.viaversion.viaversion.api.minecraft.metadata.Metadata;
import com.viaversion.viaversion.api.protocol.packet.ClientboundPacketType;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandler;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.types.Particle;
import com.viaversion.viaversion.libs.fastutil.ints.Int2ObjectMap;
import com.viaversion.viaversion.libs.fastutil.ints.Int2ObjectOpenHashMap;
import com.viaversion.viaversion.libs.gson.JsonElement;
import com.viaversion.viaversion.protocols.protocol1_9_3to1_9_1_2.storage.ClientWorld;
import com.viaversion.viaversion.rewriter.EntityRewriter;
import com.viaversion.viaversion.rewriter.meta.MetaHandlerEvent;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class EntityRewriterBase<C extends ClientboundPacketType, T extends BackwardsProtocol<C, ?, ?, ?>>
extends EntityRewriter<C, T> {
    private final Int2ObjectMap<EntityData> entityDataMappings = new Int2ObjectOpenHashMap<EntityData>();
    private final MetaType displayNameMetaType;
    private final MetaType displayVisibilityMetaType;
    private final int displayNameIndex;
    private final int displayVisibilityIndex;

    EntityRewriterBase(T t2, MetaType metaType, int n2, MetaType metaType2, int n3) {
        super(t2, false);
        this.displayNameMetaType = metaType;
        this.displayNameIndex = n2;
        this.displayVisibilityMetaType = metaType2;
        this.displayVisibilityIndex = n3;
    }

    @Override
    public void handleMetadata(int n2, List<Metadata> list, UserConnection userConnection) {
        TrackedEntity trackedEntity = this.tracker(userConnection).entity(n2);
        boolean bl2 = trackedEntity == null || !trackedEntity.hasSentMetadata();
        super.handleMetadata(n2, list, userConnection);
        if (trackedEntity == null) {
            return;
        }
        EntityData entityData = this.entityDataForType(trackedEntity.entityType());
        if (entityData != null && entityData.mobName() != null) {
            Metadata metadata = this.getMeta(this.displayNameIndex, list);
            if (bl2) {
                if (metadata == null) {
                    list.add(new Metadata(this.displayNameIndex, this.displayNameMetaType, entityData.mobName()));
                    this.addDisplayVisibilityMeta(list);
                } else if (metadata.getValue() == null || metadata.getValue().toString().isEmpty()) {
                    metadata.setValue(entityData.mobName());
                    this.addDisplayVisibilityMeta(list);
                }
            } else if (metadata != null && (metadata.getValue() == null || metadata.getValue().toString().isEmpty())) {
                metadata.setValue(entityData.mobName());
                this.addDisplayVisibilityMeta(list);
            }
        }
        if (entityData != null && entityData.hasBaseMeta() && bl2) {
            entityData.defaultMeta().createMeta(new WrappedMetadata(list));
        }
    }

    private void addDisplayVisibilityMeta(List<Metadata> list) {
        if (ViaBackwards.getConfig().alwaysShowOriginalMobName()) {
            this.removeMeta(this.displayVisibilityIndex, list);
            list.add(new Metadata(this.displayVisibilityIndex, this.displayVisibilityMetaType, true));
        }
    }

    protected @Nullable Metadata getMeta(int n2, List<Metadata> list) {
        for (Metadata metadata : list) {
            if (metadata.id() != n2) continue;
            return metadata;
        }
        return null;
    }

    protected void removeMeta(int n2, List<Metadata> list) {
        list.removeIf(metadata -> metadata.id() == n2);
    }

    protected boolean hasData(EntityType entityType) {
        return this.entityDataMappings.containsKey(entityType.getId());
    }

    protected @Nullable EntityData entityDataForType(EntityType entityType) {
        return (EntityData)this.entityDataMappings.get(entityType.getId());
    }

    protected @Nullable StoredEntityData storedEntityData(MetaHandlerEvent metaHandlerEvent) {
        return this.tracker(metaHandlerEvent.user()).entityData(metaHandlerEvent.entityId());
    }

    protected EntityData mapEntityTypeWithData(EntityType entityType, EntityType entityType2) {
        X.PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_(entityType.getClass() == entityType2.getClass(), "Both entity types need to be of the same class");
        int n2 = this.newEntityId(entityType2.getId());
        EntityData entityData = new EntityData((BackwardsProtocol)this.protocol, entityType, n2);
        this.mapEntityType(entityType.getId(), n2);
        this.entityDataMappings.put(entityType.getId(), entityData);
        return entityData;
    }

    @Override
    public <E extends Enum<E>> void mapTypes(EntityType[] entityTypeArray, Class<E> clazz) {
        if (this.typeMappings == null) {
            this.typeMappings = Int2IntMapMappings.of();
        }
        for (EntityType entityType : entityTypeArray) {
            try {
                E e2 = Enum.valueOf(clazz, entityType.name());
                this.typeMappings.setNewId(entityType.getId(), ((EntityType)e2).getId());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public void registerMetaTypeHandler(@Nullable MetaType metaType, @Nullable MetaType metaType2, @Nullable MetaType metaType3, @Nullable MetaType metaType4, @Nullable MetaType metaType5, @Nullable MetaType metaType6) {
        this.filter().handler((metaHandlerEvent, metadata) -> {
            JsonElement jsonElement;
            MetaType metaType7 = metadata.metaType();
            if (metaType7 == metaType) {
                ((BackwardsProtocol)this.protocol).getItemRewriter().handleItemToClient((Item)metadata.value());
            } else if (metaType7 == metaType2) {
                int n2 = (Integer)metadata.value();
                metadata.setValue(((BackwardsProtocol)this.protocol).getMappingData().getNewBlockStateId(n2));
            } else if (metaType7 == metaType3) {
                int n3 = (Integer)metadata.value();
                if (n3 != 0) {
                    metadata.setValue(((BackwardsProtocol)this.protocol).getMappingData().getNewBlockStateId(n3));
                }
            } else if (metaType7 == metaType4) {
                this.rewriteParticle((Particle)metadata.value());
            } else if ((metaType7 == metaType6 || metaType7 == metaType5) && (jsonElement = (JsonElement)metadata.value()) != null) {
                ((BackwardsProtocol)this.protocol).getTranslatableRewriter().processText(jsonElement);
            }
        });
    }

    protected PacketHandler getTrackerHandler(Type<? extends Number> type, int n2) {
        return packetWrapper -> {
            Number number = (Number)packetWrapper.get(type, n2);
            this.tracker(packetWrapper.user()).addEntity(packetWrapper.get(Type.VAR_INT, 0), this.typeFromId(number.intValue()));
        };
    }

    protected PacketHandler getTrackerHandler() {
        return this.getTrackerHandler(Type.VAR_INT, 1);
    }

    protected PacketHandler getTrackerHandler(EntityType entityType, Type<? extends Number> type) {
        return packetWrapper -> this.tracker(packetWrapper.user()).addEntity(((Number)packetWrapper.get(type, 0)).intValue(), entityType);
    }

    protected PacketHandler getDimensionHandler(int n2) {
        return packetWrapper -> {
            ClientWorld clientWorld = packetWrapper.user().get(ClientWorld.class);
            int n3 = packetWrapper.get(Type.INT, n2);
            clientWorld.setEnvironment(n3);
        };
    }
}

