/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viabackwards.api.entities.storage;

import com.viaversion.viabackwards.ViaBackwards;
import com.viaversion.viabackwards.api.entities.storage.EntityPositionStorage;
import com.viaversion.viabackwards.api.rewriters.EntityRewriterBase;
import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.data.entity.StoredEntityData;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.type.Type;
import java.util.function.Supplier;

public class EntityPositionHandler {
    private final EntityRewriterBase<?, ?> entityRewriter;
    private final Class<? extends EntityPositionStorage> storageClass;
    private final Supplier<? extends EntityPositionStorage> storageSupplier;
    private boolean warnedForMissingEntity;

    public EntityPositionHandler(EntityRewriterBase<?, ?> entityRewriterBase, Class<? extends EntityPositionStorage> clazz, Supplier<? extends EntityPositionStorage> supplier) {
        this.entityRewriter = entityRewriterBase;
        this.storageClass = clazz;
        this.storageSupplier = supplier;
    }

    public void cacheEntityPosition(PacketWrapper packetWrapper, boolean bl2, boolean bl3) {
        this.cacheEntityPosition(packetWrapper, packetWrapper.get(Type.DOUBLE, 0), packetWrapper.get(Type.DOUBLE, 1), packetWrapper.get(Type.DOUBLE, 2), bl2, bl3);
    }

    public void cacheEntityPosition(PacketWrapper packetWrapper, double d2, double d3, double d4, boolean bl2, boolean bl3) {
        EntityPositionStorage entityPositionStorage;
        int n2 = packetWrapper.get(Type.VAR_INT, 0);
        StoredEntityData storedEntityData = this.entityRewriter.tracker(packetWrapper.user()).entityData(n2);
        if (storedEntityData == null) {
            if (Via.getManager().isDebug()) {
                ViaBackwards.getPlatform().getLogger().warning("Stored entity with id " + n2 + " missing at position: " + d2 + " - " + d3 + " - " + d4 + " in " + this.storageClass.getSimpleName());
                if (n2 == -1 && d2 == 0.0 && d3 == 0.0 && d4 == 0.0) {
                    ViaBackwards.getPlatform().getLogger().warning("DO NOT REPORT THIS TO VIA, THIS IS A PLUGIN ISSUE");
                } else if (!this.warnedForMissingEntity) {
                    this.warnedForMissingEntity = true;
                    ViaBackwards.getPlatform().getLogger().warning("This is very likely caused by a plugin sending a teleport packet for an entity outside of the player's range.");
                }
            }
            return;
        }
        if (bl2) {
            entityPositionStorage = this.storageSupplier.get();
            storedEntityData.put(entityPositionStorage);
        } else {
            entityPositionStorage = storedEntityData.get(this.storageClass);
            if (entityPositionStorage == null) {
                ViaBackwards.getPlatform().getLogger().warning("Stored entity with id " + n2 + " missing " + this.storageClass.getSimpleName());
                return;
            }
        }
        entityPositionStorage.setCoordinates(d2, d3, d4, bl3);
    }

    public static void writeFacingDegrees(PacketWrapper packetWrapper, double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8 = d5 - d2;
        double d9 = d6 - d3;
        double d10 = d7 - d4;
        double d11 = Math.sqrt(d8 * d8 + d9 * d9 + d10 * d10);
        double d12 = -Math.atan2(d8, d10) / Math.PI * 180.0;
        if (d12 < 0.0) {
            d12 = 360.0 + d12;
        }
        double d13 = -Math.asin(d9 / d11) / Math.PI * 180.0;
        packetWrapper.write(Type.FLOAT, Float.valueOf((float)d12));
        packetWrapper.write(Type.FLOAT, Float.valueOf((float)d13));
    }
}

