/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viabackwards.api.entities.storage;

import com.viaversion.viabackwards.ViaBackwards;
import com.viaversion.viabackwards.api.BackwardsProtocol;
import com.viaversion.viabackwards.api.entities.storage.EntityData$MetaCreator;
import com.viaversion.viabackwards.api.entities.storage.EntityData$NameVisibility;
import com.viaversion.viaversion.api.minecraft.entities.EntityType;
import com.viaversion.viaversion.protocols.protocol1_13to1_12_2.ChatRewriter;
import java.util.Locale;
import org.checkerframework.checker.nullness.qual.Nullable;

public class EntityData {
    private final BackwardsProtocol<?, ?, ?, ?> protocol;
    private final int id;
    private final int replacementId;
    private final String key;
    private EntityData$NameVisibility nameVisibility = EntityData$NameVisibility.NONE;
    private EntityData$MetaCreator defaultMeta;

    public EntityData(BackwardsProtocol<?, ?, ?, ?> backwardsProtocol, EntityType entityType, int n2) {
        this(backwardsProtocol, entityType.name(), entityType.getId(), n2);
    }

    public EntityData(BackwardsProtocol<?, ?, ?, ?> backwardsProtocol, String string, int n2, int n3) {
        this.protocol = backwardsProtocol;
        this.id = n2;
        this.replacementId = n3;
        this.key = string.toLowerCase(Locale.ROOT);
    }

    public EntityData jsonName() {
        this.nameVisibility = EntityData$NameVisibility.JSON;
        return this;
    }

    public EntityData plainName() {
        this.nameVisibility = EntityData$NameVisibility.PLAIN;
        return this;
    }

    public EntityData spawnMetadata(EntityData$MetaCreator entityData$MetaCreator) {
        this.defaultMeta = entityData$MetaCreator;
        return this;
    }

    public boolean hasBaseMeta() {
        return this.defaultMeta != null;
    }

    public @Nullable Object mobName() {
        if (this.nameVisibility == EntityData$NameVisibility.NONE) {
            return null;
        }
        String string = this.protocol.getMappingData().mappedEntityName(this.key);
        if (string == null) {
            ViaBackwards.getPlatform().getLogger().warning("Entity name for " + this.key + " not found in protocol " + this.protocol.getClass().getSimpleName());
            string = this.key;
        }
        return this.nameVisibility == EntityData$NameVisibility.JSON ? ChatRewriter.legacyTextToJson(string) : string;
    }

    public int replacementId() {
        return this.replacementId;
    }

    public @Nullable EntityData$MetaCreator defaultMeta() {
        return this.defaultMeta;
    }

    public int objectData() {
        return -1;
    }

    public String toString() {
        return "EntityData{id=" + this.id + ", mobName='" + this.key + '\'' + ", replacementId=" + this.replacementId + ", defaultMeta=" + this.defaultMeta + '}';
    }
}

