/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webkit.perf;

import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.logging.PlatformLogger$Level;
import com.sun.webkit.perf.PerfLogger$1;
import com.sun.webkit.perf.PerfLogger$ProbeStat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public final class PerfLogger {
    private static Thread shutdownHook;
    private static Map<PlatformLogger, PerfLogger> loggers;
    private final HashMap<String, PerfLogger$ProbeStat> probes = new HashMap();
    private final PlatformLogger log;
    private final boolean isEnabled;
    private final Comparator timeComparator = (object, object2) -> {
        long l2 = this.probes.get((Object)((String)object)).totalTime;
        long l3 = this.probes.get((Object)((String)object2)).totalTime;
        if (l2 > l3) {
            return 1;
        }
        if (l2 < l3) {
            return -1;
        }
        return 0;
    };
    private final Comparator countComparator = (object, object2) -> {
        long l2 = this.probes.get((Object)((String)object)).count;
        long l3 = this.probes.get((Object)((String)object2)).count;
        if (l2 > l3) {
            return 1;
        }
        if (l2 < l3) {
            return -1;
        }
        return 0;
    };

    public static synchronized PerfLogger getLogger(PlatformLogger platformLogger) {
        PerfLogger perfLogger;
        if (loggers == null) {
            loggers = new HashMap<PlatformLogger, PerfLogger>();
        }
        if ((perfLogger = loggers.get(platformLogger)) == null) {
            perfLogger = new PerfLogger(platformLogger);
            loggers.put(platformLogger, perfLogger);
        }
        if (perfLogger.isEnabled() && shutdownHook == null) {
            shutdownHook = new PerfLogger$1();
            Runtime.getRuntime().addShutdownHook(shutdownHook);
        }
        return perfLogger;
    }

    public static synchronized PerfLogger getLogger(String string) {
        return PerfLogger.getLogger(PlatformLogger.getLogger("com.sun.webkit.perf." + string));
    }

    private PerfLogger(PlatformLogger platformLogger) {
        this.log = platformLogger;
        this.isEnabled = platformLogger.isLoggable(PlatformLogger$Level.FINE);
        this.startCount("TOTALTIME");
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    private synchronized String fullName(String string) {
        return this.log.getName() + "." + string;
    }

    public synchronized void reset() {
        for (Map.Entry<String, PerfLogger$ProbeStat> entry : this.probes.entrySet()) {
            entry.getValue().reset();
        }
        this.startCount("TOTALTIME");
    }

    public static synchronized void resetAll() {
        for (PerfLogger perfLogger : loggers.values()) {
            perfLogger.reset();
        }
    }

    private synchronized PerfLogger$ProbeStat registerProbe(String string) {
        String string2 = string.intern();
        if (this.probes.containsKey(string2)) {
            this.log.fine("Warning: \"" + this.fullName(string2) + "\" probe already exists");
        } else {
            this.log.fine("Registering \"" + this.fullName(string2) + "\" probe");
        }
        PerfLogger$ProbeStat perfLogger$ProbeStat = new PerfLogger$ProbeStat(string2);
        this.probes.put(string2, perfLogger$ProbeStat);
        return perfLogger$ProbeStat;
    }

    public synchronized PerfLogger$ProbeStat getProbeStat(String string) {
        String string2 = string.intern();
        PerfLogger$ProbeStat perfLogger$ProbeStat = this.probes.get(string2);
        if (perfLogger$ProbeStat != null) {
            perfLogger$ProbeStat.snapshot();
        }
        return perfLogger$ProbeStat;
    }

    public synchronized void startCount(String string) {
        if (!this.isEnabled()) {
            return;
        }
        String string2 = string.intern();
        PerfLogger$ProbeStat perfLogger$ProbeStat = this.probes.get(string2);
        if (perfLogger$ProbeStat == null) {
            perfLogger$ProbeStat = this.registerProbe(string2);
        }
        perfLogger$ProbeStat.reset();
        perfLogger$ProbeStat.resume();
    }

    public synchronized void suspendCount(String string) {
        if (!this.isEnabled()) {
            return;
        }
        String string2 = string.intern();
        PerfLogger$ProbeStat perfLogger$ProbeStat = this.probes.get(string2);
        if (perfLogger$ProbeStat != null) {
            perfLogger$ProbeStat.suspend();
        } else {
            this.log.fine("Warning: \"" + this.fullName(string2) + "\" probe is not registered");
        }
    }

    public synchronized void resumeCount(String string) {
        if (!this.isEnabled()) {
            return;
        }
        String string2 = string.intern();
        PerfLogger$ProbeStat perfLogger$ProbeStat = this.probes.get(string2);
        if (perfLogger$ProbeStat == null) {
            perfLogger$ProbeStat = this.registerProbe(string2);
        }
        perfLogger$ProbeStat.resume();
    }

    public synchronized void log(StringBuffer stringBuffer) {
        if (!this.isEnabled()) {
            return;
        }
        stringBuffer.append("=========== Performance Statistics =============\n");
        PerfLogger$ProbeStat perfLogger$ProbeStat = this.getProbeStat("TOTALTIME");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(this.probes.keySet());
        stringBuffer.append("\nTime:\n");
        Collections.sort(arrayList, this.timeComparator);
        for (String string : arrayList) {
            PerfLogger$ProbeStat perfLogger$ProbeStat2 = this.getProbeStat(string);
            stringBuffer.append(String.format("%s: %dms", this.fullName(string), perfLogger$ProbeStat2.totalTime));
            if (perfLogger$ProbeStat.totalTime > 0L) {
                stringBuffer.append(String.format(", %.2f%%%n", Float.valueOf(100.0f * (float)perfLogger$ProbeStat2.totalTime / (float)perfLogger$ProbeStat.totalTime)));
                continue;
            }
            stringBuffer.append("\n");
        }
        stringBuffer.append("\nInvocations count:\n");
        Collections.sort(arrayList, this.countComparator);
        for (String string : arrayList) {
            stringBuffer.append(String.format("%s: %d%n", this.fullName(string), this.getProbeStat((String)string).count));
        }
        stringBuffer.append("================================================\n");
    }

    public synchronized void log() {
        this.log(true);
    }

    private synchronized void log(boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        this.log(stringBuffer);
        if (bl2) {
            this.log.fine(stringBuffer.toString());
        } else {
            System.out.println(stringBuffer.toString());
            System.out.flush();
        }
    }

    public static synchronized void logAll() {
        for (PerfLogger perfLogger : loggers.values()) {
            perfLogger.log();
        }
    }
}

