/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webkit.perf;

public final class PerfLogger$ProbeStat {
    private final String probe;
    private int count;
    private long totalTime;
    private long startTime;
    private boolean isRunning = false;

    private PerfLogger$ProbeStat(String string) {
        this.probe = string;
    }

    public String getProbe() {
        return this.probe;
    }

    public int getCount() {
        return this.count;
    }

    public long getTotalTime() {
        return this.totalTime;
    }

    private void reset() {
        this.count = 0;
        this.startTime = 0L;
        this.totalTime = 0L;
    }

    private void suspend() {
        if (this.isRunning) {
            this.totalTime += System.currentTimeMillis() - this.startTime;
            this.isRunning = false;
        }
    }

    private void resume() {
        this.isRunning = true;
        ++this.count;
        this.startTime = System.currentTimeMillis();
    }

    private void snapshot() {
        if (this.isRunning) {
            this.totalTime += System.currentTimeMillis() - this.startTime;
            this.startTime = System.currentTimeMillis();
        }
    }

    public String toString() {
        return super.toString() + "[count=" + this.count + ", time=" + this.totalTime + "]";
    }
}

