/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webkit.network;

import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.logging.PlatformLogger$Level;
import com.sun.webkit.Invoker;
import com.sun.webkit.WebPage;
import com.sun.webkit.network.ByteBufferAllocator;
import com.sun.webkit.network.ByteBufferPool;
import com.sun.webkit.network.DirectoryURLConnection;
import com.sun.webkit.network.FormDataElement;
import com.sun.webkit.network.URLLoader$InvalidResponseException;
import com.sun.webkit.network.URLLoaderBase;
import com.sun.webkit.network.URLs;
import com.sun.webkit.network.Util;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.HttpRetryException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.security.AccessControlException;
import java.security.AccessController;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import javax.net.ssl.SSLHandshakeException;

final class URLLoader
extends URLLoaderBase
implements Runnable {
    private static final PlatformLogger logger = PlatformLogger.getLogger(URLLoader.class.getName());
    private static final int MAX_BUF_COUNT = 3;
    private static final String GET = "GET";
    private static final String HEAD = "HEAD";
    private static final String DELETE = "DELETE";
    private final WebPage webPage;
    private final ByteBufferPool byteBufferPool;
    private final boolean asynchronous;
    private String url;
    private String method;
    private final String headers;
    private FormDataElement[] formDataElements;
    private final long data;
    private volatile boolean canceled = false;

    URLLoader(WebPage webPage, ByteBufferPool byteBufferPool, boolean bl2, String string, String string2, String string3, FormDataElement[] formDataElementArray, long l2) {
        this.webPage = webPage;
        this.byteBufferPool = byteBufferPool;
        this.asynchronous = bl2;
        this.url = string;
        this.method = string2;
        this.headers = string3;
        this.formDataElements = formDataElementArray;
        this.data = l2;
    }

    @Override
    public void fwkCancel() {
        if (logger.isLoggable(PlatformLogger$Level.FINEST)) {
            logger.finest(String.format("data: [0x%016X]", this.data));
        }
        this.canceled = true;
    }

    @Override
    public void run() {
        AccessController.doPrivileged(() -> {
            this.doRun();
            return null;
        }, this.webPage.getAccessControlContext());
    }

    private void doRun() {
        Throwable throwable = null;
        int n2 = 0;
        try {
            boolean bl2 = true;
            boolean bl3 = true;
            while (true) {
                int n3;
                String string = this.url;
                if (this.url.startsWith("file:") && (n3 = this.url.indexOf(63)) != -1) {
                    string = this.url.substring(0, n3);
                }
                URL uRL = URLs.newURL(string);
                URLLoader.workaround7177996(uRL);
                URLConnection uRLConnection = uRL.openConnection();
                this.prepareConnection(uRLConnection);
                try {
                    this.sendRequest(uRLConnection, bl2);
                    this.receiveResponse(uRLConnection);
                }
                catch (HttpRetryException httpRetryException) {
                    if (bl2) {
                        bl2 = false;
                        continue;
                    }
                    throw httpRetryException;
                }
                catch (SocketException socketException) {
                    if ("Connection reset".equals(socketException.getMessage()) && bl3) {
                        bl3 = false;
                        continue;
                    }
                    throw socketException;
                }
                finally {
                    URLLoader.close(uRLConnection);
                    continue;
                }
                break;
            }
        }
        catch (MalformedURLException malformedURLException) {
            throwable = malformedURLException;
            n2 = 2;
        }
        catch (AccessControlException accessControlException) {
            throwable = accessControlException;
            n2 = 8;
        }
        catch (UnknownHostException unknownHostException) {
            throwable = unknownHostException;
            n2 = 1;
        }
        catch (NoRouteToHostException noRouteToHostException) {
            throwable = noRouteToHostException;
            n2 = 6;
        }
        catch (ConnectException connectException) {
            throwable = connectException;
            n2 = 4;
        }
        catch (SocketException socketException) {
            throwable = socketException;
            n2 = 5;
        }
        catch (SSLHandshakeException sSLHandshakeException) {
            throwable = sSLHandshakeException;
            n2 = 3;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            throwable = socketTimeoutException;
            n2 = 7;
        }
        catch (URLLoader$InvalidResponseException uRLLoader$InvalidResponseException) {
            throwable = uRLLoader$InvalidResponseException;
            n2 = 9;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throwable = fileNotFoundException;
            n2 = 11;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            n2 = 99;
        }
        if (throwable != null) {
            if (n2 == 99) {
                logger.warning("Unexpected error", throwable);
            } else {
                logger.finest("Load error", throwable);
            }
            this.didFail(n2, throwable.getMessage());
        }
    }

    private static void workaround7177996(URL uRL) {
        if (!uRL.getProtocol().equals("file")) {
            return;
        }
        String string = uRL.getHost();
        if (string == null || string.equals("") || string.equals("~") || string.equalsIgnoreCase("localhost")) {
            return;
        }
        if (System.getProperty("os.name").startsWith("Windows")) {
            String string2 = null;
            try {
                string2 = URLDecoder.decode(uRL.getPath(), "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            string2 = string2.replace('/', '\\');
            string2 = string2.replace('|', ':');
            File file = new File("\\\\" + string + string2);
            if (!file.exists()) {
                throw new FileNotFoundException("File not found: " + uRL);
            }
        } else {
            throw new FileNotFoundException("File not found: " + uRL);
        }
    }

    private void prepareConnection(URLConnection uRLConnection) {
        uRLConnection.setConnectTimeout(30000);
        uRLConnection.setReadTimeout(3600000);
        uRLConnection.setUseCaches(false);
        Locale locale = Locale.getDefault();
        Object object = "";
        if (!locale.equals(Locale.US) && !locale.equals(Locale.ENGLISH)) {
            object = locale.getCountry().isEmpty() ? locale.getLanguage() + "," : locale.getLanguage() + "-" + locale.getCountry() + ",";
        }
        uRLConnection.setRequestProperty("Accept-Language", ((String)object).toLowerCase() + "en-us;q=0.8,en;q=0.7");
        uRLConnection.setRequestProperty("Accept-Encoding", "gzip");
        uRLConnection.setRequestProperty("Accept-Charset", "ISO-8859-1,utf-8;q=0.7,*;q=0.7");
        if (this.headers != null && this.headers.length() > 0) {
            for (String string : this.headers.split("\n")) {
                int n2 = string.indexOf(58);
                if (n2 <= 0) continue;
                uRLConnection.addRequestProperty(string.substring(0, n2), string.substring(n2 + 2));
            }
        }
        if (uRLConnection instanceof HttpURLConnection) {
            String[] stringArray = (String[])uRLConnection;
            stringArray.setRequestMethod(this.method);
            stringArray.setInstanceFollowRedirects(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendRequest(URLConnection uRLConnection, boolean bl2) {
        OutputStream outputStream = null;
        try {
            boolean bl3;
            long l2 = 0L;
            int n2 = this.formDataElements != null && uRLConnection instanceof HttpURLConnection && !this.method.equals(DELETE) ? 1 : 0;
            boolean bl4 = bl3 = this.method.equals(GET) || this.method.equals(HEAD);
            if (n2 != 0) {
                uRLConnection.setDoOutput(true);
                for (FormDataElement formDataElement : this.formDataElements) {
                    formDataElement.open();
                    l2 += formDataElement.getSize();
                }
                if (bl2) {
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                    if (l2 <= Integer.MAX_VALUE) {
                        httpURLConnection.setFixedLengthStreamingMode((int)l2);
                    } else {
                        httpURLConnection.setChunkedStreamingMode(0);
                    }
                }
            } else if (!bl3 && uRLConnection instanceof HttpURLConnection) {
                uRLConnection.setRequestProperty("Content-Length", "0");
            }
            int n3 = bl3 ? 3 : 1;
            uRLConnection.setConnectTimeout(uRLConnection.getConnectTimeout() / n3);
            int n4 = 0;
            while (!this.canceled) {
                try {
                    uRLConnection.connect();
                    break;
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    if (++n4 < n3) continue;
                    throw socketTimeoutException;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new MalformedURLException(this.url);
                }
            }
            if (n2 != 0) {
                outputStream = uRLConnection.getOutputStream();
                byte[] byArray = new byte[4096];
                long l3 = 0L;
                for (FormDataElement formDataElement : this.formDataElements) {
                    int n5;
                    InputStream inputStream = formDataElement.getInputStream();
                    while ((n5 = inputStream.read(byArray)) > 0) {
                        outputStream.write(byArray, 0, n5);
                        this.didSendData(l3 += (long)n5, l2);
                    }
                    formDataElement.close();
                }
                outputStream.flush();
                outputStream.close();
                outputStream = null;
            }
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (this.formDataElements != null && uRLConnection instanceof HttpURLConnection) {
                for (FormDataElement formDataElement : this.formDataElements) {
                    try {
                        formDataElement.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveResponse(URLConnection uRLConnection) {
        Object object;
        Object object2;
        Object object3;
        block38: {
            block37: {
                int n2;
                if (this.canceled) {
                    return;
                }
                InputStream inputStream = null;
                if (uRLConnection instanceof HttpURLConnection) {
                    object3 = (HttpURLConnection)uRLConnection;
                    n2 = ((HttpURLConnection)object3).getResponseCode();
                    if (n2 == -1) {
                        throw new URLLoader$InvalidResponseException();
                    }
                    if (this.canceled) {
                        return;
                    }
                    switch (n2) {
                        case 301: 
                        case 302: 
                        case 303: 
                        case 307: {
                            this.willSendRequest(uRLConnection);
                            break;
                        }
                        case 304: {
                            this.didReceiveResponse(uRLConnection);
                            this.didFinishLoading();
                            return;
                        }
                    }
                    if (n2 >= 400 && !this.method.equals(HEAD)) {
                        inputStream = ((HttpURLConnection)object3).getErrorStream();
                    }
                }
                if (this.url.startsWith("ftp:") || this.url.startsWith("ftps:")) {
                    boolean bl2 = false;
                    n2 = 0;
                    object2 = uRLConnection.getURL().getPath();
                    if (object2 == null || ((String)object2).isEmpty() || ((String)object2).endsWith("/") || ((String)object2).contains(";type=d")) {
                        bl2 = true;
                    } else {
                        object = uRLConnection.getContentType();
                        if ("text/plain".equalsIgnoreCase((String)object) || "text/html".equalsIgnoreCase((String)object)) {
                            bl2 = true;
                            n2 = 1;
                        }
                    }
                    if (bl2) {
                        uRLConnection = new DirectoryURLConnection(uRLConnection, n2 != 0);
                    }
                }
                if (this.url.startsWith("file:") && "text/plain".equals(uRLConnection.getContentType()) && uRLConnection.getHeaderField("content-length") == null) {
                    uRLConnection = new DirectoryURLConnection(uRLConnection);
                }
                this.didReceiveResponse(uRLConnection);
                if (this.method.equals(HEAD)) {
                    this.didFinishLoading();
                    return;
                }
                object3 = null;
                try {
                    object3 = inputStream == null ? uRLConnection.getInputStream() : inputStream;
                }
                catch (HttpRetryException httpRetryException) {
                    throw httpRetryException;
                }
                catch (IOException iOException) {
                    if (!logger.isLoggable(PlatformLogger$Level.FINE)) break block37;
                    logger.fine(String.format("Exception caught: [%s], %s", iOException.getClass().getSimpleName(), iOException.getMessage()));
                }
            }
            String string = uRLConnection.getContentEncoding();
            if (object3 != null) {
                try {
                    if ("gzip".equalsIgnoreCase(string)) {
                        object3 = new GZIPInputStream((InputStream)object3);
                    } else if ("deflate".equalsIgnoreCase(string)) {
                        object3 = new InflaterInputStream((InputStream)object3);
                    }
                }
                catch (IOException iOException) {
                    if (!logger.isLoggable(PlatformLogger$Level.FINE)) break block38;
                    logger.fine(String.format("Exception caught: [%s], %s", iOException.getClass().getSimpleName(), iOException.getMessage()));
                }
            }
        }
        object2 = this.byteBufferPool.newAllocator(3);
        object = null;
        try {
            if (object3 != null) {
                byte[] byArray = new byte[8192];
                while (!this.canceled) {
                    int n3;
                    int n4;
                    try {
                        n4 = ((InputStream)object3).read(byArray);
                    }
                    catch (EOFException eOFException) {
                        n4 = -1;
                    }
                    if (n4 == -1) break;
                    if (object == null) {
                        object = object2.allocate();
                    }
                    if (n4 < (n3 = ((Buffer)object).remaining())) {
                        ((ByteBuffer)object).put(byArray, 0, n4);
                        continue;
                    }
                    ((ByteBuffer)object).put(byArray, 0, n3);
                    ((ByteBuffer)object).flip();
                    this.didReceiveData((ByteBuffer)object, (ByteBufferAllocator)object2);
                    object = null;
                    int n5 = n4 - n3;
                    if (n5 <= 0) continue;
                    object = object2.allocate();
                    ((ByteBuffer)object).put(byArray, n3, n5);
                }
            }
            if (!this.canceled) {
                if (object != null && ((Buffer)object).position() > 0) {
                    ((ByteBuffer)object).flip();
                    this.didReceiveData((ByteBuffer)object, (ByteBufferAllocator)object2);
                    object = null;
                }
                this.didFinishLoading();
            }
        }
        finally {
            if (object != null) {
                object2.release((ByteBuffer)object);
            }
        }
    }

    private static void close(URLConnection uRLConnection) {
        InputStream inputStream;
        if (uRLConnection instanceof HttpURLConnection && (inputStream = ((HttpURLConnection)uRLConnection).getErrorStream()) != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            uRLConnection.getInputStream().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void didSendData(long l2, long l3) {
        this.callBack(() -> {
            if (!this.canceled) {
                this.notifyDidSendData(l2, l3);
            }
        });
    }

    private void notifyDidSendData(long l2, long l3) {
        if (logger.isLoggable(PlatformLogger$Level.FINEST)) {
            logger.finest(String.format("totalBytesSent: [%d], totalBytesToBeSent: [%d], data: [0x%016X]", l2, l3, this.data));
        }
        URLLoader.twkDidSendData(l2, l3, this.data);
    }

    private void willSendRequest(URLConnection uRLConnection) {
        int n2 = URLLoader.extractStatus(uRLConnection);
        String string = uRLConnection.getContentType();
        String string2 = URLLoader.extractContentEncoding(uRLConnection);
        long l2 = URLLoader.extractContentLength(uRLConnection);
        String string3 = URLLoader.extractHeaders(uRLConnection);
        String string4 = URLLoader.adjustUrlForWebKit(this.url);
        this.callBack(() -> {
            if (!this.canceled) {
                this.notifyWillSendRequest(n2, string, string2, l2, string3, string4);
            }
        });
    }

    private void notifyWillSendRequest(int n2, String string, String string2, long l2, String string3, String string4) {
        if (logger.isLoggable(PlatformLogger$Level.FINEST)) {
            logger.finest(String.format("status: [%d], contentType: [%s], contentEncoding: [%s], contentLength: [%d], url: [%s], data: [0x%016X], headers:%n%s", n2, string, string2, l2, string4, this.data, Util.formatHeaders(string3)));
        }
        URLLoader.twkWillSendRequest(n2, string, string2, l2, string3, string4, this.data);
    }

    private void didReceiveResponse(URLConnection uRLConnection) {
        int n2 = URLLoader.extractStatus(uRLConnection);
        String string = uRLConnection.getContentType();
        String string2 = URLLoader.extractContentEncoding(uRLConnection);
        long l2 = URLLoader.extractContentLength(uRLConnection);
        String string3 = URLLoader.extractHeaders(uRLConnection);
        String string4 = URLLoader.adjustUrlForWebKit(this.url);
        this.callBack(() -> {
            if (!this.canceled) {
                this.notifyDidReceiveResponse(n2, string, string2, l2, string3, string4);
            }
        });
    }

    private void notifyDidReceiveResponse(int n2, String string, String string2, long l2, String string3, String string4) {
        if (logger.isLoggable(PlatformLogger$Level.FINEST)) {
            logger.finest(String.format("status: [%d], contentType: [%s], contentEncoding: [%s], contentLength: [%d], url: [%s], data: [0x%016X], headers:%n%s", n2, string, string2, l2, string4, this.data, Util.formatHeaders(string3)));
        }
        URLLoader.twkDidReceiveResponse(n2, string, string2, l2, string3, string4, this.data);
    }

    private void didReceiveData(ByteBuffer byteBuffer, ByteBufferAllocator byteBufferAllocator) {
        this.callBack(() -> {
            if (!this.canceled) {
                this.notifyDidReceiveData(byteBuffer, byteBuffer.position(), byteBuffer.remaining());
            }
            byteBufferAllocator.release(byteBuffer);
        });
    }

    private void notifyDidReceiveData(ByteBuffer byteBuffer, int n2, int n3) {
        if (logger.isLoggable(PlatformLogger$Level.FINEST)) {
            logger.finest(String.format("byteBuffer: [%s], position: [%s], remaining: [%s], data: [0x%016X]", byteBuffer, n2, n3, this.data));
        }
        URLLoader.twkDidReceiveData(byteBuffer, n2, n3, this.data);
    }

    private void didFinishLoading() {
        this.callBack(() -> {
            if (!this.canceled) {
                this.notifyDidFinishLoading();
            }
        });
    }

    private void notifyDidFinishLoading() {
        if (logger.isLoggable(PlatformLogger$Level.FINEST)) {
            logger.finest(String.format("data: [0x%016X]", this.data));
        }
        URLLoader.twkDidFinishLoading(this.data);
    }

    private void didFail(int n2, String string) {
        String string2 = URLLoader.adjustUrlForWebKit(this.url);
        this.callBack(() -> {
            if (!this.canceled) {
                this.notifyDidFail(n2, string2, string);
            }
        });
    }

    private void notifyDidFail(int n2, String string, String string2) {
        if (logger.isLoggable(PlatformLogger$Level.FINEST)) {
            logger.finest(String.format("errorCode: [%d], url: [%s], message: [%s], data: [0x%016X]", n2, string, string2, this.data));
        }
        URLLoader.twkDidFail(n2, string, string2, this.data);
    }

    private void callBack(Runnable runnable) {
        if (this.asynchronous) {
            Invoker.getInvoker().invokeOnEventThread(runnable);
        } else {
            runnable.run();
        }
    }

    private static int extractStatus(URLConnection uRLConnection) {
        int n2 = 0;
        if (uRLConnection instanceof HttpURLConnection) {
            try {
                n2 = ((HttpURLConnection)uRLConnection).getResponseCode();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return n2;
    }

    private static String extractContentEncoding(URLConnection uRLConnection) {
        String string = uRLConnection.getContentEncoding();
        if ("gzip".equalsIgnoreCase(string) || "deflate".equalsIgnoreCase(string)) {
            int n2;
            string = null;
            String string2 = uRLConnection.getContentType();
            if (string2 != null && (n2 = string2.indexOf("charset=")) >= 0 && (n2 = (string = string2.substring(n2 + 8)).indexOf(";")) > 0) {
                string = string.substring(0, n2);
            }
        }
        return string;
    }

    private static long extractContentLength(URLConnection uRLConnection) {
        try {
            return Long.parseLong(uRLConnection.getHeaderField("content-length"));
        }
        catch (Exception exception) {
            return -1L;
        }
    }

    private static String extractHeaders(URLConnection uRLConnection) {
        StringBuilder stringBuilder = new StringBuilder();
        if (uRLConnection instanceof HttpURLConnection) {
            Map<String, List<String>> map = uRLConnection.getHeaderFields();
            for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                String string = entry.getKey();
                List<String> list = entry.getValue();
                for (String string2 : list) {
                    stringBuilder.append(string != null ? string : "");
                    stringBuilder.append(':').append(string2).append('\n');
                }
            }
        }
        return stringBuilder.toString();
    }

    private static String adjustUrlForWebKit(String string) {
        try {
            string = Util.adjustUrlForWebKit(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }
}

