/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webkit.network;

import com.sun.javafx.logging.PlatformLogger;
import com.sun.webkit.network.PublicSuffixes$Rule;
import com.sun.webkit.network.PublicSuffixes$Rules;
import java.io.File;
import java.security.AccessController;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

final class PublicSuffixes {
    private static final PlatformLogger logger = PlatformLogger.getLogger(PublicSuffixes.class.getName());
    private static final Map<String, PublicSuffixes$Rules> rulesCache = new ConcurrentHashMap<String, PublicSuffixes$Rules>();
    private static final File pslFile = AccessController.doPrivileged(() -> new File(System.getProperty("java.home"), "lib/security/public_suffix_list.dat"));
    private static final boolean pslFileExists = AccessController.doPrivileged(() -> {
        if (!pslFile.exists()) {
            logger.warning("Resource not found: lib/security/public_suffix_list.dat");
            return false;
        }
        return true;
    });

    private PublicSuffixes() {
        throw new AssertionError();
    }

    static boolean pslFileExists() {
        return pslFileExists;
    }

    static boolean isPublicSuffix(String string) {
        if (string.length() == 0) {
            return false;
        }
        if (!PublicSuffixes.pslFileExists()) {
            return false;
        }
        PublicSuffixes$Rules publicSuffixes$Rules = PublicSuffixes$Rules.getRules(string);
        return publicSuffixes$Rules == null ? false : publicSuffixes$Rules.match(string);
    }

    private static String toLogString(Map<String, PublicSuffixes$Rule> map) {
        if (map.isEmpty()) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, PublicSuffixes$Rule> entry : map.entrySet()) {
            stringBuilder.append(String.format("%n    ", new Object[0]));
            stringBuilder.append(entry.getKey());
            stringBuilder.append(": ");
            stringBuilder.append((Object)entry.getValue());
        }
        return stringBuilder.toString();
    }
}

