/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webkit.network;

import com.sun.javafx.logging.PlatformLogger$Level;
import com.sun.webkit.network.PublicSuffixes;
import com.sun.webkit.network.PublicSuffixes$Rule;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.IDN;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

class PublicSuffixes$Rules {
    private final Map<String, PublicSuffixes$Rule> rules = new HashMap<String, PublicSuffixes$Rule>();

    private PublicSuffixes$Rules(InputStream inputStream) {
        String string;
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        int n2 = bufferedReader.read();
        while (n2 != -1 && (string = bufferedReader.readLine()) != null) {
            PublicSuffixes$Rule publicSuffixes$Rule;
            if (string.startsWith("!")) {
                string = string.substring(1);
                publicSuffixes$Rule = PublicSuffixes$Rule.EXCEPTION_RULE;
            } else if (string.startsWith("*.")) {
                string = string.substring(2);
                publicSuffixes$Rule = PublicSuffixes$Rule.WILDCARD_RULE;
            } else {
                publicSuffixes$Rule = PublicSuffixes$Rule.SIMPLE_RULE;
            }
            try {
                string = IDN.toASCII(string, 1);
            }
            catch (Exception exception) {
                PublicSuffixes.logger.warning(String.format("Error parsing rule: [%s]", string), exception);
                continue;
            }
            this.rules.put(string, publicSuffixes$Rule);
            n2 = bufferedReader.read();
        }
        if (PublicSuffixes.logger.isLoggable(PlatformLogger$Level.FINEST)) {
            PublicSuffixes.logger.finest("rules: {0}", PublicSuffixes.toLogString(this.rules));
        }
    }

    static PublicSuffixes$Rules getRules(String string) {
        String string3 = PublicSuffixes$Rules.getTopLevelDomain(string);
        if (string3.isEmpty()) {
            return null;
        }
        return PublicSuffixes.rulesCache.computeIfAbsent(string3, string2 -> PublicSuffixes$Rules.createRules(string3));
    }

    private static String getTopLevelDomain(String string) {
        int n2 = (string = IDN.toUnicode(string, 1)).lastIndexOf(46);
        if (n2 == -1) {
            return string;
        }
        return string.substring(n2 + 1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static PublicSuffixes$Rules createRules(String string) {
        try (InputStream inputStream = PublicSuffixes$Rules.getPubSuffixStream();){
            if (inputStream == null) {
                PublicSuffixes$Rules publicSuffixes$Rules = null;
                return publicSuffixes$Rules;
            }
            ZipInputStream zipInputStream = new ZipInputStream(inputStream);
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                if (zipEntry.getName().equals(string)) {
                    PublicSuffixes$Rules publicSuffixes$Rules = new PublicSuffixes$Rules(zipInputStream);
                    return publicSuffixes$Rules;
                }
                zipEntry = zipInputStream.getNextEntry();
            }
            return null;
        }
        catch (IOException iOException) {
            PublicSuffixes.logger.warning("Unexpected error", iOException);
        }
        return null;
    }

    private static InputStream getPubSuffixStream() {
        InputStream inputStream = AccessController.doPrivileged(() -> {
            try {
                return new FileInputStream(PublicSuffixes.pslFile);
            }
            catch (FileNotFoundException fileNotFoundException) {
                PublicSuffixes.logger.warning("Resource not found: lib/security/public_suffix_list.dat");
                return null;
            }
        });
        return inputStream;
    }

    boolean match(String string) {
        String string2;
        PublicSuffixes$Rule publicSuffixes$Rule = this.rules.get(string);
        if (publicSuffixes$Rule == PublicSuffixes$Rule.EXCEPTION_RULE) {
            return false;
        }
        if (publicSuffixes$Rule == PublicSuffixes$Rule.SIMPLE_RULE || publicSuffixes$Rule == PublicSuffixes$Rule.WILDCARD_RULE) {
            return true;
        }
        int n2 = string.indexOf(46) + 1;
        if (n2 == 0) {
            n2 = string.length();
        }
        return this.rules.get(string2 = string.substring(n2)) == PublicSuffixes$Rule.WILDCARD_RULE;
    }
}

