/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webkit.network;

import java.security.AccessController;
import java.security.Permission;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

final class NetworkContext$URLLoaderThreadFactory
implements ThreadFactory {
    private final ThreadGroup group;
    private final AtomicInteger index = new AtomicInteger(1);
    private static final Permission modifyThreadGroupPerm = new RuntimePermission("modifyThreadGroup");
    private static final Permission modifyThreadPerm = new RuntimePermission("modifyThread");

    private NetworkContext$URLLoaderThreadFactory() {
        SecurityManager securityManager = System.getSecurityManager();
        this.group = securityManager != null ? securityManager.getThreadGroup() : Thread.currentThread().getThreadGroup();
    }

    @Override
    public Thread newThread(Runnable runnable) {
        return AccessController.doPrivileged(() -> {
            Thread thread = new Thread(this.group, runnable, "URL-Loader-" + this.index.getAndIncrement());
            thread.setDaemon(true);
            if (thread.getPriority() != 5) {
                thread.setPriority(5);
            }
            return thread;
        }, null, modifyThreadGroupPerm, modifyThreadPerm);
    }
}

