/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webkit.network;

import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.logging.PlatformLogger$Level;
import com.sun.javafx.tk.Toolkit;
import com.sun.webkit.Invoker;
import com.sun.webkit.WebPage;
import com.sun.webkit.network.ByteBufferPool;
import com.sun.webkit.network.FormDataElement;
import com.sun.webkit.network.HTTP2Loader$1;
import com.sun.webkit.network.HTTP2Loader$2;
import com.sun.webkit.network.HTTP2Loader$3;
import com.sun.webkit.network.URLLoader;
import com.sun.webkit.network.URLLoaderBase;
import com.sun.webkit.network.URLs;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.net.ConnectException;
import java.net.CookieHandler;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.net.http.HttpTimeoutException;
import java.nio.ByteBuffer;
import java.security.AccessControlException;
import java.security.AccessController;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import javax.net.ssl.SSLHandshakeException;

final class HTTP2Loader
extends URLLoaderBase {
    private static final PlatformLogger logger = PlatformLogger.getLogger(URLLoader.class.getName());
    private final WebPage webPage;
    private final boolean asynchronous;
    private String url;
    private String method;
    private final String headers;
    private FormDataElement[] formDataElements;
    private final long data;
    private volatile boolean canceled = false;
    private final CompletableFuture<Void> response;
    private static final HttpClient HTTP_CLIENT = AccessController.doPrivileged(() -> HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).followRedirects(HttpClient.Redirect.NEVER).connectTimeout(Duration.ofSeconds(30L)).cookieHandler(CookieHandler.getDefault()).build());
    private static final int DEFAULT_BUFSIZE = 40960;
    private static final ByteBuffer BUFFER;

    static HTTP2Loader create(WebPage webPage, ByteBufferPool byteBufferPool, boolean bl2, String string, String string2, String string3, FormDataElement[] formDataElementArray, long l2) {
        if (string.startsWith("http://") || string.startsWith("https://")) {
            return new HTTP2Loader(webPage, byteBufferPool, bl2, string, string2, string3, formDataElementArray, l2);
        }
        return null;
    }

    private String[] getCustomHeaders() {
        Locale locale = Locale.getDefault();
        Object object = "";
        if (!locale.equals(Locale.US) && !locale.equals(Locale.ENGLISH)) {
            object = locale.getCountry().isEmpty() ? locale.getLanguage() + "," : locale.getLanguage() + "-" + locale.getCountry() + ",";
        }
        return new String[]{"Accept-Language", ((String)object).toLowerCase() + "en-us;q=0.8,en;q=0.7", "Accept-Encoding", "gzip, inflate", "Accept-Charset", "ISO-8859-1,utf-8;q=0.7,*;q=0.7"};
    }

    private String[] getRequestHeaders() {
        return (String[])Arrays.stream(this.headers.split("\n")).flatMap(string -> Stream.of(string.split(":", 2))).toArray(String[]::new);
    }

    private URI toURI() {
        URI uRI;
        try {
            uRI = new URI(this.url);
        }
        catch (IllegalArgumentException | URISyntaxException exception) {
            try {
                URL uRL = URLs.newURL(this.url);
                uRI = new URI(uRL.getProtocol(), uRL.getUserInfo(), uRL.getHost(), uRL.getPort(), uRL.getPath(), uRL.getQuery(), uRL.getRef());
            }
            catch (IllegalArgumentException | MalformedURLException | URISyntaxException exception2) {
                throw new MalformedURLException(this.url);
            }
        }
        return uRI;
    }

    private HttpRequest.BodyPublisher getFormDataPublisher() {
        if (this.formDataElements == null) {
            return HttpRequest.BodyPublishers.noBody();
        }
        Vector<InputStream> vector = new Vector<InputStream>();
        AtomicLong atomicLong = new AtomicLong();
        for (FormDataElement formDataElement : this.formDataElements) {
            try {
                formDataElement.open();
                atomicLong.addAndGet(formDataElement.getSize());
                vector.add(formDataElement.getInputStream());
            }
            catch (IOException iOException) {
                return null;
            }
        }
        SequenceInputStream sequenceInputStream = new SequenceInputStream(vector.elements());
        HttpRequest.BodyPublisher bodyPublisher = HttpRequest.BodyPublishers.ofInputStream(() -> sequenceInputStream);
        HTTP2Loader$1 hTTP2Loader$1 = new HTTP2Loader$1(this, atomicLong, bodyPublisher);
        return hTTP2Loader$1;
    }

    private InputStream createZIPStream(String string, InputStream inputStream) {
        if ("gzip".equalsIgnoreCase(string)) {
            return new GZIPInputStream(inputStream);
        }
        if ("deflate".equalsIgnoreCase(string)) {
            return new InflaterInputStream(inputStream);
        }
        return inputStream;
    }

    private HttpResponse.BodySubscriber<Void> createZIPEncodedBodySubscriber(String string) {
        if (!"gzip".equalsIgnoreCase(string) && !"inflate".equalsIgnoreCase(string)) {
            logger.severe(String.format("Unknown encoding type '%s' found, discarding", string));
            return HttpResponse.BodySubscribers.discarding();
        }
        HttpResponse.BodySubscriber<InputStream> bodySubscriber = HttpResponse.BodySubscribers.ofInputStream();
        CompletionStage<Void> completionStage = bodySubscriber.getBody().thenAcceptAsync(inputStream -> {
            try (InputStream inputStream2 = inputStream;
                 InputStream inputStream3 = this.createZIPStream(string, inputStream2);){
                while (!this.canceled) {
                    byte[] byArray = new byte[8192];
                    int n2 = inputStream3.read(byArray);
                    if (n2 < 0) {
                        this.didFinishLoading();
                        break;
                    }
                    this.didReceiveData(byArray, n2);
                }
            }
            catch (IOException iOException) {
                this.didFail(iOException);
            }
        });
        return new HTTP2Loader$2(this, bodySubscriber, completionStage);
    }

    private HttpResponse.BodySubscriber<Void> createNormalBodySubscriber() {
        HttpResponse.BodySubscriber<Void> bodySubscriber = HttpResponse.BodySubscribers.fromSubscriber(new HTTP2Loader$3(this));
        return bodySubscriber;
    }

    private HttpResponse.BodySubscriber<Void> getBodySubscriber(String string) {
        return string.isEmpty() ? this.createNormalBodySubscriber() : this.createZIPEncodedBodySubscriber(string);
    }

    private HTTP2Loader(WebPage webPage, ByteBufferPool byteBufferPool, boolean bl2, String string, String string2, String string3, FormDataElement[] formDataElementArray, long l2) {
        CompletableFuture completableFuture;
        URI uRI;
        this.webPage = webPage;
        this.asynchronous = bl2;
        this.url = string;
        this.method = string2;
        this.headers = string3;
        this.formDataElements = formDataElementArray;
        this.data = l2;
        try {
            uRI = this.toURI();
        }
        catch (MalformedURLException malformedURLException) {
            this.response = null;
            this.didFail(malformedURLException);
            return;
        }
        HttpRequest httpRequest = HttpRequest.newBuilder().uri(uRI).headers(this.getRequestHeaders()).headers(this.getCustomHeaders()).version(HttpClient.Version.HTTP_2).method(string2, this.getFormDataPublisher()).build();
        HttpResponse.BodyHandler bodyHandler = responseInfo -> {
            if (!this.handleRedirectionIfNeeded(responseInfo)) {
                this.didReceiveResponse(responseInfo);
            }
            return this.getBodySubscriber(HTTP2Loader.getContentEncoding(responseInfo));
        };
        this.response = completableFuture = AccessController.doPrivileged(() -> ((CompletableFuture)HTTP_CLIENT.sendAsync(httpRequest, bodyHandler).thenAccept(httpResponse -> {})).exceptionally(throwable -> this.didFail(throwable.getCause())), webPage.getAccessControlContext());
        if (!bl2) {
            this.waitForRequestToComplete();
        }
    }

    @Override
    public void fwkCancel() {
        if (logger.isLoggable(PlatformLogger$Level.FINEST)) {
            logger.finest(String.format("data: [0x%016X]", this.data));
        }
        this.canceled = true;
    }

    private void callBackIfNotCanceled(Runnable runnable) {
        Invoker.getInvoker().invokeOnEventThread(() -> {
            if (!this.canceled) {
                runnable.run();
            }
        });
    }

    private void waitForRequestToComplete() {
        Object object = new Object();
        this.response.handle((void_, throwable) -> {
            Invoker.getInvoker().invokeOnEventThread(() -> Toolkit.getToolkit().exitNestedEventLoop(object, null));
            return null;
        });
        Toolkit.getToolkit().enterNestedEventLoop(object);
    }

    private boolean handleRedirectionIfNeeded(HttpResponse.ResponseInfo responseInfo) {
        switch (responseInfo.statusCode()) {
            case 301: 
            case 302: 
            case 303: 
            case 307: {
                this.willSendRequest(responseInfo);
                return true;
            }
            case 304: {
                this.didReceiveResponse(responseInfo);
                this.didFinishLoading();
                return true;
            }
        }
        return false;
    }

    private static long getContentLength(HttpResponse.ResponseInfo responseInfo) {
        return responseInfo.headers().firstValueAsLong("content-length").orElse(-1L);
    }

    private static String getContentType(HttpResponse.ResponseInfo responseInfo) {
        return responseInfo.headers().firstValue("content-type").orElse("application/octet-stream");
    }

    private static String getContentEncoding(HttpResponse.ResponseInfo responseInfo) {
        return responseInfo.headers().firstValue("content-encoding").orElse("");
    }

    private static String getHeadersAsString(HttpResponse.ResponseInfo responseInfo) {
        return responseInfo.headers().map().entrySet().stream().map(entry -> String.format("%s:%s", entry.getKey(), ((List)entry.getValue()).stream().collect(Collectors.joining(",")))).collect(Collectors.joining("\n")) + "\n";
    }

    private void willSendRequest(HttpResponse.ResponseInfo responseInfo) {
        this.callBackIfNotCanceled(() -> HTTP2Loader.twkWillSendRequest(responseInfo.statusCode(), HTTP2Loader.getContentType(responseInfo), "", HTTP2Loader.getContentLength(responseInfo), HTTP2Loader.getHeadersAsString(responseInfo), this.url, this.data));
    }

    private void didReceiveResponse(HttpResponse.ResponseInfo responseInfo) {
        this.callBackIfNotCanceled(() -> HTTP2Loader.twkDidReceiveResponse(responseInfo.statusCode(), HTTP2Loader.getContentType(responseInfo), "", HTTP2Loader.getContentLength(responseInfo), HTTP2Loader.getHeadersAsString(responseInfo), this.url, this.data));
    }

    private ByteBuffer getDirectBuffer(int n2) {
        ByteBuffer byteBuffer = BUFFER;
        if (n2 > byteBuffer.capacity()) {
            byteBuffer = ByteBuffer.allocateDirect(n2);
        }
        return byteBuffer.clear();
    }

    private ByteBuffer copyToDirectBuffer(ByteBuffer byteBuffer) {
        return this.getDirectBuffer(byteBuffer.limit()).put(byteBuffer).flip();
    }

    private void didReceiveData(byte[] byArray, int n2) {
        this.callBackIfNotCanceled(() -> this.notifyDidReceiveData(this.getDirectBuffer(n2).put(byArray, 0, n2).flip()));
    }

    private void didReceiveData(List<ByteBuffer> list) {
        this.callBackIfNotCanceled(() -> list.stream().map(this::copyToDirectBuffer).forEach(this::notifyDidReceiveData));
    }

    private void notifyDidReceiveData(ByteBuffer byteBuffer) {
        Invoker.getInvoker().checkEventThread();
        if (logger.isLoggable(PlatformLogger$Level.FINEST)) {
            logger.finest(String.format("byteBuffer: [%s], position: [%s], remaining: [%s], data: [0x%016X]", byteBuffer, byteBuffer.position(), byteBuffer.remaining(), this.data));
        }
        HTTP2Loader.twkDidReceiveData(byteBuffer, byteBuffer.position(), byteBuffer.remaining(), this.data);
    }

    private void didFinishLoading() {
        this.callBackIfNotCanceled(this::notifyDidFinishLoading);
    }

    private void notifyDidFinishLoading() {
        Invoker.getInvoker().checkEventThread();
        if (logger.isLoggable(PlatformLogger$Level.FINEST)) {
            logger.finest(String.format("data: [0x%016X]", this.data));
        }
        HTTP2Loader.twkDidFinishLoading(this.data);
    }

    private Void didFail(Throwable throwable) {
        this.callBackIfNotCanceled(() -> {
            int n2;
            try {
                throw throwable;
            }
            catch (MalformedURLException malformedURLException) {
                n2 = 2;
            }
            catch (AccessControlException accessControlException) {
                n2 = 8;
            }
            catch (UnknownHostException unknownHostException) {
                n2 = 1;
            }
            catch (NoRouteToHostException noRouteToHostException) {
                n2 = 6;
            }
            catch (ConnectException connectException) {
                n2 = 4;
            }
            catch (SocketException socketException) {
                n2 = 5;
            }
            catch (SSLHandshakeException sSLHandshakeException) {
                n2 = 3;
            }
            catch (SocketTimeoutException | HttpTimeoutException iOException) {
                n2 = 7;
            }
            catch (FileNotFoundException fileNotFoundException) {
                n2 = 11;
            }
            catch (Throwable throwable2) {
                n2 = 99;
            }
            this.notifyDidFail(n2, this.url, throwable.getMessage());
        });
        return null;
    }

    private void notifyDidFail(int n2, String string, String string2) {
        Invoker.getInvoker().checkEventThread();
        if (logger.isLoggable(PlatformLogger$Level.FINEST)) {
            logger.finest(String.format("errorCode: [%d], url: [%s], message: [%s], data: [0x%016X]", n2, string, string2, this.data));
        }
        HTTP2Loader.twkDidFail(n2, string, string2, this.data);
    }

    private void didSendData(long l2, long l3) {
        this.callBackIfNotCanceled(() -> this.notifyDidSendData(l2, l3));
    }

    private void notifyDidSendData(long l2, long l3) {
        Invoker.getInvoker().checkEventThread();
        if (logger.isLoggable(PlatformLogger$Level.FINEST)) {
            logger.finest(String.format("totalBytesSent: [%d], totalBytesToBeSent: [%d], data: [0x%016X]", l2, l3, this.data));
        }
        HTTP2Loader.twkDidSendData(l2, l3, this.data);
    }

    static {
        int n2 = AccessController.doPrivileged(() -> Integer.valueOf(System.getProperty("jdk.httpclient.bufsize", Integer.toString(40960))));
        BUFFER = ByteBuffer.allocateDirect(n2);
    }
}

