/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webkit.network;

import com.sun.webkit.network.DirectoryURLConnection$DirectoryInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

final class DirectoryURLConnection
extends URLConnection {
    private static final String[] patStrings = new String[]{"([\\-ld](?:[r\\-][w\\-][x\\-]){3})\\s*\\d+ (\\w+)\\s*(\\w+)\\s*(\\d+)\\s*([A-Z][a-z][a-z]\\s*\\d+)\\s*((?:\\d\\d:\\d\\d)|(?:\\d{4}))\\s*(\\p{Print}*)", "(\\d{2}/\\d{2}/\\d{4})\\s*(\\d{2}:\\d{2}[ap])\\s*((?:[0-9,]+)|(?:<DIR>))\\s*(\\p{Graph}*)", "(\\d{2}-\\d{2}-\\d{2})\\s*(\\d{2}:\\d{2}[AP]M)\\s*((?:[0-9,]+)|(?:<DIR>))\\s*(\\p{Graph}*)"};
    private static final int[][] patternGroups = new int[][]{{7, 4, 5, 6, 1}, {4, 3, 1, 2, 0}, {4, 3, 1, 2, 0}};
    private static final Pattern[] patterns;
    private static final Pattern linkp;
    private static final String styleSheet = "<style type=\"text/css\" media=\"screen\">TABLE { border: 0;}TR.header { background: #FFFFFF; color: black; font-weight: bold; text-align: center;}TR.odd { background: #E0E0E0;}TR.even { background: #C0C0C0;}TD.file { text-align: left;}TD.fsize { text-align: right; padding-right: 1em;}TD.dir { text-align: center; color: green; padding-right: 1em;}TD.link { text-align: center; color: red; padding-right: 1em;}TD.date { text-align: justify;}</style>";
    private final URLConnection inner;
    private final boolean sure;
    private String dirUrl = null;
    private boolean toHTML = true;
    private final boolean ftp;
    private InputStream ins = null;

    DirectoryURLConnection(URLConnection uRLConnection, boolean bl2) {
        super(uRLConnection.getURL());
        this.dirUrl = uRLConnection.getURL().toExternalForm();
        this.inner = uRLConnection;
        this.sure = !bl2;
        this.ftp = true;
    }

    DirectoryURLConnection(URLConnection uRLConnection) {
        super(uRLConnection.getURL());
        this.dirUrl = uRLConnection.getURL().toExternalForm();
        this.ftp = false;
        this.sure = true;
        this.inner = uRLConnection;
    }

    @Override
    public void connect() {
        this.inner.connect();
    }

    @Override
    public InputStream getInputStream() {
        if (this.ins == null) {
            this.ins = this.ftp ? new DirectoryURLConnection$DirectoryInputStream(this, this.inner.getInputStream(), !this.sure) : new DirectoryURLConnection$DirectoryInputStream(this, this.inner.getInputStream(), false);
        }
        return this.ins;
    }

    @Override
    public String getContentType() {
        try {
            if (!this.sure) {
                this.getInputStream();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.toHTML) {
            return "text/html";
        }
        return this.inner.getContentType();
    }

    @Override
    public String getContentEncoding() {
        return this.inner.getContentEncoding();
    }

    @Override
    public int getContentLength() {
        return this.inner.getContentLength();
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        return this.inner.getHeaderFields();
    }

    @Override
    public String getHeaderField(String string) {
        return this.inner.getHeaderField(string);
    }

    static {
        linkp = Pattern.compile("(\\p{Print}+) \\-\\> (\\p{Print}+)$");
        patterns = new Pattern[patStrings.length];
        for (int i2 = 0; i2 < patStrings.length; ++i2) {
            DirectoryURLConnection.patterns[i2] = Pattern.compile(patStrings[i2]);
        }
    }
}

