/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webkit;

import com.sun.webkit.SeparateThreadTimer;
import com.sun.webkit.Timer$Mode;
import com.sun.webkit.WebPage;
import java.security.AccessController;

public class Timer {
    private static Timer instance;
    private static Timer$Mode mode;
    long fireTime;

    Timer() {
    }

    public static synchronized Timer$Mode getMode() {
        if (mode == null) {
            mode = Boolean.valueOf(AccessController.doPrivileged(() -> System.getProperty("com.sun.webkit.platformticks", "true"))) != false ? Timer$Mode.PLATFORM_TICKS : Timer$Mode.SEPARATE_THREAD;
        }
        return mode;
    }

    public static synchronized Timer getTimer() {
        if (instance == null) {
            instance = Timer.getMode() == Timer$Mode.PLATFORM_TICKS ? new Timer() : new SeparateThreadTimer();
        }
        return instance;
    }

    public synchronized void notifyTick() {
        if (this.fireTime > 0L && this.fireTime <= System.currentTimeMillis()) {
            this.fireTimerEvent(this.fireTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireTimerEvent(long l2) {
        boolean bl2 = false;
        Timer timer = this;
        synchronized (timer) {
            if (l2 == this.fireTime) {
                bl2 = true;
                this.fireTime = 0L;
            }
        }
        if (bl2) {
            WebPage.lockPage();
            try {
                Timer.twkFireTimerEvent();
            }
            finally {
                WebPage.unlockPage();
            }
        }
    }

    synchronized void setFireTime(long l2) {
        this.fireTime = l2;
    }

    private static void fwkSetFireTime(double d2) {
        Timer.getTimer().setFireTime((long)Math.ceil(d2 * 1000.0));
    }

    private static void fwkStopTimer() {
        Timer.getTimer().setFireTime(0L);
    }

    private static native void twkFireTimerEvent();
}

