/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.animation;

import com.sun.javafx.tk.Toolkit;
import com.sun.scenario.animation.AnimationPulse;
import com.sun.scenario.animation.AnimationPulse$PulseData$Accessor;
import java.util.concurrent.TimeUnit;

class AnimationPulse$PulseData {
    private final long startNanos;
    private final long scheduledNanos;
    private long animationEndNanos = Long.MIN_VALUE;
    private long paintingStartNanos = Long.MIN_VALUE;
    private long paintingEndNanos = Long.MIN_VALUE;
    private long scenePaintingStartNanos = Long.MIN_VALUE;
    private long scenePaintingEndNanos = Long.MIN_VALUE;
    private long endNanos = Long.MIN_VALUE;
    static final AnimationPulse$PulseData$Accessor PulseStartAccessor = (animationPulse$PulseData, timeUnit) -> animationPulse$PulseData.getPulseStart(timeUnit);
    static final AnimationPulse$PulseData$Accessor AnimationDurationAccessor = (animationPulse$PulseData, timeUnit) -> animationPulse$PulseData.getAnimationDuration(timeUnit);
    static final AnimationPulse$PulseData$Accessor PaintingDurationAccessor = (animationPulse$PulseData, timeUnit) -> animationPulse$PulseData.getPaintingDuration(timeUnit);
    static final AnimationPulse$PulseData$Accessor ScenePaintingDurationAccessor = (animationPulse$PulseData, timeUnit) -> animationPulse$PulseData.getScenePaintingDuration(timeUnit);
    static final AnimationPulse$PulseData$Accessor PulseDurationAccessor = (animationPulse$PulseData, timeUnit) -> animationPulse$PulseData.getPulseDuration(timeUnit);
    static final AnimationPulse$PulseData$Accessor PulseEndAccessor = (animationPulse$PulseData, timeUnit) -> animationPulse$PulseData.getPulseEnd(timeUnit);
    static final AnimationPulse$PulseData$Accessor PaintingPreparationDuration = (animationPulse$PulseData, timeUnit) -> animationPulse$PulseData.getPaintingDuration(timeUnit);
    static final AnimationPulse$PulseData$Accessor PaintingFinalizationDuration = (animationPulse$PulseData, timeUnit) -> animationPulse$PulseData.getPaintingFinalizationDuration(timeUnit);

    AnimationPulse$PulseData(long l2) {
        this.startNanos = Toolkit.getToolkit().getPrimaryTimer().nanos();
        this.scheduledNanos = this.startNanos + l2;
    }

    long getPulseStart(TimeUnit timeUnit) {
        return timeUnit.convert(this.startNanos - this.scheduledNanos, TimeUnit.NANOSECONDS);
    }

    void recordAnimationEnd() {
        this.animationEndNanos = Toolkit.getToolkit().getPrimaryTimer().nanos();
    }

    long getAnimationDuration(TimeUnit timeUnit) {
        return this.animationEndNanos > Long.MIN_VALUE ? timeUnit.convert(this.animationEndNanos - this.startNanos, TimeUnit.NANOSECONDS) : 0L;
    }

    long getPaintingDuration(TimeUnit timeUnit) {
        return this.paintingEndNanos > Long.MIN_VALUE && this.paintingStartNanos > Long.MIN_VALUE ? timeUnit.convert(this.paintingEndNanos - this.paintingStartNanos, TimeUnit.NANOSECONDS) : 0L;
    }

    long getScenePaintingDuration(TimeUnit timeUnit) {
        return this.scenePaintingEndNanos > Long.MIN_VALUE && this.scenePaintingStartNanos > Long.MIN_VALUE ? timeUnit.convert(this.scenePaintingEndNanos - this.scenePaintingStartNanos, TimeUnit.NANOSECONDS) : 0L;
    }

    long getPaintingFinalizationDuration(TimeUnit timeUnit) {
        return this.scenePaintingEndNanos > Long.MIN_VALUE && this.paintingEndNanos > Long.MIN_VALUE ? timeUnit.convert(this.paintingEndNanos - this.scenePaintingEndNanos, TimeUnit.NANOSECONDS) : 0L;
    }

    void recordEnd() {
        this.endNanos = Toolkit.getToolkit().getPrimaryTimer().nanos();
    }

    long getPulseDuration(TimeUnit timeUnit) {
        return timeUnit.convert(this.endNanos - this.startNanos, TimeUnit.NANOSECONDS);
    }

    long getPulseEnd(TimeUnit timeUnit) {
        return timeUnit.convert(this.endNanos - this.scheduledNanos, TimeUnit.NANOSECONDS);
    }

    long getPulseStartFromNow(TimeUnit timeUnit) {
        return timeUnit.convert(Toolkit.getToolkit().getPrimaryTimer().nanos() - this.startNanos, TimeUnit.NANOSECONDS);
    }

    long getSkippedPulses() {
        return this.getPulseEnd(TimeUnit.MILLISECONDS) / AnimationPulse.getDefaultBean().getPULSE_DURATION();
    }
}

