/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.sw;

import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.pisces.PiscesRenderer;
import com.sun.prism.BasicStroke;
import com.sun.prism.PixelFormat;
import com.sun.prism.ResourceFactory;
import com.sun.prism.Texture$Usage;
import com.sun.prism.Texture$WrapMode;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.sw.SWArgbPreTexture;
import com.sun.prism.sw.SWContext$DMarlinShapeRenderer;
import com.sun.prism.sw.SWContext$ShapeRenderer;
import com.sun.prism.sw.SWRTTexture;
import java.lang.ref.SoftReference;

final class SWContext {
    private final ResourceFactory factory;
    private final SWContext$ShapeRenderer shapeRenderer;
    private SoftReference<SWRTTexture> readBackBufferRef;
    private SoftReference<SWArgbPreTexture> imagePaintTextureRef;

    SWContext(ResourceFactory resourceFactory) {
        this.factory = resourceFactory;
        switch (PrismSettings.rasterizerSpec) {
            default: 
        }
        this.shapeRenderer = new SWContext$DMarlinShapeRenderer();
    }

    void renderShape(PiscesRenderer piscesRenderer, Shape shape, BasicStroke basicStroke, BaseTransform baseTransform, Rectangle rectangle, boolean bl2) {
        this.shapeRenderer.renderShape(piscesRenderer, shape, basicStroke, baseTransform, rectangle, bl2);
    }

    private SWRTTexture initRBBuffer(int n2, int n3) {
        SWRTTexture sWRTTexture = (SWRTTexture)this.factory.createRTTexture(n2, n3, Texture$WrapMode.CLAMP_NOT_NEEDED);
        this.readBackBufferRef = new SoftReference<SWRTTexture>(sWRTTexture);
        return sWRTTexture;
    }

    private void disposeRBBuffer() {
        if (this.readBackBufferRef != null) {
            this.readBackBufferRef.clear();
            this.readBackBufferRef = null;
        }
    }

    SWRTTexture validateRBBuffer(int n2, int n3) {
        SWRTTexture sWRTTexture;
        if (this.readBackBufferRef == null) {
            sWRTTexture = this.initRBBuffer(n2, n3);
        } else {
            sWRTTexture = this.readBackBufferRef.get();
            if (sWRTTexture == null || sWRTTexture.getPhysicalWidth() < n2 || sWRTTexture.getPhysicalHeight() < n3) {
                this.disposeRBBuffer();
                sWRTTexture = this.initRBBuffer(n2, n3);
            }
            sWRTTexture.setContentWidth(n2);
            sWRTTexture.setContentHeight(n3);
        }
        return sWRTTexture;
    }

    private SWArgbPreTexture initImagePaintTexture(int n2, int n3) {
        SWArgbPreTexture sWArgbPreTexture = (SWArgbPreTexture)this.factory.createTexture(PixelFormat.INT_ARGB_PRE, Texture$Usage.DEFAULT, Texture$WrapMode.REPEAT, n2, n3);
        this.imagePaintTextureRef = new SoftReference<SWArgbPreTexture>(sWArgbPreTexture);
        return sWArgbPreTexture;
    }

    private void disposeImagePaintTexture() {
        if (this.imagePaintTextureRef != null) {
            this.imagePaintTextureRef.clear();
            this.imagePaintTextureRef = null;
        }
    }

    SWArgbPreTexture validateImagePaintTexture(int n2, int n3) {
        SWArgbPreTexture sWArgbPreTexture;
        if (this.imagePaintTextureRef == null) {
            sWArgbPreTexture = this.initImagePaintTexture(n2, n3);
        } else {
            sWArgbPreTexture = this.imagePaintTextureRef.get();
            if (sWArgbPreTexture == null || sWArgbPreTexture.getPhysicalWidth() < n2 || sWArgbPreTexture.getPhysicalHeight() < n3) {
                this.disposeImagePaintTexture();
                sWArgbPreTexture = this.initImagePaintTexture(n2, n3);
            }
            sWArgbPreTexture.setContentWidth(n2);
            sWArgbPreTexture.setContentHeight(n3);
        }
        return sWArgbPreTexture;
    }

    void dispose() {
        this.disposeRBBuffer();
        this.disposeImagePaintTexture();
        this.shapeRenderer.dispose();
    }
}

