/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.j2d;

import com.sun.glass.ui.Pixels;
import com.sun.javafx.geom.Rectangle;
import com.sun.prism.PresentableState;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.impl.QueuedPixelSource;
import com.sun.prism.j2d.J2DPresentable;
import com.sun.prism.j2d.J2DResourceFactory;
import java.awt.image.BufferedImage;
import java.nio.ByteOrder;
import java.nio.IntBuffer;

class J2DPresentable$Glass
extends J2DPresentable {
    private final PresentableState pState;
    private final int theFormat;
    private Pixels pixels;
    private QueuedPixelSource pixelSource = new QueuedPixelSource(false);
    private boolean opaque;
    static final /* synthetic */ boolean $assertionsDisabled;

    J2DPresentable$Glass(PresentableState presentableState, J2DResourceFactory j2DResourceFactory) {
        super(null, j2DResourceFactory);
        this.pState = presentableState;
        this.theFormat = presentableState.getPixelFormat();
        this.needsResize = true;
    }

    @Override
    public BufferedImage createBuffer(int n2, int n3) {
        if (PrismSettings.verbose) {
            System.out.println("Glass native format: " + this.theFormat);
        }
        ByteOrder byteOrder = ByteOrder.nativeOrder();
        switch (this.theFormat) {
            case 1: {
                if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                    return new BufferedImage(n2, n3, 3);
                }
                throw new UnsupportedOperationException("BYTE_BGRA_PRE pixel format on BIG_ENDIAN");
            }
            case 2: {
                if (byteOrder == ByteOrder.BIG_ENDIAN) {
                    return new BufferedImage(n2, n3, 2);
                }
                throw new UnsupportedOperationException("BYTE_ARGB pixel format on LITTLE_ENDIAN");
            }
        }
        throw new UnsupportedOperationException("unrecognized pixel format: " + this.theFormat);
    }

    @Override
    public boolean lockResources(PresentableState presentableState) {
        if (this.pState != presentableState || this.theFormat != presentableState.getPixelFormat()) {
            return true;
        }
        this.needsResize = this.buffer == null || this.buffer.getWidth() != presentableState.getWidth() || this.buffer.getHeight() != presentableState.getHeight();
        return false;
    }

    @Override
    public boolean prepare(Rectangle rectangle) {
        if (!this.pState.isViewClosed()) {
            int n2 = this.getPhysicalWidth();
            int n3 = this.getPhysicalHeight();
            this.pixels = this.pixelSource.getUnusedPixels(n2, n3, 1.0f, 1.0f);
            IntBuffer intBuffer = (IntBuffer)this.pixels.getPixels();
            if (!$assertionsDisabled && !this.ib.hasArray()) {
                throw new AssertionError();
            }
            System.arraycopy(this.ib.array(), 0, intBuffer.array(), 0, n2 * n3);
            return true;
        }
        return false;
    }

    @Override
    public boolean present() {
        this.pixelSource.enqueuePixels(this.pixels);
        this.pState.uploadPixels(this.pixelSource);
        return true;
    }

    @Override
    public int getContentWidth() {
        return this.pState.getWidth();
    }

    @Override
    public int getContentHeight() {
        return this.pState.getHeight();
    }

    @Override
    public void setOpaque(boolean bl2) {
        this.opaque = bl2;
    }

    @Override
    public boolean isOpaque() {
        return this.opaque;
    }

    static {
        $assertionsDisabled = !J2DPresentable.class.desiredAssertionStatus();
    }
}

