/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.impl.ps;

import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.prism.BasicStroke;
import com.sun.prism.Texture$WrapMode;
import com.sun.prism.impl.ps.BaseShaderContext;
import com.sun.prism.impl.ps.CachingShapeRepState;
import com.sun.prism.impl.ps.CachingShapeRepState$CacheEntry;
import com.sun.prism.impl.ps.CachingShapeRepState$MaskTexData;
import com.sun.prism.impl.shape.MaskData;
import com.sun.prism.impl.shape.ShapeUtil;
import java.util.Arrays;
import java.util.Comparator;

class CachingShapeRepState$MaskCache {
    private static final int MAX_MASK_DIM = 512;
    private static final int MAX_SIZE_IN_PIXELS = 0x400000;
    private static Comparator<CachingShapeRepState$CacheEntry> comparator = (cachingShapeRepState$CacheEntry, cachingShapeRepState$CacheEntry2) -> {
        int n2 = Float.compare(cachingShapeRepState$CacheEntry.xformBounds.getWidth(), cachingShapeRepState$CacheEntry2.xformBounds.getWidth());
        if (n2 != 0) {
            return n2;
        }
        return Float.compare(cachingShapeRepState$CacheEntry.xformBounds.getHeight(), cachingShapeRepState$CacheEntry2.xformBounds.getHeight());
    };
    private CachingShapeRepState$CacheEntry[] entries = new CachingShapeRepState$CacheEntry[8];
    private int entriesSize = 0;
    private int totalPixels;
    private CachingShapeRepState$CacheEntry tmpKey = new CachingShapeRepState$CacheEntry();

    private CachingShapeRepState$MaskCache() {
        this.tmpKey.xformBounds = new RectBounds();
    }

    private void ensureSize(int n2) {
        if (this.entries.length < n2) {
            CachingShapeRepState$CacheEntry[] cachingShapeRepState$CacheEntryArray = new CachingShapeRepState$CacheEntry[n2 * 3 / 2];
            System.arraycopy(this.entries, 0, cachingShapeRepState$CacheEntryArray, 0, this.entries.length);
            this.entries = cachingShapeRepState$CacheEntryArray;
        }
    }

    private void addEntry(CachingShapeRepState$CacheEntry cachingShapeRepState$CacheEntry) {
        this.ensureSize(this.entriesSize + 1);
        int n2 = Arrays.binarySearch(this.entries, 0, this.entriesSize, cachingShapeRepState$CacheEntry, comparator);
        if (n2 < 0) {
            n2 ^= 0xFFFFFFFF;
        }
        System.arraycopy(this.entries, n2, this.entries, n2 + 1, this.entriesSize - n2);
        this.entries[n2] = cachingShapeRepState$CacheEntry;
        ++this.entriesSize;
    }

    private void removeEntry(CachingShapeRepState$CacheEntry cachingShapeRepState$CacheEntry) {
        int n2 = Arrays.binarySearch(this.entries, 0, this.entriesSize, cachingShapeRepState$CacheEntry, comparator);
        if (n2 < 0) {
            throw new IllegalStateException("Trying to remove a cached item that's not in the cache");
        }
        if (this.entries[n2] != cachingShapeRepState$CacheEntry) {
            this.tmpKey.xformBounds.deriveWithNewBounds(0.0f, 0.0f, 0.0f, cachingShapeRepState$CacheEntry.xformBounds.getWidth(), Math.nextAfter(cachingShapeRepState$CacheEntry.xformBounds.getHeight(), Double.NEGATIVE_INFINITY), 0.0f);
            n2 = Arrays.binarySearch(this.entries, 0, this.entriesSize, this.tmpKey, comparator);
            if (n2 < 0) {
                n2 ^= 0xFFFFFFFF;
            }
            this.tmpKey.xformBounds.deriveWithNewBounds(0.0f, 0.0f, 0.0f, cachingShapeRepState$CacheEntry.xformBounds.getWidth(), Math.nextAfter(cachingShapeRepState$CacheEntry.xformBounds.getHeight(), Double.POSITIVE_INFINITY), 0.0f);
            int n3 = Arrays.binarySearch(this.entries, 0, this.entriesSize, this.tmpKey, comparator);
            if (n3 < 0) {
                n3 ^= 0xFFFFFFFF;
            }
            while (this.entries[n2] != cachingShapeRepState$CacheEntry && n2 < n3) {
                ++n2;
            }
            if (n2 >= n3) {
                throw new IllegalStateException("Trying to remove a cached item that's not in the cache");
            }
        }
        System.arraycopy(this.entries, n2 + 1, this.entries, n2, this.entriesSize - n2 - 1);
        --this.entriesSize;
    }

    boolean hasRoom(RectBounds rectBounds) {
        int n2 = (int)(rectBounds.getWidth() + 0.5f);
        int n3 = (int)(rectBounds.getHeight() + 0.5f);
        int n4 = n2 * n3;
        return n2 <= 512 && n3 <= 512 && this.totalPixels + n4 <= 0x400000;
    }

    boolean entryMatches(CachingShapeRepState$CacheEntry cachingShapeRepState$CacheEntry, Shape shape, BasicStroke basicStroke, BaseTransform baseTransform, boolean bl2) {
        return cachingShapeRepState$CacheEntry.antialiasedShape == bl2 && CachingShapeRepState.equalsIgnoreTranslation(baseTransform, cachingShapeRepState$CacheEntry.xform) && cachingShapeRepState$CacheEntry.shape.equals(shape) && (basicStroke == null ? cachingShapeRepState$CacheEntry.stroke == null : basicStroke.equals(cachingShapeRepState$CacheEntry.stroke));
    }

    void get(BaseShaderContext baseShaderContext, CachingShapeRepState$MaskTexData cachingShapeRepState$MaskTexData, Shape shape, BasicStroke basicStroke, BaseTransform baseTransform, RectBounds rectBounds, boolean bl2, boolean bl3) {
        Object object;
        if (cachingShapeRepState$MaskTexData == null) {
            throw new InternalError("MaskTexData must be non-null");
        }
        if (cachingShapeRepState$MaskTexData.cacheEntry != null) {
            throw new InternalError("CacheEntry should already be null");
        }
        this.tmpKey.xformBounds.deriveWithNewBounds(0.0f, 0.0f, 0.0f, rectBounds.getWidth(), Math.nextAfter(rectBounds.getHeight(), Double.NEGATIVE_INFINITY), 0.0f);
        int n2 = Arrays.binarySearch(this.entries, 0, this.entriesSize, this.tmpKey, comparator);
        if (n2 < 0) {
            n2 ^= 0xFFFFFFFF;
        }
        this.tmpKey.xformBounds.deriveWithNewBounds(0.0f, 0.0f, 0.0f, rectBounds.getWidth(), Math.nextAfter(rectBounds.getHeight(), Double.POSITIVE_INFINITY), 0.0f);
        int n3 = Arrays.binarySearch(this.entries, 0, this.entriesSize, this.tmpKey, comparator);
        if (n3 < 0) {
            n3 ^= 0xFFFFFFFF;
        }
        while (n2 < n3) {
            object = this.entries[n2];
            if (this.entryMatches((CachingShapeRepState$CacheEntry)object, shape, basicStroke, baseTransform, bl3)) {
                ((CachingShapeRepState$CacheEntry)object).texData.maskTex.lock();
                if (((CachingShapeRepState$CacheEntry)object).texData.maskTex.isSurfaceLost()) {
                    ((CachingShapeRepState$CacheEntry)object).texData.maskTex.unlock();
                } else {
                    ++((CachingShapeRepState$CacheEntry)object).refCount;
                    ((CachingShapeRepState$CacheEntry)object).texData.copyInto(cachingShapeRepState$MaskTexData);
                    cachingShapeRepState$MaskTexData.cacheEntry = object;
                    cachingShapeRepState$MaskTexData.adjustOrigin(baseTransform);
                    return;
                }
            }
            ++n2;
        }
        object = ShapeUtil.rasterizeShape(shape, basicStroke, rectBounds, baseTransform, true, bl3);
        int n4 = ((MaskData)object).getWidth();
        int n5 = ((MaskData)object).getHeight();
        cachingShapeRepState$MaskTexData.maskX = ((MaskData)object).getOriginX();
        cachingShapeRepState$MaskTexData.maskY = ((MaskData)object).getOriginY();
        cachingShapeRepState$MaskTexData.maskW = n4;
        cachingShapeRepState$MaskTexData.maskH = n5;
        cachingShapeRepState$MaskTexData.maskTex = baseShaderContext.getResourceFactory().createMaskTexture(n4, n5, Texture$WrapMode.CLAMP_TO_ZERO);
        ((MaskData)object).uploadToTexture(cachingShapeRepState$MaskTexData.maskTex, 0, 0, false);
        cachingShapeRepState$MaskTexData.maskTex.contentsUseful();
        CachingShapeRepState$CacheEntry cachingShapeRepState$CacheEntry = new CachingShapeRepState$CacheEntry();
        cachingShapeRepState$CacheEntry.shape = shape.copy();
        if (basicStroke != null) {
            cachingShapeRepState$CacheEntry.stroke = basicStroke.copy();
        }
        cachingShapeRepState$CacheEntry.xform = baseTransform.copy();
        cachingShapeRepState$CacheEntry.xformBounds = bl2 ? rectBounds : (RectBounds)rectBounds.copy();
        cachingShapeRepState$CacheEntry.texData = cachingShapeRepState$MaskTexData.copy();
        cachingShapeRepState$CacheEntry.antialiasedShape = bl3;
        cachingShapeRepState$CacheEntry.refCount = 1;
        cachingShapeRepState$MaskTexData.cacheEntry = cachingShapeRepState$CacheEntry;
        this.addEntry(cachingShapeRepState$CacheEntry);
        this.totalPixels += n4 * n5;
    }

    void unref(CachingShapeRepState$MaskTexData cachingShapeRepState$MaskTexData) {
        if (cachingShapeRepState$MaskTexData == null) {
            throw new InternalError("MaskTexData must be non-null");
        }
        CachingShapeRepState$CacheEntry cachingShapeRepState$CacheEntry = cachingShapeRepState$MaskTexData.cacheEntry;
        if (cachingShapeRepState$CacheEntry == null) {
            return;
        }
        cachingShapeRepState$MaskTexData.cacheEntry = null;
        cachingShapeRepState$MaskTexData.maskTex = null;
        --cachingShapeRepState$CacheEntry.refCount;
        if (cachingShapeRepState$CacheEntry.refCount <= 0) {
            this.removeEntry(cachingShapeRepState$CacheEntry);
            cachingShapeRepState$CacheEntry.shape = null;
            cachingShapeRepState$CacheEntry.stroke = null;
            cachingShapeRepState$CacheEntry.xform = null;
            cachingShapeRepState$CacheEntry.xformBounds = null;
            cachingShapeRepState$CacheEntry.texData.maskTex.dispose();
            cachingShapeRepState$CacheEntry.antialiasedShape = false;
            cachingShapeRepState$CacheEntry.texData = null;
            this.totalPixels -= cachingShapeRepState$MaskTexData.maskW * cachingShapeRepState$MaskTexData.maskH;
        }
    }
}

