/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jfxmediaimpl;

import com.sun.media.jfxmedia.Media;
import com.sun.media.jfxmedia.MediaError;
import com.sun.media.jfxmedia.MediaException;
import com.sun.media.jfxmedia.MediaPlayer;
import com.sun.media.jfxmedia.control.VideoRenderControl;
import com.sun.media.jfxmedia.effects.AudioEqualizer;
import com.sun.media.jfxmedia.effects.AudioSpectrum;
import com.sun.media.jfxmedia.events.AudioSpectrumEvent;
import com.sun.media.jfxmedia.events.AudioSpectrumListener;
import com.sun.media.jfxmedia.events.BufferListener;
import com.sun.media.jfxmedia.events.BufferProgressEvent;
import com.sun.media.jfxmedia.events.MarkerEvent;
import com.sun.media.jfxmedia.events.MarkerListener;
import com.sun.media.jfxmedia.events.MediaErrorListener;
import com.sun.media.jfxmedia.events.NewFrameEvent;
import com.sun.media.jfxmedia.events.PlayerEvent;
import com.sun.media.jfxmedia.events.PlayerStateEvent;
import com.sun.media.jfxmedia.events.PlayerStateEvent$PlayerState;
import com.sun.media.jfxmedia.events.PlayerStateListener;
import com.sun.media.jfxmedia.events.PlayerTimeListener;
import com.sun.media.jfxmedia.events.VideoFrameRateListener;
import com.sun.media.jfxmedia.events.VideoRendererListener;
import com.sun.media.jfxmedia.events.VideoTrackSizeListener;
import com.sun.media.jfxmedia.logging.Logger;
import com.sun.media.jfxmedia.track.AudioTrack;
import com.sun.media.jfxmedia.track.SubtitleTrack;
import com.sun.media.jfxmedia.track.Track$Encoding;
import com.sun.media.jfxmedia.track.VideoResolution;
import com.sun.media.jfxmedia.track.VideoTrack;
import com.sun.media.jfxmediaimpl.MarkerStateListener;
import com.sun.media.jfxmediaimpl.MediaPulseTask;
import com.sun.media.jfxmediaimpl.MediaUtils;
import com.sun.media.jfxmediaimpl.NativeAudioEqualizer;
import com.sun.media.jfxmediaimpl.NativeAudioSpectrum;
import com.sun.media.jfxmediaimpl.NativeMedia;
import com.sun.media.jfxmediaimpl.NativeMediaPlayer$EventQueueThread;
import com.sun.media.jfxmediaimpl.NativeMediaPlayer$FrameSizeChangedEvent;
import com.sun.media.jfxmediaimpl.NativeMediaPlayer$MediaErrorEvent;
import com.sun.media.jfxmediaimpl.NativeMediaPlayer$PlayerTimeEvent;
import com.sun.media.jfxmediaimpl.NativeMediaPlayer$TrackEvent;
import com.sun.media.jfxmediaimpl.NativeMediaPlayer$VideoRenderer;
import com.sun.media.jfxmediaimpl.NativeMediaPlayer$WarningEvent;
import com.sun.media.jfxmediaimpl.NativeVideoBuffer;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class NativeMediaPlayer
implements MediaPlayer,
MarkerStateListener {
    public static final int eventPlayerUnknown = 100;
    public static final int eventPlayerReady = 101;
    public static final int eventPlayerPlaying = 102;
    public static final int eventPlayerPaused = 103;
    public static final int eventPlayerStopped = 104;
    public static final int eventPlayerStalled = 105;
    public static final int eventPlayerFinished = 106;
    public static final int eventPlayerError = 107;
    private static final int NOMINAL_VIDEO_FPS = 30;
    public static final long ONE_SECOND = 1000000000L;
    private NativeMedia media;
    private VideoRenderControl videoRenderControl;
    private final List<WeakReference<MediaErrorListener>> errorListeners = new ArrayList<WeakReference<MediaErrorListener>>();
    private final List<WeakReference<PlayerStateListener>> playerStateListeners = new ArrayList<WeakReference<PlayerStateListener>>();
    private final List<WeakReference<PlayerTimeListener>> playerTimeListeners = new ArrayList<WeakReference<PlayerTimeListener>>();
    private final List<WeakReference<VideoTrackSizeListener>> videoTrackSizeListeners = new ArrayList<WeakReference<VideoTrackSizeListener>>();
    private final List<WeakReference<VideoRendererListener>> videoUpdateListeners = new ArrayList<WeakReference<VideoRendererListener>>();
    private final List<WeakReference<VideoFrameRateListener>> videoFrameRateListeners = new ArrayList<WeakReference<VideoFrameRateListener>>();
    private final List<WeakReference<MarkerListener>> markerListeners = new ArrayList<WeakReference<MarkerListener>>();
    private final List<WeakReference<BufferListener>> bufferListeners = new ArrayList<WeakReference<BufferListener>>();
    private final List<WeakReference<AudioSpectrumListener>> audioSpectrumListeners = new ArrayList<WeakReference<AudioSpectrumListener>>();
    private final List<PlayerStateEvent> cachedStateEvents = new ArrayList<PlayerStateEvent>();
    private final List<NativeMediaPlayer$PlayerTimeEvent> cachedTimeEvents = new ArrayList<NativeMediaPlayer$PlayerTimeEvent>();
    private final List<BufferProgressEvent> cachedBufferEvents = new ArrayList<BufferProgressEvent>();
    private final List<NativeMediaPlayer$MediaErrorEvent> cachedErrorEvents = new ArrayList<NativeMediaPlayer$MediaErrorEvent>();
    private boolean isFirstFrame = true;
    private NewFrameEvent firstFrameEvent = null;
    private double firstFrameTime;
    private final Object firstFrameLock = new Object();
    private NativeMediaPlayer$EventQueueThread eventLoop = new NativeMediaPlayer$EventQueueThread(this);
    private int frameWidth = -1;
    private int frameHeight = -1;
    private final AtomicBoolean isMediaPulseEnabled = new AtomicBoolean(false);
    private final Lock mediaPulseLock = new ReentrantLock();
    private Timer mediaPulseTimer;
    private final Lock markerLock = new ReentrantLock();
    private boolean checkSeek = false;
    private double timeBeforeSeek = 0.0;
    private double timeAfterSeek = 0.0;
    private double previousTime = 0.0;
    private double firedMarkerTime = -1.0;
    private double startTime = 0.0;
    private double stopTime = Double.POSITIVE_INFINITY;
    private boolean isStartTimeUpdated = false;
    private boolean isStopTimeSet = false;
    private double encodedFrameRate = 0.0;
    private boolean recomputeFrameRate = true;
    private double previousFrameTime;
    private long numFramesSincePlaying;
    private double meanFrameDuration;
    private double decodedFrameRate;
    private PlayerStateEvent$PlayerState playerState = PlayerStateEvent$PlayerState.UNKNOWN;
    private final Lock disposeLock = new ReentrantLock();
    private boolean isDisposed = false;
    private Runnable onDispose;

    protected NativeMediaPlayer(NativeMedia nativeMedia) {
        if (nativeMedia == null) {
            throw new IllegalArgumentException("clip == null!");
        }
        this.media = nativeMedia;
        this.videoRenderControl = new NativeMediaPlayer$VideoRenderer(this);
    }

    protected void init() {
        this.media.addMarkerStateListener(this);
        this.eventLoop.start();
    }

    void setOnDispose(Runnable runnable) {
        this.disposeLock.lock();
        try {
            if (!this.isDisposed) {
                this.onDispose = runnable;
            }
        }
        finally {
            this.disposeLock.unlock();
        }
    }

    private synchronized void onNativeInit() {
        try {
            this.playerInit();
        }
        catch (MediaException mediaException) {
            this.sendPlayerMediaErrorEvent(mediaException.getMediaError().code());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMediaErrorListener(MediaErrorListener mediaErrorListener) {
        if (mediaErrorListener != null) {
            this.errorListeners.add(new WeakReference<MediaErrorListener>(mediaErrorListener));
            List<NativeMediaPlayer$MediaErrorEvent> list = this.cachedErrorEvents;
            synchronized (list) {
                if (!this.cachedErrorEvents.isEmpty() && !this.errorListeners.isEmpty()) {
                    this.cachedErrorEvents.stream().forEach(nativeMediaPlayer$MediaErrorEvent -> this.sendPlayerEvent((PlayerEvent)nativeMediaPlayer$MediaErrorEvent));
                    this.cachedErrorEvents.clear();
                }
            }
        }
    }

    @Override
    public void removeMediaErrorListener(MediaErrorListener mediaErrorListener) {
        if (mediaErrorListener != null) {
            ListIterator<WeakReference<MediaErrorListener>> listIterator = this.errorListeners.listIterator();
            while (listIterator.hasNext()) {
                MediaErrorListener mediaErrorListener2 = (MediaErrorListener)listIterator.next().get();
                if (mediaErrorListener2 != null && mediaErrorListener2 != mediaErrorListener) continue;
                listIterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMediaPlayerListener(PlayerStateListener playerStateListener) {
        if (playerStateListener != null) {
            List<PlayerStateEvent> list = this.cachedStateEvents;
            synchronized (list) {
                if (!this.cachedStateEvents.isEmpty() && this.playerStateListeners.isEmpty()) {
                    for (PlayerStateEvent playerStateEvent : this.cachedStateEvents) {
                        switch (playerStateEvent.getState()) {
                            case READY: {
                                playerStateListener.onReady(playerStateEvent);
                                break;
                            }
                            case PLAYING: {
                                playerStateListener.onPlaying(playerStateEvent);
                                break;
                            }
                            case PAUSED: {
                                playerStateListener.onPause(playerStateEvent);
                                break;
                            }
                            case STOPPED: {
                                playerStateListener.onStop(playerStateEvent);
                                break;
                            }
                            case STALLED: {
                                playerStateListener.onStall(playerStateEvent);
                                break;
                            }
                            case FINISHED: {
                                playerStateListener.onFinish(playerStateEvent);
                                break;
                            }
                            case HALTED: {
                                playerStateListener.onHalt(playerStateEvent);
                                break;
                            }
                        }
                    }
                    this.cachedStateEvents.clear();
                }
                this.playerStateListeners.add(new WeakReference<PlayerStateListener>(playerStateListener));
            }
        }
    }

    @Override
    public void removeMediaPlayerListener(PlayerStateListener playerStateListener) {
        if (playerStateListener != null) {
            ListIterator<WeakReference<PlayerStateListener>> listIterator = this.playerStateListeners.listIterator();
            while (listIterator.hasNext()) {
                PlayerStateListener playerStateListener2 = (PlayerStateListener)listIterator.next().get();
                if (playerStateListener2 != null && playerStateListener2 != playerStateListener) continue;
                listIterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMediaTimeListener(PlayerTimeListener playerTimeListener) {
        if (playerTimeListener != null) {
            List<NativeMediaPlayer$PlayerTimeEvent> list = this.cachedTimeEvents;
            synchronized (list) {
                if (!this.cachedTimeEvents.isEmpty() && this.playerTimeListeners.isEmpty()) {
                    for (NativeMediaPlayer$PlayerTimeEvent nativeMediaPlayer$PlayerTimeEvent : this.cachedTimeEvents) {
                        playerTimeListener.onDurationChanged(nativeMediaPlayer$PlayerTimeEvent.getTime());
                    }
                    this.cachedTimeEvents.clear();
                } else {
                    double d2 = this.getDuration();
                    if (d2 != Double.POSITIVE_INFINITY) {
                        playerTimeListener.onDurationChanged(d2);
                    }
                }
                this.playerTimeListeners.add(new WeakReference<PlayerTimeListener>(playerTimeListener));
            }
        }
    }

    @Override
    public void removeMediaTimeListener(PlayerTimeListener playerTimeListener) {
        if (playerTimeListener != null) {
            ListIterator<WeakReference<PlayerTimeListener>> listIterator = this.playerTimeListeners.listIterator();
            while (listIterator.hasNext()) {
                PlayerTimeListener playerTimeListener2 = (PlayerTimeListener)listIterator.next().get();
                if (playerTimeListener2 != null && playerTimeListener2 != playerTimeListener) continue;
                listIterator.remove();
            }
        }
    }

    @Override
    public void addVideoTrackSizeListener(VideoTrackSizeListener videoTrackSizeListener) {
        if (videoTrackSizeListener != null) {
            if (this.frameWidth != -1 && this.frameHeight != -1) {
                videoTrackSizeListener.onSizeChanged(this.frameWidth, this.frameHeight);
            }
            this.videoTrackSizeListeners.add(new WeakReference<VideoTrackSizeListener>(videoTrackSizeListener));
        }
    }

    @Override
    public void removeVideoTrackSizeListener(VideoTrackSizeListener videoTrackSizeListener) {
        if (videoTrackSizeListener != null) {
            ListIterator<WeakReference<VideoTrackSizeListener>> listIterator = this.videoTrackSizeListeners.listIterator();
            while (listIterator.hasNext()) {
                VideoTrackSizeListener videoTrackSizeListener2 = (VideoTrackSizeListener)listIterator.next().get();
                if (videoTrackSizeListener2 != null && videoTrackSizeListener2 != videoTrackSizeListener) continue;
                listIterator.remove();
            }
        }
    }

    @Override
    public void addMarkerListener(MarkerListener markerListener) {
        if (markerListener != null) {
            this.markerListeners.add(new WeakReference<MarkerListener>(markerListener));
        }
    }

    @Override
    public void removeMarkerListener(MarkerListener markerListener) {
        if (markerListener != null) {
            ListIterator<WeakReference<MarkerListener>> listIterator = this.markerListeners.listIterator();
            while (listIterator.hasNext()) {
                MarkerListener markerListener2 = (MarkerListener)listIterator.next().get();
                if (markerListener2 != null && markerListener2 != markerListener) continue;
                listIterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBufferListener(BufferListener bufferListener) {
        if (bufferListener != null) {
            List<BufferProgressEvent> list = this.cachedBufferEvents;
            synchronized (list) {
                if (!this.cachedBufferEvents.isEmpty() && this.bufferListeners.isEmpty()) {
                    this.cachedBufferEvents.stream().forEach(bufferProgressEvent -> bufferListener.onBufferProgress((BufferProgressEvent)bufferProgressEvent));
                    this.cachedBufferEvents.clear();
                }
                this.bufferListeners.add(new WeakReference<BufferListener>(bufferListener));
            }
        }
    }

    @Override
    public void removeBufferListener(BufferListener bufferListener) {
        if (bufferListener != null) {
            ListIterator<WeakReference<BufferListener>> listIterator = this.bufferListeners.listIterator();
            while (listIterator.hasNext()) {
                BufferListener bufferListener2 = (BufferListener)listIterator.next().get();
                if (bufferListener2 != null && bufferListener2 != bufferListener) continue;
                listIterator.remove();
            }
        }
    }

    @Override
    public void addAudioSpectrumListener(AudioSpectrumListener audioSpectrumListener) {
        if (audioSpectrumListener != null) {
            this.audioSpectrumListeners.add(new WeakReference<AudioSpectrumListener>(audioSpectrumListener));
        }
    }

    @Override
    public void removeAudioSpectrumListener(AudioSpectrumListener audioSpectrumListener) {
        if (audioSpectrumListener != null) {
            ListIterator<WeakReference<AudioSpectrumListener>> listIterator = this.audioSpectrumListeners.listIterator();
            while (listIterator.hasNext()) {
                AudioSpectrumListener audioSpectrumListener2 = (AudioSpectrumListener)listIterator.next().get();
                if (audioSpectrumListener2 != null && audioSpectrumListener2 != audioSpectrumListener) continue;
                listIterator.remove();
            }
        }
    }

    @Override
    public VideoRenderControl getVideoRenderControl() {
        return this.videoRenderControl;
    }

    @Override
    public Media getMedia() {
        return this.media;
    }

    @Override
    public void setAudioSyncDelay(long l2) {
        try {
            this.playerSetAudioSyncDelay(l2);
        }
        catch (MediaException mediaException) {
            this.sendPlayerEvent(new NativeMediaPlayer$MediaErrorEvent(this, mediaException.getMediaError()));
        }
    }

    @Override
    public long getAudioSyncDelay() {
        try {
            return this.playerGetAudioSyncDelay();
        }
        catch (MediaException mediaException) {
            this.sendPlayerEvent(new NativeMediaPlayer$MediaErrorEvent(this, mediaException.getMediaError()));
            return 0L;
        }
    }

    @Override
    public void play() {
        try {
            if (this.isStartTimeUpdated) {
                this.playerSeek(this.startTime);
            }
            this.isMediaPulseEnabled.set(true);
            this.playerPlay();
        }
        catch (MediaException mediaException) {
            this.sendPlayerEvent(new NativeMediaPlayer$MediaErrorEvent(this, mediaException.getMediaError()));
        }
    }

    @Override
    public void stop() {
        try {
            this.playerStop();
            this.playerSeek(this.startTime);
        }
        catch (MediaException mediaException) {
            MediaUtils.warning(this, "stop() failed!");
        }
    }

    @Override
    public void pause() {
        try {
            this.playerPause();
        }
        catch (MediaException mediaException) {
            this.sendPlayerEvent(new NativeMediaPlayer$MediaErrorEvent(this, mediaException.getMediaError()));
        }
    }

    @Override
    public float getRate() {
        try {
            return this.playerGetRate();
        }
        catch (MediaException mediaException) {
            this.sendPlayerEvent(new NativeMediaPlayer$MediaErrorEvent(this, mediaException.getMediaError()));
            return 0.0f;
        }
    }

    @Override
    public void setRate(float f2) {
        try {
            this.playerSetRate(f2);
        }
        catch (MediaException mediaException) {
            MediaUtils.warning(this, "setRate(" + f2 + ") failed!");
        }
    }

    @Override
    public double getPresentationTime() {
        try {
            return this.playerGetPresentationTime();
        }
        catch (MediaException mediaException) {
            return -1.0;
        }
    }

    @Override
    public float getVolume() {
        try {
            return this.playerGetVolume();
        }
        catch (MediaException mediaException) {
            this.sendPlayerEvent(new NativeMediaPlayer$MediaErrorEvent(this, mediaException.getMediaError()));
            return 0.0f;
        }
    }

    @Override
    public void setVolume(float f2) {
        if (f2 < 0.0f) {
            f2 = 0.0f;
        } else if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        try {
            this.playerSetVolume(f2);
        }
        catch (MediaException mediaException) {
            this.sendPlayerEvent(new NativeMediaPlayer$MediaErrorEvent(this, mediaException.getMediaError()));
        }
    }

    @Override
    public boolean getMute() {
        try {
            return this.playerGetMute();
        }
        catch (MediaException mediaException) {
            this.sendPlayerEvent(new NativeMediaPlayer$MediaErrorEvent(this, mediaException.getMediaError()));
            return false;
        }
    }

    @Override
    public void setMute(boolean bl2) {
        try {
            this.playerSetMute(bl2);
        }
        catch (MediaException mediaException) {
            this.sendPlayerEvent(new NativeMediaPlayer$MediaErrorEvent(this, mediaException.getMediaError()));
        }
    }

    @Override
    public float getBalance() {
        try {
            return this.playerGetBalance();
        }
        catch (MediaException mediaException) {
            this.sendPlayerEvent(new NativeMediaPlayer$MediaErrorEvent(this, mediaException.getMediaError()));
            return 0.0f;
        }
    }

    @Override
    public void setBalance(float f2) {
        if (f2 < -1.0f) {
            f2 = -1.0f;
        } else if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        try {
            this.playerSetBalance(f2);
        }
        catch (MediaException mediaException) {
            this.sendPlayerEvent(new NativeMediaPlayer$MediaErrorEvent(this, mediaException.getMediaError()));
        }
    }

    @Override
    public abstract AudioEqualizer getEqualizer();

    @Override
    public abstract AudioSpectrum getAudioSpectrum();

    @Override
    public double getDuration() {
        try {
            return this.playerGetDuration();
        }
        catch (MediaException mediaException) {
            return Double.POSITIVE_INFINITY;
        }
    }

    @Override
    public double getStartTime() {
        return this.startTime;
    }

    @Override
    public void setStartTime(double d2) {
        try {
            this.markerLock.lock();
            this.startTime = d2;
            if (this.playerState != PlayerStateEvent$PlayerState.PLAYING && this.playerState != PlayerStateEvent$PlayerState.FINISHED && this.playerState != PlayerStateEvent$PlayerState.STOPPED) {
                this.playerSeek(d2);
            } else if (this.playerState == PlayerStateEvent$PlayerState.STOPPED) {
                this.isStartTimeUpdated = true;
            }
        }
        finally {
            this.markerLock.unlock();
        }
    }

    @Override
    public double getStopTime() {
        return this.stopTime;
    }

    @Override
    public void setStopTime(double d2) {
        try {
            this.markerLock.lock();
            this.stopTime = d2;
            this.isStopTimeSet = true;
            this.createMediaPulse();
        }
        finally {
            this.markerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void seek(double d2) {
        if (this.playerState == PlayerStateEvent$PlayerState.STOPPED) {
            return;
        }
        if (d2 < 0.0) {
            d2 = 0.0;
        } else {
            double d3 = this.getDuration();
            if (d3 >= 0.0 && d2 > d3) {
                d2 = d3;
            }
        }
        if (!this.isMediaPulseEnabled.get() && (this.playerState == PlayerStateEvent$PlayerState.PLAYING || this.playerState == PlayerStateEvent$PlayerState.PAUSED || this.playerState == PlayerStateEvent$PlayerState.FINISHED) && this.getStartTime() <= d2 && d2 <= this.getStopTime()) {
            this.isMediaPulseEnabled.set(true);
        }
        this.markerLock.lock();
        try {
            this.timeBeforeSeek = this.getPresentationTime();
            this.timeAfterSeek = d2;
            this.checkSeek = this.timeBeforeSeek != this.timeAfterSeek;
            this.previousTime = d2;
            this.firedMarkerTime = -1.0;
            try {
                this.playerSeek(d2);
            }
            catch (MediaException mediaException) {
                MediaUtils.warning(this, "seek(" + d2 + ") failed!");
            }
        }
        finally {
            this.markerLock.unlock();
        }
    }

    protected abstract long playerGetAudioSyncDelay();

    protected abstract void playerSetAudioSyncDelay(long var1);

    protected abstract void playerPlay();

    protected abstract void playerStop();

    protected abstract void playerPause();

    protected abstract void playerFinish();

    protected abstract float playerGetRate();

    protected abstract void playerSetRate(float var1);

    protected abstract double playerGetPresentationTime();

    protected abstract boolean playerGetMute();

    protected abstract void playerSetMute(boolean var1);

    protected abstract float playerGetVolume();

    protected abstract void playerSetVolume(float var1);

    protected abstract float playerGetBalance();

    protected abstract void playerSetBalance(float var1);

    protected abstract double playerGetDuration();

    protected abstract void playerSeek(double var1);

    protected abstract void playerInit();

    protected abstract void playerDispose();

    @Override
    public PlayerStateEvent$PlayerState getState() {
        return this.playerState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void dispose() {
        block25: {
            this.disposeLock.lock();
            try {
                if (this.isDisposed) break block25;
                this.destroyMediaPulse();
                if (this.eventLoop != null) {
                    this.eventLoop.terminateLoop();
                    this.eventLoop = null;
                }
                ListIterator<WeakReference<VideoRendererListener>> listIterator = this.firstFrameLock;
                synchronized (listIterator) {
                    if (this.firstFrameEvent != null) {
                        this.firstFrameEvent.getFrameData().releaseFrame();
                        this.firstFrameEvent = null;
                    }
                }
                this.playerDispose();
                if (this.media != null) {
                    this.media.dispose();
                    this.media = null;
                }
                if (this.videoUpdateListeners != null) {
                    listIterator = this.videoUpdateListeners.listIterator();
                    while (listIterator.hasNext()) {
                        VideoRendererListener videoRendererListener = (VideoRendererListener)listIterator.next().get();
                        if (videoRendererListener != null) {
                            videoRendererListener.releaseVideoFrames();
                            continue;
                        }
                        listIterator.remove();
                    }
                    this.videoUpdateListeners.clear();
                }
                if (this.playerStateListeners != null) {
                    this.playerStateListeners.clear();
                }
                if (this.videoTrackSizeListeners != null) {
                    this.videoTrackSizeListeners.clear();
                }
                if (this.videoFrameRateListeners != null) {
                    this.videoFrameRateListeners.clear();
                }
                if (this.cachedStateEvents != null) {
                    this.cachedStateEvents.clear();
                }
                if (this.cachedTimeEvents != null) {
                    this.cachedTimeEvents.clear();
                }
                if (this.cachedBufferEvents != null) {
                    this.cachedBufferEvents.clear();
                }
                if (this.errorListeners != null) {
                    this.errorListeners.clear();
                }
                if (this.playerTimeListeners != null) {
                    this.playerTimeListeners.clear();
                }
                if (this.markerListeners != null) {
                    this.markerListeners.clear();
                }
                if (this.bufferListeners != null) {
                    this.bufferListeners.clear();
                }
                if (this.audioSpectrumListeners != null) {
                    this.audioSpectrumListeners.clear();
                }
                if (this.videoRenderControl != null) {
                    this.videoRenderControl = null;
                }
                if (this.onDispose != null) {
                    this.onDispose.run();
                }
                this.isDisposed = true;
            }
            finally {
                this.disposeLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isErrorEventCached() {
        List<NativeMediaPlayer$MediaErrorEvent> list = this.cachedErrorEvents;
        synchronized (list) {
            return !this.cachedErrorEvents.isEmpty();
            {
            }
        }
    }

    protected void sendWarning(int n2, String string) {
        if (this.eventLoop != null) {
            Object object = String.format("Internal media warning: %d", n2);
            if (string != null) {
                object = (String)object + ": " + string;
            }
            this.eventLoop.postEvent(new NativeMediaPlayer$WarningEvent(this, (String)object));
        }
    }

    protected void sendPlayerEvent(PlayerEvent playerEvent) {
        if (this.eventLoop != null) {
            this.eventLoop.postEvent(playerEvent);
        }
    }

    protected void sendPlayerHaltEvent(String string, double d2) {
        Logger.logMsg(4, string);
        if (this.eventLoop != null) {
            this.eventLoop.postEvent(new PlayerStateEvent(PlayerStateEvent$PlayerState.HALTED, d2, string));
        }
    }

    protected void sendPlayerMediaErrorEvent(int n2) {
        this.sendPlayerEvent(new NativeMediaPlayer$MediaErrorEvent(this, MediaError.getFromCode(n2)));
    }

    protected void sendPlayerStateEvent(int n2, double d2) {
        switch (n2) {
            case 101: {
                this.sendPlayerEvent(new PlayerStateEvent(PlayerStateEvent$PlayerState.READY, d2));
                break;
            }
            case 102: {
                this.sendPlayerEvent(new PlayerStateEvent(PlayerStateEvent$PlayerState.PLAYING, d2));
                break;
            }
            case 103: {
                this.sendPlayerEvent(new PlayerStateEvent(PlayerStateEvent$PlayerState.PAUSED, d2));
                break;
            }
            case 104: {
                this.sendPlayerEvent(new PlayerStateEvent(PlayerStateEvent$PlayerState.STOPPED, d2));
                break;
            }
            case 105: {
                this.sendPlayerEvent(new PlayerStateEvent(PlayerStateEvent$PlayerState.STALLED, d2));
                break;
            }
            case 106: {
                this.sendPlayerEvent(new PlayerStateEvent(PlayerStateEvent$PlayerState.FINISHED, d2));
                break;
            }
        }
    }

    protected void sendNewFrameEvent(long l2) {
        NativeVideoBuffer nativeVideoBuffer = NativeVideoBuffer.createVideoBuffer(l2);
        this.sendPlayerEvent(new NewFrameEvent(nativeVideoBuffer));
    }

    protected void sendFrameSizeChangedEvent(int n2, int n3) {
        this.sendPlayerEvent(new NativeMediaPlayer$FrameSizeChangedEvent(n2, n3));
    }

    protected void sendAudioTrack(boolean bl2, long l2, String string, int n2, String string2, int n3, int n4, float f2) {
        Locale locale = null;
        if (!string2.equals("und")) {
            locale = new Locale(string2);
        }
        AudioTrack audioTrack = new AudioTrack(bl2, l2, string, locale, Track$Encoding.toEncoding(n2), n3, n4, f2);
        NativeMediaPlayer$TrackEvent nativeMediaPlayer$TrackEvent = new NativeMediaPlayer$TrackEvent(audioTrack);
        this.sendPlayerEvent(nativeMediaPlayer$TrackEvent);
    }

    protected void sendVideoTrack(boolean bl2, long l2, String string, int n2, int n3, int n4, float f2, boolean bl3) {
        VideoTrack videoTrack = new VideoTrack(bl2, l2, string, null, Track$Encoding.toEncoding(n2), new VideoResolution(n3, n4), f2, bl3);
        NativeMediaPlayer$TrackEvent nativeMediaPlayer$TrackEvent = new NativeMediaPlayer$TrackEvent(videoTrack);
        this.sendPlayerEvent(nativeMediaPlayer$TrackEvent);
    }

    protected void sendSubtitleTrack(boolean bl2, long l2, String string, int n2, String string2) {
        Locale locale = null;
        if (null != string2) {
            locale = new Locale(string2);
        }
        SubtitleTrack subtitleTrack = new SubtitleTrack(bl2, l2, string, locale, Track$Encoding.toEncoding(n2));
        this.sendPlayerEvent(new NativeMediaPlayer$TrackEvent(subtitleTrack));
    }

    protected void sendMarkerEvent(String string, double d2) {
        this.sendPlayerEvent(new MarkerEvent(string, d2));
    }

    protected void sendDurationUpdateEvent(double d2) {
        this.sendPlayerEvent(new NativeMediaPlayer$PlayerTimeEvent(d2));
    }

    protected void sendBufferProgressEvent(double d2, long l2, long l3, long l4) {
        this.sendPlayerEvent(new BufferProgressEvent(d2, l2, l3, l4));
    }

    protected void sendAudioSpectrumEvent(double d2, double d3, boolean bl2) {
        this.sendPlayerEvent(new AudioSpectrumEvent(this.getAudioSpectrum(), d2, d3, bl2));
    }

    @Override
    public void markerStateChanged(boolean bl2) {
        if (bl2) {
            this.markerLock.lock();
            try {
                this.previousTime = this.getPresentationTime();
            }
            finally {
                this.markerLock.unlock();
            }
            this.createMediaPulse();
        } else if (!this.isStopTimeSet) {
            this.destroyMediaPulse();
        }
    }

    private void createMediaPulse() {
        this.mediaPulseLock.lock();
        try {
            if (this.mediaPulseTimer == null) {
                this.mediaPulseTimer = new Timer(true);
                this.mediaPulseTimer.scheduleAtFixedRate((TimerTask)new MediaPulseTask(this), 0L, 40L);
            }
        }
        finally {
            this.mediaPulseLock.unlock();
        }
    }

    private void destroyMediaPulse() {
        this.mediaPulseLock.lock();
        try {
            if (this.mediaPulseTimer != null) {
                this.mediaPulseTimer.cancel();
                this.mediaPulseTimer = null;
            }
        }
        finally {
            this.mediaPulseLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    boolean doMediaPulseTask() {
        block15: {
            if (!this.isMediaPulseEnabled.get()) break block15;
            this.disposeLock.lock();
            if (this.isDisposed) {
                this.disposeLock.unlock();
                return false;
            }
            var1_1 = this.getPresentationTime();
            this.markerLock.lock();
            try {
                block16: {
                    if (!this.checkSeek) break block16;
                    if (!(this.timeAfterSeek > this.timeBeforeSeek)) ** GOTO lbl16
                    if (var1_1 >= this.timeAfterSeek) {
                        this.checkSeek = false;
                    } else {
                        var3_2 = true;
                        return var3_2;
lbl16:
                        // 1 sources

                        if (this.timeAfterSeek < this.timeBeforeSeek) {
                            if (var1_1 >= this.timeBeforeSeek) {
                                var3_3 = true;
                                return var3_3;
                            }
                            this.checkSeek = false;
                        }
                    }
                }
                var3_4 = this.media.getNextMarker(this.previousTime, true);
                while (var3_4 != null && !((var4_5 = var3_4.getKey().doubleValue()) > var1_1)) {
                    if (var4_5 != this.firedMarkerTime && var4_5 >= this.previousTime && var4_5 >= this.getStartTime() && var4_5 <= this.getStopTime()) {
                        var6_6 = new MarkerEvent(var3_4.getValue(), var4_5);
                        var7_7 = this.markerListeners.listIterator();
                        while (var7_7.hasNext()) {
                            var8_8 = (MarkerListener)var7_7.next().get();
                            if (var8_8 != null) {
                                var8_8.onMarker(var6_6);
                                continue;
                            }
                            var7_7.remove();
                        }
                        this.firedMarkerTime = var4_5;
                    }
                    var3_4 = this.media.getNextMarker(var4_5, false);
                }
                this.previousTime = var1_1;
                if (this.isStopTimeSet && var1_1 >= this.stopTime) {
                    this.playerFinish();
                }
            }
            finally {
                this.disposeLock.unlock();
                this.markerLock.unlock();
            }
        }
        return true;
    }

    protected AudioEqualizer createNativeAudioEqualizer(long l2) {
        return new NativeAudioEqualizer(l2);
    }

    protected AudioSpectrum createNativeAudioSpectrum(long l2) {
        return new NativeAudioSpectrum(l2);
    }
}

