/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jfxmediaimpl;

import com.sun.media.jfxmedia.events.AudioSpectrumEvent;
import com.sun.media.jfxmedia.events.AudioSpectrumListener;
import com.sun.media.jfxmedia.events.BufferListener;
import com.sun.media.jfxmedia.events.BufferProgressEvent;
import com.sun.media.jfxmedia.events.MarkerEvent;
import com.sun.media.jfxmedia.events.MarkerListener;
import com.sun.media.jfxmedia.events.MediaErrorListener;
import com.sun.media.jfxmedia.events.NewFrameEvent;
import com.sun.media.jfxmedia.events.PlayerEvent;
import com.sun.media.jfxmedia.events.PlayerStateEvent;
import com.sun.media.jfxmedia.events.PlayerStateEvent$PlayerState;
import com.sun.media.jfxmedia.events.PlayerStateListener;
import com.sun.media.jfxmedia.events.PlayerTimeListener;
import com.sun.media.jfxmedia.events.VideoFrameRateListener;
import com.sun.media.jfxmedia.events.VideoRendererListener;
import com.sun.media.jfxmedia.events.VideoTrackSizeListener;
import com.sun.media.jfxmedia.logging.Logger;
import com.sun.media.jfxmedia.track.VideoTrack;
import com.sun.media.jfxmediaimpl.NativeMediaPlayer;
import com.sun.media.jfxmediaimpl.NativeMediaPlayer$FrameSizeChangedEvent;
import com.sun.media.jfxmediaimpl.NativeMediaPlayer$MediaErrorEvent;
import com.sun.media.jfxmediaimpl.NativeMediaPlayer$PlayerTimeEvent;
import com.sun.media.jfxmediaimpl.NativeMediaPlayer$TrackEvent;
import com.sun.media.jfxmediaimpl.NativeMediaPlayer$WarningEvent;
import java.lang.ref.WeakReference;
import java.util.ListIterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

class NativeMediaPlayer$EventQueueThread
extends Thread {
    private final BlockingQueue<PlayerEvent> eventQueue = new LinkedBlockingQueue<PlayerEvent>();
    private volatile boolean stopped = false;
    final /* synthetic */ NativeMediaPlayer this$0;

    NativeMediaPlayer$EventQueueThread(NativeMediaPlayer nativeMediaPlayer) {
        this.this$0 = nativeMediaPlayer;
        this.setName("JFXMedia Player EventQueueThread");
        this.setDaemon(true);
    }

    @Override
    public void run() {
        while (!this.stopped) {
            try {
                PlayerEvent playerEvent = this.eventQueue.take();
                if (this.stopped) continue;
                if (playerEvent instanceof NewFrameEvent) {
                    try {
                        this.HandleRendererEvents((NewFrameEvent)playerEvent);
                    }
                    catch (Throwable throwable) {
                        if (!Logger.canLog(4)) continue;
                        Logger.logMsg(4, "Caught exception in HandleRendererEvents: " + throwable.toString());
                    }
                    continue;
                }
                if (playerEvent instanceof PlayerStateEvent) {
                    this.HandleStateEvents((PlayerStateEvent)playerEvent);
                    continue;
                }
                if (playerEvent instanceof NativeMediaPlayer$FrameSizeChangedEvent) {
                    this.HandleFrameSizeChangedEvents((NativeMediaPlayer$FrameSizeChangedEvent)playerEvent);
                    continue;
                }
                if (playerEvent instanceof NativeMediaPlayer$TrackEvent) {
                    this.HandleTrackEvents((NativeMediaPlayer$TrackEvent)playerEvent);
                    continue;
                }
                if (playerEvent instanceof MarkerEvent) {
                    this.HandleMarkerEvents((MarkerEvent)playerEvent);
                    continue;
                }
                if (playerEvent instanceof NativeMediaPlayer$WarningEvent) {
                    this.HandleWarningEvents((NativeMediaPlayer$WarningEvent)playerEvent);
                    continue;
                }
                if (playerEvent instanceof NativeMediaPlayer$PlayerTimeEvent) {
                    this.HandlePlayerTimeEvents((NativeMediaPlayer$PlayerTimeEvent)playerEvent);
                    continue;
                }
                if (playerEvent instanceof BufferProgressEvent) {
                    this.HandleBufferEvents((BufferProgressEvent)playerEvent);
                    continue;
                }
                if (playerEvent instanceof AudioSpectrumEvent) {
                    this.HandleAudioSpectrumEvents((AudioSpectrumEvent)playerEvent);
                    continue;
                }
                if (!(playerEvent instanceof NativeMediaPlayer$MediaErrorEvent)) continue;
                this.HandleErrorEvents((NativeMediaPlayer$MediaErrorEvent)playerEvent);
            }
            catch (Exception exception) {}
        }
        this.eventQueue.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void HandleRendererEvents(NewFrameEvent newFrameEvent) {
        Object object;
        if (this.this$0.isFirstFrame) {
            this.this$0.isFirstFrame = false;
            object = this.this$0.firstFrameLock;
            synchronized (object) {
                this.this$0.firstFrameEvent = newFrameEvent;
                this.this$0.firstFrameTime = this.this$0.firstFrameEvent.getFrameData().getTimestamp();
                this.this$0.firstFrameEvent.getFrameData().holdFrame();
            }
        }
        if (this.this$0.firstFrameEvent != null && this.this$0.firstFrameTime != newFrameEvent.getFrameData().getTimestamp()) {
            object = this.this$0.firstFrameLock;
            synchronized (object) {
                this.this$0.firstFrameEvent.getFrameData().releaseFrame();
                this.this$0.firstFrameEvent = null;
            }
        }
        object = this.this$0.videoUpdateListeners.listIterator();
        while (object.hasNext()) {
            VideoRendererListener videoRendererListener = (VideoRendererListener)object.next().get();
            if (videoRendererListener != null) {
                videoRendererListener.videoFrameUpdated(newFrameEvent);
                continue;
            }
            object.remove();
        }
        newFrameEvent.getFrameData().releaseFrame();
        if (!this.this$0.videoFrameRateListeners.isEmpty()) {
            double d2 = (double)System.nanoTime() / 1.0E9;
            if (this.this$0.recomputeFrameRate) {
                this.this$0.recomputeFrameRate = false;
                this.this$0.previousFrameTime = d2;
                this.this$0.numFramesSincePlaying = 1L;
            } else {
                boolean bl2 = false;
                if (this.this$0.numFramesSincePlaying == 1L) {
                    this.this$0.meanFrameDuration = d2 - this.this$0.previousFrameTime;
                    if (this.this$0.meanFrameDuration > 0.0) {
                        this.this$0.decodedFrameRate = 1.0 / this.this$0.meanFrameDuration;
                        bl2 = true;
                    }
                } else {
                    double d3 = this.this$0.meanFrameDuration;
                    int n2 = this.this$0.encodedFrameRate != 0.0 ? (int)(this.this$0.encodedFrameRate + 0.5) : 30;
                    long l2 = this.this$0.numFramesSincePlaying < (long)n2 ? this.this$0.numFramesSincePlaying : (long)n2;
                    this.this$0.meanFrameDuration = ((double)(l2 - 1L) * d3 + d2 - this.this$0.previousFrameTime) / (double)l2;
                    if (this.this$0.meanFrameDuration > 0.0 && Math.abs(this.this$0.decodedFrameRate - 1.0 / this.this$0.meanFrameDuration) > 0.5) {
                        this.this$0.decodedFrameRate = 1.0 / this.this$0.meanFrameDuration;
                        bl2 = true;
                    }
                }
                if (bl2) {
                    ListIterator<WeakReference<VideoFrameRateListener>> listIterator = this.this$0.videoFrameRateListeners.listIterator();
                    while (listIterator.hasNext()) {
                        VideoFrameRateListener videoFrameRateListener = (VideoFrameRateListener)listIterator.next().get();
                        if (videoFrameRateListener != null) {
                            videoFrameRateListener.onFrameRateChanged(this.this$0.decodedFrameRate);
                            continue;
                        }
                        listIterator.remove();
                    }
                }
                this.this$0.previousFrameTime = d2;
                ++this.this$0.numFramesSincePlaying;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void HandleStateEvents(PlayerStateEvent playerStateEvent) {
        this.this$0.playerState = playerStateEvent.getState();
        this.this$0.recomputeFrameRate = PlayerStateEvent$PlayerState.PLAYING == playerStateEvent.getState();
        switch (this.this$0.playerState) {
            case READY: {
                this.this$0.onNativeInit();
                this.sendFakeBufferProgressEvent();
                break;
            }
            case PLAYING: {
                this.this$0.isMediaPulseEnabled.set(true);
                break;
            }
            case STOPPED: 
            case FINISHED: {
                this.this$0.doMediaPulseTask();
            }
            case PAUSED: 
            case STALLED: 
            case HALTED: {
                this.this$0.isMediaPulseEnabled.set(false);
                break;
            }
        }
        Object object = this.this$0.cachedStateEvents;
        synchronized (object) {
            if (this.this$0.playerStateListeners.isEmpty()) {
                this.this$0.cachedStateEvents.add(playerStateEvent);
                return;
            }
        }
        object = this.this$0.playerStateListeners.listIterator();
        block18: while (object.hasNext()) {
            PlayerStateListener playerStateListener = (PlayerStateListener)((WeakReference)object.next()).get();
            if (playerStateListener != null) {
                switch (this.this$0.playerState) {
                    case READY: {
                        this.this$0.onNativeInit();
                        this.sendFakeBufferProgressEvent();
                        playerStateListener.onReady(playerStateEvent);
                        continue block18;
                    }
                    case PLAYING: {
                        playerStateListener.onPlaying(playerStateEvent);
                        continue block18;
                    }
                    case PAUSED: {
                        playerStateListener.onPause(playerStateEvent);
                        continue block18;
                    }
                    case STOPPED: {
                        playerStateListener.onStop(playerStateEvent);
                        continue block18;
                    }
                    case STALLED: {
                        playerStateListener.onStall(playerStateEvent);
                        continue block18;
                    }
                    case FINISHED: {
                        playerStateListener.onFinish(playerStateEvent);
                        continue block18;
                    }
                    case HALTED: {
                        playerStateListener.onHalt(playerStateEvent);
                        continue block18;
                    }
                }
                continue;
            }
            object.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void HandlePlayerTimeEvents(NativeMediaPlayer$PlayerTimeEvent nativeMediaPlayer$PlayerTimeEvent) {
        Object object = this.this$0.cachedTimeEvents;
        synchronized (object) {
            if (this.this$0.playerTimeListeners.isEmpty()) {
                this.this$0.cachedTimeEvents.add(nativeMediaPlayer$PlayerTimeEvent);
                return;
            }
        }
        object = this.this$0.playerTimeListeners.listIterator();
        while (object.hasNext()) {
            PlayerTimeListener playerTimeListener = (PlayerTimeListener)((WeakReference)object.next()).get();
            if (playerTimeListener != null) {
                playerTimeListener.onDurationChanged(nativeMediaPlayer$PlayerTimeEvent.getTime());
                continue;
            }
            object.remove();
        }
    }

    private void HandleFrameSizeChangedEvents(NativeMediaPlayer$FrameSizeChangedEvent nativeMediaPlayer$FrameSizeChangedEvent) {
        this.this$0.frameWidth = nativeMediaPlayer$FrameSizeChangedEvent.getWidth();
        this.this$0.frameHeight = nativeMediaPlayer$FrameSizeChangedEvent.getHeight();
        Logger.logMsg(1, "** Frame size changed (" + this.this$0.frameWidth + ", " + this.this$0.frameHeight + ")");
        ListIterator<WeakReference<VideoTrackSizeListener>> listIterator = this.this$0.videoTrackSizeListeners.listIterator();
        while (listIterator.hasNext()) {
            VideoTrackSizeListener videoTrackSizeListener = (VideoTrackSizeListener)listIterator.next().get();
            if (videoTrackSizeListener != null) {
                videoTrackSizeListener.onSizeChanged(this.this$0.frameWidth, this.this$0.frameHeight);
                continue;
            }
            listIterator.remove();
        }
    }

    private void HandleTrackEvents(NativeMediaPlayer$TrackEvent nativeMediaPlayer$TrackEvent) {
        this.this$0.media.addTrack(nativeMediaPlayer$TrackEvent.getTrack());
        if (nativeMediaPlayer$TrackEvent.getTrack() instanceof VideoTrack) {
            this.this$0.encodedFrameRate = ((VideoTrack)nativeMediaPlayer$TrackEvent.getTrack()).getEncodedFrameRate();
        }
    }

    private void HandleMarkerEvents(MarkerEvent markerEvent) {
        ListIterator<WeakReference<MarkerListener>> listIterator = this.this$0.markerListeners.listIterator();
        while (listIterator.hasNext()) {
            MarkerListener markerListener = (MarkerListener)listIterator.next().get();
            if (markerListener != null) {
                markerListener.onMarker(markerEvent);
                continue;
            }
            listIterator.remove();
        }
    }

    private void HandleWarningEvents(NativeMediaPlayer$WarningEvent nativeMediaPlayer$WarningEvent) {
        Logger.logMsg(3, nativeMediaPlayer$WarningEvent.getSource() + nativeMediaPlayer$WarningEvent.getMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void HandleErrorEvents(NativeMediaPlayer$MediaErrorEvent nativeMediaPlayer$MediaErrorEvent) {
        Logger.logMsg(4, nativeMediaPlayer$MediaErrorEvent.getMessage());
        Object object = this.this$0.cachedErrorEvents;
        synchronized (object) {
            if (this.this$0.errorListeners.isEmpty()) {
                this.this$0.cachedErrorEvents.add(nativeMediaPlayer$MediaErrorEvent);
                return;
            }
        }
        object = this.this$0.errorListeners.listIterator();
        while (object.hasNext()) {
            MediaErrorListener mediaErrorListener = (MediaErrorListener)((WeakReference)object.next()).get();
            if (mediaErrorListener != null) {
                mediaErrorListener.onError(nativeMediaPlayer$MediaErrorEvent.getSource(), nativeMediaPlayer$MediaErrorEvent.getErrorCode(), nativeMediaPlayer$MediaErrorEvent.getMessage());
                continue;
            }
            object.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void HandleBufferEvents(BufferProgressEvent bufferProgressEvent) {
        Object object = this.this$0.cachedBufferEvents;
        synchronized (object) {
            if (this.this$0.bufferListeners.isEmpty()) {
                this.this$0.cachedBufferEvents.add(bufferProgressEvent);
                return;
            }
        }
        object = this.this$0.bufferListeners.listIterator();
        while (object.hasNext()) {
            BufferListener bufferListener = (BufferListener)((WeakReference)object.next()).get();
            if (bufferListener != null) {
                bufferListener.onBufferProgress(bufferProgressEvent);
                continue;
            }
            object.remove();
        }
    }

    private void HandleAudioSpectrumEvents(AudioSpectrumEvent audioSpectrumEvent) {
        ListIterator<WeakReference<AudioSpectrumListener>> listIterator = this.this$0.audioSpectrumListeners.listIterator();
        while (listIterator.hasNext()) {
            AudioSpectrumListener audioSpectrumListener = (AudioSpectrumListener)listIterator.next().get();
            if (audioSpectrumListener != null) {
                if (audioSpectrumEvent.queryTimestamp()) {
                    double d2 = this.this$0.playerGetPresentationTime();
                    audioSpectrumEvent.setTimestamp(d2);
                }
                audioSpectrumListener.onAudioSpectrumEvent(audioSpectrumEvent);
                continue;
            }
            listIterator.remove();
        }
    }

    public void postEvent(PlayerEvent playerEvent) {
        if (this.eventQueue != null) {
            this.eventQueue.offer(playerEvent);
        }
    }

    public void terminateLoop() {
        this.stopped = true;
        try {
            this.eventQueue.put(new PlayerEvent());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void sendFakeBufferProgressEvent() {
        String string = this.this$0.media.getLocator().getContentType();
        String string2 = this.this$0.media.getLocator().getProtocol();
        if (string != null && (string.equals("audio/mpegurl") || string.equals("application/vnd.apple.mpegurl")) || string2 != null && !string2.equals("http") && !string2.equals("https")) {
            this.HandleBufferEvents(new BufferProgressEvent(this.this$0.getDuration(), 0L, 1L, 1L));
        }
    }
}

