/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jfxmediaimpl;

import com.sun.media.jfxmedia.MediaManager;
import com.sun.media.jfxmedia.MediaPlayer;
import com.sun.media.jfxmedia.events.MediaErrorListener;
import com.sun.media.jfxmedia.events.PlayerStateEvent;
import com.sun.media.jfxmedia.events.PlayerStateListener;
import com.sun.media.jfxmedia.locator.Locator;
import com.sun.media.jfxmedia.logging.Logger;
import com.sun.media.jfxmediaimpl.NativeMediaAudioClip;
import com.sun.media.jfxmediaimpl.NativeMediaAudioClipPlayer$Enthreaderator;
import com.sun.media.jfxmediaimpl.NativeMediaAudioClipPlayer$SchedulerEntry;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

final class NativeMediaAudioClipPlayer
implements MediaErrorListener,
PlayerStateListener {
    private MediaPlayer mediaPlayer;
    private int playCount;
    private int loopCount;
    private boolean playing;
    private boolean ready;
    private NativeMediaAudioClip sourceClip;
    private double volume;
    private double balance;
    private double pan;
    private double rate;
    private int priority;
    private final ReentrantLock playerStateLock = new ReentrantLock();
    private static final int MAX_PLAYER_COUNT = 16;
    private static final List<NativeMediaAudioClipPlayer> activePlayers = new ArrayList<NativeMediaAudioClipPlayer>(16);
    private static final ReentrantLock playerListLock = new ReentrantLock();
    private static final LinkedBlockingQueue<NativeMediaAudioClipPlayer$SchedulerEntry> schedule = new LinkedBlockingQueue();

    public static int getPlayerLimit() {
        return 16;
    }

    public static int getPlayerCount() {
        return activePlayers.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clipScheduler() {
        while (true) {
            Object object;
            NativeMediaAudioClipPlayer$SchedulerEntry nativeMediaAudioClipPlayer$SchedulerEntry = null;
            try {
                nativeMediaAudioClipPlayer$SchedulerEntry = schedule.take();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (null == nativeMediaAudioClipPlayer$SchedulerEntry) continue;
            if (nativeMediaAudioClipPlayer$SchedulerEntry.getCommand() == 0) {
                object = nativeMediaAudioClipPlayer$SchedulerEntry.getPlayer();
                if (null != object) {
                    if (NativeMediaAudioClipPlayer.addPlayer((NativeMediaAudioClipPlayer)object)) {
                        ((NativeMediaAudioClipPlayer)object).play();
                    } else {
                        ((NativeMediaAudioClipPlayer)object).sourceClip.playFinished();
                    }
                }
            } else if (nativeMediaAudioClipPlayer$SchedulerEntry.getCommand() == 1) {
                object = nativeMediaAudioClipPlayer$SchedulerEntry.getClipURI();
                playerListLock.lock();
                try {
                    NativeMediaAudioClipPlayer[] nativeMediaAudioClipPlayerArray = new NativeMediaAudioClipPlayer[16];
                    nativeMediaAudioClipPlayerArray = activePlayers.toArray(nativeMediaAudioClipPlayerArray);
                    if (null != nativeMediaAudioClipPlayerArray) {
                        for (int i2 = 0; i2 < nativeMediaAudioClipPlayerArray.length; ++i2) {
                            if (null == nativeMediaAudioClipPlayerArray[i2] || null != object && !nativeMediaAudioClipPlayerArray[i2].source().getURI().equals(object)) continue;
                            nativeMediaAudioClipPlayerArray[i2].invalidate();
                        }
                    }
                }
                finally {
                    playerListLock.unlock();
                }
                boolean bl2 = null == object;
                for (NativeMediaAudioClipPlayer$SchedulerEntry nativeMediaAudioClipPlayer$SchedulerEntry2 : schedule) {
                    NativeMediaAudioClipPlayer nativeMediaAudioClipPlayer = nativeMediaAudioClipPlayer$SchedulerEntry2.getPlayer();
                    if (!bl2 && (null == nativeMediaAudioClipPlayer || !nativeMediaAudioClipPlayer.sourceClip.getLocator().getURI().equals(object))) continue;
                    schedule.remove(nativeMediaAudioClipPlayer$SchedulerEntry2);
                    nativeMediaAudioClipPlayer.sourceClip.playFinished();
                }
            } else if (nativeMediaAudioClipPlayer$SchedulerEntry.getCommand() == 2) {
                nativeMediaAudioClipPlayer$SchedulerEntry.getMediaPlayer().dispose();
            }
            nativeMediaAudioClipPlayer$SchedulerEntry.signal();
        }
    }

    public static void playClip(NativeMediaAudioClip nativeMediaAudioClip, double d2, double d3, double d4, double d5, int n2, int n3) {
        NativeMediaAudioClipPlayer$Enthreaderator.getSchedulerThread();
        NativeMediaAudioClipPlayer nativeMediaAudioClipPlayer = new NativeMediaAudioClipPlayer(nativeMediaAudioClip, d2, d3, d4, d5, n2, n3);
        NativeMediaAudioClipPlayer$SchedulerEntry nativeMediaAudioClipPlayer$SchedulerEntry = new NativeMediaAudioClipPlayer$SchedulerEntry(nativeMediaAudioClipPlayer);
        boolean bl2 = schedule.contains(nativeMediaAudioClipPlayer$SchedulerEntry);
        if (bl2 || !schedule.offer(nativeMediaAudioClipPlayer$SchedulerEntry)) {
            if (Logger.canLog(1) && !bl2) {
                Logger.logMsg(1, "AudioClip could not be scheduled for playback!");
            }
            nativeMediaAudioClip.playFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean addPlayer(NativeMediaAudioClipPlayer nativeMediaAudioClipPlayer) {
        playerListLock.lock();
        try {
            int n2 = nativeMediaAudioClipPlayer.priority();
            while (activePlayers.size() >= 16) {
                NativeMediaAudioClipPlayer nativeMediaAudioClipPlayer2 = null;
                for (NativeMediaAudioClipPlayer nativeMediaAudioClipPlayer3 : activePlayers) {
                    if (nativeMediaAudioClipPlayer3.priority() > n2 || nativeMediaAudioClipPlayer2 != null && (!nativeMediaAudioClipPlayer2.isReady() || nativeMediaAudioClipPlayer3.priority() >= nativeMediaAudioClipPlayer2.priority())) continue;
                    nativeMediaAudioClipPlayer2 = nativeMediaAudioClipPlayer3;
                }
                if (null == nativeMediaAudioClipPlayer2) {
                    boolean bl2 = false;
                    return bl2;
                }
                nativeMediaAudioClipPlayer2.invalidate();
            }
            activePlayers.add(nativeMediaAudioClipPlayer);
        }
        finally {
            playerListLock.unlock();
        }
        return true;
    }

    public static void stopPlayers(Locator locator) {
        CountDownLatch countDownLatch;
        NativeMediaAudioClipPlayer$SchedulerEntry nativeMediaAudioClipPlayer$SchedulerEntry;
        URI uRI;
        URI uRI2 = uRI = locator != null ? locator.getURI() : null;
        if (null != NativeMediaAudioClipPlayer$Enthreaderator.getSchedulerThread() && schedule.offer(nativeMediaAudioClipPlayer$SchedulerEntry = new NativeMediaAudioClipPlayer$SchedulerEntry(uRI, countDownLatch = new CountDownLatch(1)))) {
            try {
                countDownLatch.await(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private NativeMediaAudioClipPlayer(NativeMediaAudioClip nativeMediaAudioClip, double d2, double d3, double d4, double d5, int n2, int n3) {
        this.sourceClip = nativeMediaAudioClip;
        this.volume = d2;
        this.balance = d3;
        this.pan = d5;
        this.rate = d4;
        this.loopCount = n2;
        this.priority = n3;
        this.ready = false;
    }

    private Locator source() {
        return this.sourceClip.getLocator();
    }

    public double volume() {
        return this.volume;
    }

    public void setVolume(double d2) {
        this.volume = d2;
    }

    public double balance() {
        return this.balance;
    }

    public void setBalance(double d2) {
        this.balance = d2;
    }

    public double pan() {
        return this.pan;
    }

    public void setPan(double d2) {
        this.pan = d2;
    }

    public double playbackRate() {
        return this.rate;
    }

    public void setPlaybackRate(double d2) {
        this.rate = d2;
    }

    public int priority() {
        return this.priority;
    }

    public void setPriority(int n2) {
        this.priority = n2;
    }

    public int loopCount() {
        return this.loopCount;
    }

    public void setLoopCount(int n2) {
        this.loopCount = n2;
    }

    public boolean isPlaying() {
        return this.playing;
    }

    private boolean isReady() {
        return this.ready;
    }

    public synchronized void play() {
        this.playerStateLock.lock();
        try {
            this.playing = true;
            this.playCount = 0;
            if (null == this.mediaPlayer) {
                this.mediaPlayer = MediaManager.getPlayer(this.source());
                this.mediaPlayer.addMediaPlayerListener(this);
                this.mediaPlayer.addMediaErrorListener(this);
            } else {
                this.mediaPlayer.play();
            }
        }
        finally {
            this.playerStateLock.unlock();
        }
    }

    public void stop() {
        this.invalidate();
    }

    public synchronized void invalidate() {
        this.playerStateLock.lock();
        playerListLock.lock();
        try {
            this.playing = false;
            this.playCount = 0;
            this.ready = false;
            activePlayers.remove(this);
            this.sourceClip.playFinished();
            if (null != this.mediaPlayer) {
                this.mediaPlayer.removeMediaPlayerListener(this);
                this.mediaPlayer.setMute(true);
                NativeMediaAudioClipPlayer$SchedulerEntry nativeMediaAudioClipPlayer$SchedulerEntry = new NativeMediaAudioClipPlayer$SchedulerEntry(this.mediaPlayer);
                if (!schedule.offer(nativeMediaAudioClipPlayer$SchedulerEntry)) {
                    this.mediaPlayer.dispose();
                }
                this.mediaPlayer = null;
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            playerListLock.unlock();
            this.playerStateLock.unlock();
        }
    }

    @Override
    public void onReady(PlayerStateEvent playerStateEvent) {
        this.playerStateLock.lock();
        try {
            this.ready = true;
            if (this.playing) {
                this.mediaPlayer.setVolume((float)this.volume);
                this.mediaPlayer.setBalance((float)this.balance);
                this.mediaPlayer.setRate((float)this.rate);
                this.mediaPlayer.play();
            }
        }
        finally {
            this.playerStateLock.unlock();
        }
    }

    @Override
    public void onPlaying(PlayerStateEvent playerStateEvent) {
    }

    @Override
    public void onPause(PlayerStateEvent playerStateEvent) {
    }

    @Override
    public void onStop(PlayerStateEvent playerStateEvent) {
        this.invalidate();
    }

    @Override
    public void onStall(PlayerStateEvent playerStateEvent) {
    }

    @Override
    public void onFinish(PlayerStateEvent playerStateEvent) {
        this.playerStateLock.lock();
        try {
            if (this.playing) {
                if (this.loopCount != -1) {
                    ++this.playCount;
                    if (this.playCount <= this.loopCount) {
                        this.mediaPlayer.seek(0.0);
                    } else {
                        this.invalidate();
                    }
                } else {
                    this.mediaPlayer.seek(0.0);
                }
            }
        }
        finally {
            this.playerStateLock.unlock();
        }
    }

    @Override
    public void onHalt(PlayerStateEvent playerStateEvent) {
        this.invalidate();
    }

    public void onWarning(Object object, String string) {
    }

    @Override
    public void onError(Object object, int n2, String string) {
        if (Logger.canLog(4)) {
            Logger.logMsg(4, "Error with AudioClip player: code " + n2 + " : " + string);
        }
        this.invalidate();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof NativeMediaAudioClipPlayer) {
            URI uRI;
            NativeMediaAudioClipPlayer nativeMediaAudioClipPlayer = (NativeMediaAudioClipPlayer)object;
            URI uRI2 = this.sourceClip.getLocator().getURI();
            return uRI2.equals(uRI = nativeMediaAudioClipPlayer.sourceClip.getLocator().getURI()) && this.priority == nativeMediaAudioClipPlayer.priority && this.loopCount == nativeMediaAudioClipPlayer.loopCount && Double.compare(this.volume, nativeMediaAudioClipPlayer.volume) == 0 && Double.compare(this.balance, nativeMediaAudioClipPlayer.balance) == 0 && Double.compare(this.rate, nativeMediaAudioClipPlayer.rate) == 0 && Double.compare(this.pan, nativeMediaAudioClipPlayer.pan) == 0;
        }
        return false;
    }
}

