/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jfxmediaimpl;

import com.sun.media.jfxmedia.logging.Logger;
import com.sun.media.jfxmediaimpl.MediaDisposer$Disposable;
import com.sun.media.jfxmediaimpl.MediaDisposer$ResourceDisposer;
import com.sun.media.jfxmediaimpl.MediaDisposer$ResourceDisposerRecord;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.HashMap;
import java.util.Map;

public class MediaDisposer {
    private final ReferenceQueue<Object> purgatory = new ReferenceQueue();
    private final Map<Reference, MediaDisposer$Disposable> disposers = new HashMap<Reference, MediaDisposer$Disposable>();
    private static MediaDisposer theDisposinator;

    public static void addResourceDisposer(Object object, Object object2, MediaDisposer$ResourceDisposer mediaDisposer$ResourceDisposer) {
        MediaDisposer.disposinator().implAddResourceDisposer(object, object2, mediaDisposer$ResourceDisposer);
    }

    public static void removeResourceDisposer(Object object) {
        MediaDisposer.disposinator().implRemoveResourceDisposer(object);
    }

    public static void addDisposable(Object object, MediaDisposer$Disposable mediaDisposer$Disposable) {
        MediaDisposer.disposinator().implAddDisposable(object, mediaDisposer$Disposable);
    }

    private static synchronized MediaDisposer disposinator() {
        if (null == theDisposinator) {
            theDisposinator = new MediaDisposer();
            Thread thread = new Thread(() -> theDisposinator.disposerLoop(), "Media Resource Disposer");
            thread.setDaemon(true);
            thread.start();
        }
        return theDisposinator;
    }

    private MediaDisposer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposerLoop() {
        while (true) {
            try {
                while (true) {
                    MediaDisposer$Disposable mediaDisposer$Disposable;
                    Reference<Object> reference = this.purgatory.remove();
                    Map<Reference, MediaDisposer$Disposable> map = this.disposers;
                    synchronized (map) {
                        mediaDisposer$Disposable = this.disposers.remove(reference);
                    }
                    reference.clear();
                    if (null != mediaDisposer$Disposable) {
                        mediaDisposer$Disposable.dispose();
                    }
                    reference = null;
                    mediaDisposer$Disposable = null;
                }
            }
            catch (InterruptedException interruptedException) {
                if (!Logger.canLog(1)) continue;
                Logger.logMsg(1, MediaDisposer.class.getName(), "disposerLoop", "Disposer loop interrupted, terminating");
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void implAddResourceDisposer(Object object, Object object2, MediaDisposer$ResourceDisposer mediaDisposer$ResourceDisposer) {
        PhantomReference<Object> phantomReference = new PhantomReference<Object>(object, this.purgatory);
        Map<Reference, MediaDisposer$Disposable> map = this.disposers;
        synchronized (map) {
            this.disposers.put(phantomReference, new MediaDisposer$ResourceDisposerRecord(object2, mediaDisposer$ResourceDisposer));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void implRemoveResourceDisposer(Object object) {
        Reference reference = null;
        Map<Reference, MediaDisposer$Disposable> map = this.disposers;
        synchronized (map) {
            for (Map.Entry<Reference, MediaDisposer$Disposable> entry : this.disposers.entrySet()) {
                MediaDisposer$Disposable mediaDisposer$Disposable = entry.getValue();
                if (!(mediaDisposer$Disposable instanceof MediaDisposer$ResourceDisposerRecord)) continue;
                MediaDisposer$ResourceDisposerRecord mediaDisposer$ResourceDisposerRecord = (MediaDisposer$ResourceDisposerRecord)mediaDisposer$Disposable;
                if (!mediaDisposer$ResourceDisposerRecord.resource.equals(object)) continue;
                reference = entry.getKey();
                break;
            }
            if (null != reference) {
                this.disposers.remove(reference);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void implAddDisposable(Object object, MediaDisposer$Disposable mediaDisposer$Disposable) {
        PhantomReference<Object> phantomReference = new PhantomReference<Object>(object, this.purgatory);
        Map<Reference, MediaDisposer$Disposable> map = this.disposers;
        synchronized (map) {
            this.disposers.put(phantomReference, mediaDisposer$Disposable);
        }
    }
}

