/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jfxmedia.locator;

import com.sun.media.jfxmedia.locator.LocatorCache$CacheDisposer;
import com.sun.media.jfxmedia.locator.LocatorCache$CacheInitializer;
import com.sun.media.jfxmedia.locator.LocatorCache$CacheReference;
import com.sun.media.jfxmedia.logging.Logger;
import com.sun.media.jfxmediaimpl.MediaDisposer;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

public class LocatorCache {
    private final Map<URI, WeakReference<LocatorCache$CacheReference>> uriCache = new HashMap<URI, WeakReference<LocatorCache$CacheReference>>();
    private final LocatorCache$CacheDisposer cacheDisposer = new LocatorCache$CacheDisposer(this);

    public static LocatorCache locatorCache() {
        return LocatorCache$CacheInitializer.globalInstance;
    }

    private LocatorCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocatorCache$CacheReference registerURICache(URI uRI, ByteBuffer object, String string) {
        Object object2;
        if (Logger.canLog(1)) {
            Logger.logMsg(1, "New cache entry: URI " + uRI + ", buffer " + (ByteBuffer)object + ", MIME type " + string);
        }
        if (!((ByteBuffer)object).isDirect()) {
            ((ByteBuffer)object).rewind();
            object2 = ByteBuffer.allocateDirect(((Buffer)object).capacity());
            ((ByteBuffer)object2).put((ByteBuffer)object);
            object = object2;
        }
        object2 = new LocatorCache$CacheReference((ByteBuffer)object, string);
        Map<URI, WeakReference<LocatorCache$CacheReference>> map = this.uriCache;
        synchronized (map) {
            this.uriCache.put(uRI, new WeakReference<Object>(object2));
        }
        MediaDisposer.addResourceDisposer(object2, uRI, this.cacheDisposer);
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocatorCache$CacheReference fetchURICache(URI uRI) {
        Map<URI, WeakReference<LocatorCache$CacheReference>> map = this.uriCache;
        synchronized (map) {
            WeakReference<LocatorCache$CacheReference> weakReference = this.uriCache.get(uRI);
            if (null == weakReference) {
                return null;
            }
            LocatorCache$CacheReference locatorCache$CacheReference = (LocatorCache$CacheReference)weakReference.get();
            if (null != locatorCache$CacheReference) {
                if (Logger.canLog(1)) {
                    Logger.logMsg(1, "Fetched cache entry: URI " + uRI + ", buffer " + locatorCache$CacheReference.getBuffer() + ", MIME type " + locatorCache$CacheReference.getMIMEType());
                }
                return locatorCache$CacheReference;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCached(URI uRI) {
        Map<URI, WeakReference<LocatorCache$CacheReference>> map = this.uriCache;
        synchronized (map) {
            return this.uriCache.containsKey(uRI);
        }
    }
}

