/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jfxmedia.locator;

import com.sun.media.jfxmedia.locator.ConnectionHolder;
import com.sun.media.jfxmedia.locator.HLSConnectionHolder$Playlist;
import com.sun.media.jfxmedia.locator.HLSConnectionHolder$PlaylistThread;
import com.sun.media.jfxmedia.locator.HLSConnectionHolder$VariantPlaylist;
import com.sun.media.jfxmedia.locator.Locator;
import java.io.IOException;
import java.net.URI;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;

final class HLSConnectionHolder
extends ConnectionHolder {
    private URLConnection urlConnection = null;
    private HLSConnectionHolder$PlaylistThread playlistThread = new HLSConnectionHolder$PlaylistThread(this);
    private HLSConnectionHolder$VariantPlaylist variantPlaylist = null;
    private HLSConnectionHolder$Playlist currentPlaylist = null;
    private int mediaFileIndex = -1;
    private CountDownLatch readySignal = new CountDownLatch(1);
    private Semaphore liveSemaphore = new Semaphore(0);
    private boolean isPlaylistClosed = false;
    private boolean isBitrateAdjustable = false;
    private long startTime = -1L;
    private static final long HLS_VALUE_FLOAT_MULTIPLIER = 1000L;
    private static final int HLS_PROP_GET_DURATION = 1;
    private static final int HLS_PROP_GET_HLS_MODE = 2;
    private static final int HLS_PROP_GET_MIMETYPE = 3;
    private static final int HLS_VALUE_MIMETYPE_MP2T = 1;
    private static final int HLS_VALUE_MIMETYPE_MP3 = 2;
    private static final String CHARSET_UTF_8 = "UTF-8";
    private static final String CHARSET_US_ASCII = "US-ASCII";

    HLSConnectionHolder(URI uRI) {
        this.playlistThread.setPlaylistURI(uRI);
        this.init();
    }

    private void init() {
        this.playlistThread.putState(0);
        this.playlistThread.start();
    }

    @Override
    public int readNextBlock() {
        if (this.isBitrateAdjustable && this.startTime == -1L) {
            this.startTime = System.currentTimeMillis();
        }
        int n2 = super.readNextBlock();
        if (this.isBitrateAdjustable && n2 == -1) {
            long l2 = System.currentTimeMillis() - this.startTime;
            this.startTime = -1L;
            this.adjustBitrate(l2);
        }
        return n2;
    }

    @Override
    int readBlock(long l2, int n2) {
        throw new IOException();
    }

    @Override
    boolean needBuffer() {
        return true;
    }

    @Override
    boolean isSeekable() {
        return true;
    }

    @Override
    boolean isRandomAccess() {
        return false;
    }

    @Override
    public long seek(long l2) {
        try {
            this.readySignal.await();
        }
        catch (Exception exception) {
            return -1L;
        }
        return (long)(this.currentPlaylist.seek(l2) * 1000.0);
    }

    @Override
    public void closeConnection() {
        this.currentPlaylist.close();
        super.closeConnection();
        this.resetConnection();
        this.playlistThread.putState(1);
    }

    @Override
    int property(int n2, int n3) {
        try {
            this.readySignal.await();
        }
        catch (Exception exception) {
            return -1;
        }
        if (n2 == 1) {
            return (int)(this.currentPlaylist.getDuration() * 1000.0);
        }
        if (n2 == 2) {
            return 1;
        }
        if (n2 == 3) {
            return this.currentPlaylist.getMimeType();
        }
        return -1;
    }

    @Override
    int getStreamSize() {
        try {
            this.readySignal.await();
        }
        catch (Exception exception) {
            return -1;
        }
        return this.loadNextSegment();
    }

    private void resetConnection() {
        super.closeConnection();
        Locator.closeConnection(this.urlConnection);
        this.urlConnection = null;
    }

    private int loadNextSegment() {
        this.resetConnection();
        String string = this.currentPlaylist.getNextMediaFile();
        if (string == null) {
            return -1;
        }
        try {
            URI uRI = new URI(string);
            this.urlConnection = uRI.toURL().openConnection();
            this.channel = this.openChannel();
        }
        catch (Exception exception) {
            return -1;
        }
        if (this.currentPlaylist.isCurrentMediaFileDiscontinuity()) {
            return -1 * this.urlConnection.getContentLength();
        }
        return this.urlConnection.getContentLength();
    }

    private ReadableByteChannel openChannel() {
        return Channels.newChannel(this.urlConnection.getInputStream());
    }

    private void adjustBitrate(long l2) {
        int n2 = (int)((long)this.urlConnection.getContentLength() * 8L * 1000L / l2);
        HLSConnectionHolder$Playlist hLSConnectionHolder$Playlist = this.variantPlaylist.getPlaylistBasedOnBitrate(n2);
        if (hLSConnectionHolder$Playlist != null && hLSConnectionHolder$Playlist != this.currentPlaylist) {
            if (this.currentPlaylist.isLive()) {
                hLSConnectionHolder$Playlist.update(this.currentPlaylist.getNextMediaFile());
                this.playlistThread.setReloadPlaylist(hLSConnectionHolder$Playlist);
            }
            hLSConnectionHolder$Playlist.setForceDiscontinuity(true);
            this.currentPlaylist = hLSConnectionHolder$Playlist;
        }
    }

    private static String stripParameters(String string) {
        int n2 = string.indexOf(63);
        if (n2 > 0) {
            string = string.substring(0, n2);
        }
        return string;
    }
}

