/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jfxmedia.locator;

import com.sun.media.jfxmedia.MediaError;
import com.sun.media.jfxmedia.locator.HLSConnectionHolder;
import com.sun.media.jfxmedia.locator.Locator;
import com.sun.media.jfxmediaimpl.MediaUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

class HLSConnectionHolder$PlaylistParser {
    private boolean isFirstLine = true;
    private boolean isLineMediaFileURI = false;
    private boolean isEndList = false;
    private boolean isLinePlaylistURI = false;
    private boolean isVariantPlaylist = false;
    private boolean isDiscontinuity = false;
    private int targetDuration = 0;
    private int sequenceNumber = 0;
    private int dataListIndex = -1;
    private List<String> dataListString = new ArrayList<String>();
    private List<Integer> dataListInteger = new ArrayList<Integer>();
    private List<Double> dataListDouble = new ArrayList<Double>();
    private List<Boolean> dataListBoolean = new ArrayList<Boolean>();

    private HLSConnectionHolder$PlaylistParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(URI uRI) {
        HttpURLConnection httpURLConnection = null;
        BufferedReader bufferedReader = null;
        try {
            Charset charset;
            httpURLConnection = (HttpURLConnection)uRI.toURL().openConnection();
            httpURLConnection.setRequestMethod("GET");
            if (httpURLConnection.getResponseCode() != 200) {
                MediaUtils.error(this, MediaError.ERROR_LOCATOR_CONNECTION_LOST.code(), "HTTP responce code: " + httpURLConnection.getResponseCode(), null);
            }
            if ((charset = this.getCharset(uRI.toURL().toExternalForm(), httpURLConnection.getContentType())) != null) {
                bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream(), charset));
            }
            if (bufferedReader != null) {
                boolean bl2;
                while (bl2 = this.parseLine(bufferedReader.readLine())) {
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IOException iOException) {
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
                Locator.closeConnection(httpURLConnection);
            }
        }
    }

    private boolean isVariantPlaylist() {
        return this.isVariantPlaylist;
    }

    private boolean isLivePlaylist() {
        return !this.isEndList;
    }

    private int getTargetDuration() {
        return this.targetDuration;
    }

    private int getSequenceNumber() {
        return this.sequenceNumber;
    }

    private boolean hasNext() {
        ++this.dataListIndex;
        return this.dataListString.size() > this.dataListIndex || this.dataListInteger.size() > this.dataListIndex || this.dataListDouble.size() > this.dataListIndex || this.dataListBoolean.size() > this.dataListIndex;
    }

    private String getString() {
        return this.dataListString.get(this.dataListIndex);
    }

    private Integer getInteger() {
        return this.dataListInteger.get(this.dataListIndex);
    }

    private Double getDouble() {
        return this.dataListDouble.get(this.dataListIndex);
    }

    private Boolean getBoolean() {
        return this.dataListBoolean.get(this.dataListIndex);
    }

    private boolean parseLine(String string) {
        if (string == null) {
            return false;
        }
        if (this.isFirstLine) {
            if (string.compareTo("#EXTM3U") != 0) {
                return false;
            }
            this.isFirstLine = false;
            return true;
        }
        if (string.isEmpty() || string.startsWith("#") && !string.startsWith("#EXT")) {
            return true;
        }
        if (string.startsWith("#EXTINF")) {
            String[] stringArray;
            String[] stringArray2 = string.split(":");
            if (stringArray2.length == 2 && stringArray2[1].length() > 0 && (stringArray = stringArray2[1].split(",")).length >= 1) {
                this.dataListDouble.add(Double.parseDouble(stringArray[0]));
            }
            this.isLineMediaFileURI = true;
        } else if (string.startsWith("#EXT-X-TARGETDURATION")) {
            String[] stringArray = string.split(":");
            if (stringArray.length == 2 && stringArray[1].length() > 0) {
                this.targetDuration = Integer.parseInt(stringArray[1]);
            }
        } else if (string.startsWith("#EXT-X-MEDIA-SEQUENCE")) {
            String[] stringArray = string.split(":");
            if (stringArray.length == 2 && stringArray[1].length() > 0) {
                this.sequenceNumber = Integer.parseInt(stringArray[1]);
            }
        } else if (string.startsWith("#EXT-X-STREAM-INF")) {
            String[] stringArray;
            this.isVariantPlaylist = true;
            int n2 = 0;
            String[] stringArray3 = string.split(":");
            if (stringArray3.length == 2 && stringArray3[1].length() > 0 && (stringArray = stringArray3[1].split(",")).length > 0) {
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    String[] stringArray4;
                    stringArray[i2] = stringArray[i2].trim();
                    if (!stringArray[i2].startsWith("BANDWIDTH") || (stringArray4 = stringArray[i2].split("=")).length != 2 || stringArray4[1].length() <= 0) continue;
                    n2 = Integer.parseInt(stringArray4[1]);
                }
            }
            if (n2 < 1) {
                return false;
            }
            this.dataListInteger.add(n2);
            this.isLinePlaylistURI = true;
        } else if (string.startsWith("#EXT-X-ENDLIST")) {
            this.isEndList = true;
        } else if (string.startsWith("#EXT-X-DISCONTINUITY")) {
            this.isDiscontinuity = true;
        } else if (this.isLinePlaylistURI) {
            this.isLinePlaylistURI = false;
            this.dataListString.add(string);
        } else if (this.isLineMediaFileURI) {
            this.isLineMediaFileURI = false;
            this.dataListString.add(string);
            this.dataListBoolean.add(this.isDiscontinuity);
            this.isDiscontinuity = false;
        }
        return true;
    }

    private Charset getCharset(String string, String string2) {
        if (string != null && HLSConnectionHolder.stripParameters(string).endsWith(".m3u8") || string2 != null && string2.equals("application/vnd.apple.mpegurl")) {
            if (Charset.isSupported("UTF-8")) {
                return Charset.forName("UTF-8");
            }
        } else if ((string != null && HLSConnectionHolder.stripParameters(string).endsWith(".m3u") || string2 != null && string2.equals("audio/mpegurl")) && Charset.isSupported("US-ASCII")) {
            return Charset.forName("US-ASCII");
        }
        return null;
    }
}

