/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jfxmedia.locator;

import com.sun.media.jfxmedia.locator.HLSConnectionHolder;
import com.sun.media.jfxmedia.locator.HLSConnectionHolder$PlaylistParser;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

class HLSConnectionHolder$Playlist {
    private boolean isLive = false;
    private volatile boolean isLiveWaiting = false;
    private volatile boolean isLiveStop = false;
    private long targetDuration = 0L;
    private URI playlistURI = null;
    private final Object lock = new Object();
    private List<String> mediaFiles = new ArrayList<String>();
    private List<Double> mediaFilesStartTimes = new ArrayList<Double>();
    private List<Boolean> mediaFilesDiscontinuities = new ArrayList<Boolean>();
    private boolean needBaseURI = true;
    private String baseURI = null;
    private double duration = 0.0;
    private int sequenceNumber = -1;
    private int sequenceNumberStart = -1;
    private boolean sequenceNumberUpdated = false;
    private boolean forceDiscontinuity = false;
    final /* synthetic */ HLSConnectionHolder this$0;

    private HLSConnectionHolder$Playlist(HLSConnectionHolder hLSConnectionHolder, boolean bl2, int n2) {
        this.this$0 = hLSConnectionHolder;
        this.isLive = bl2;
        this.targetDuration = n2 * 1000;
        if (bl2) {
            this.duration = -1.0;
        }
    }

    private HLSConnectionHolder$Playlist(HLSConnectionHolder hLSConnectionHolder, URI uRI) {
        this.this$0 = hLSConnectionHolder;
        this.playlistURI = uRI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(String string) {
        HLSConnectionHolder$PlaylistParser hLSConnectionHolder$PlaylistParser = new HLSConnectionHolder$PlaylistParser();
        hLSConnectionHolder$PlaylistParser.load(this.playlistURI);
        this.isLive = hLSConnectionHolder$PlaylistParser.isLivePlaylist();
        this.targetDuration = hLSConnectionHolder$PlaylistParser.getTargetDuration() * 1000;
        if (this.isLive) {
            this.duration = -1.0;
        }
        if (this.setSequenceNumber(hLSConnectionHolder$PlaylistParser.getSequenceNumber())) {
            while (hLSConnectionHolder$PlaylistParser.hasNext()) {
                this.addMediaFile(hLSConnectionHolder$PlaylistParser.getString(), hLSConnectionHolder$PlaylistParser.getDouble(), hLSConnectionHolder$PlaylistParser.getBoolean());
            }
        }
        if (string != null) {
            Object object = this.lock;
            synchronized (object) {
                for (int i2 = 0; i2 < this.mediaFiles.size(); ++i2) {
                    String string2 = this.mediaFiles.get(i2);
                    if (!string.endsWith(string2)) continue;
                    this.this$0.mediaFileIndex = i2 - 1;
                    break;
                }
            }
        }
    }

    private boolean isLive() {
        return this.isLive;
    }

    private long getTargetDuration() {
        return this.targetDuration;
    }

    private void setPlaylistURI(URI uRI) {
        this.playlistURI = uRI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMediaFile(String string, double d2, boolean bl2) {
        Object object = this.lock;
        synchronized (object) {
            if (this.needBaseURI) {
                this.setBaseURI(this.playlistURI.toString(), string);
            }
            if (this.isLive) {
                if (this.sequenceNumberUpdated) {
                    int n2 = this.mediaFiles.indexOf(string);
                    if (n2 != -1) {
                        for (int i2 = 0; i2 < n2; ++i2) {
                            this.mediaFiles.remove(0);
                            this.mediaFilesDiscontinuities.remove(0);
                            if (this.this$0.mediaFileIndex == -1) {
                                this.forceDiscontinuity = true;
                            }
                            if (this.this$0.mediaFileIndex < 0) continue;
                            --this.this$0.mediaFileIndex;
                        }
                    }
                    this.sequenceNumberUpdated = false;
                }
                if (this.mediaFiles.contains(string)) {
                    return;
                }
            }
            this.mediaFiles.add(string);
            this.mediaFilesDiscontinuities.add(bl2);
            if (this.isLive) {
                if (this.isLiveWaiting) {
                    this.this$0.liveSemaphore.release();
                }
            } else {
                this.mediaFilesStartTimes.add(this.duration);
                this.duration += d2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getNextMediaFile() {
        Object object;
        if (this.isLive) {
            object = this.lock;
            synchronized (object) {
                this.isLiveWaiting = this.this$0.mediaFileIndex + 1 >= this.mediaFiles.size();
            }
            if (this.isLiveWaiting) {
                try {
                    this.this$0.liveSemaphore.acquire();
                    this.isLiveWaiting = false;
                    if (this.isLiveStop) {
                        this.isLiveStop = false;
                        return null;
                    }
                }
                catch (InterruptedException interruptedException) {
                    this.isLiveWaiting = false;
                    return null;
                }
            }
            if (this.this$0.isPlaylistClosed) {
                return null;
            }
        }
        object = this.lock;
        synchronized (object) {
            ++this.this$0.mediaFileIndex;
            if (this.this$0.mediaFileIndex < this.mediaFiles.size()) {
                if (this.baseURI != null) {
                    return this.baseURI + this.mediaFiles.get(this.this$0.mediaFileIndex);
                }
                return this.mediaFiles.get(this.this$0.mediaFileIndex);
            }
            return null;
        }
    }

    private double getDuration() {
        return this.duration;
    }

    private void setForceDiscontinuity(boolean bl2) {
        this.forceDiscontinuity = bl2;
    }

    private boolean isCurrentMediaFileDiscontinuity() {
        if (this.forceDiscontinuity) {
            this.forceDiscontinuity = false;
            return true;
        }
        return this.mediaFilesDiscontinuities.get(this.this$0.mediaFileIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double seek(long l2) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isLive) {
                if (l2 == 0L) {
                    this.this$0.mediaFileIndex = -1;
                    if (this.isLiveWaiting) {
                        this.isLiveStop = true;
                        this.this$0.liveSemaphore.release();
                    }
                    return 0.0;
                }
            } else {
                l2 += this.targetDuration / 2000L;
                int n2 = this.mediaFilesStartTimes.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (!((double)l2 >= this.mediaFilesStartTimes.get(i2))) continue;
                    if (i2 + 1 < n2) {
                        if (!((double)l2 < this.mediaFilesStartTimes.get(i2 + 1))) continue;
                        this.this$0.mediaFileIndex = i2 - 1;
                        return this.mediaFilesStartTimes.get(i2);
                    }
                    if ((double)(l2 - this.targetDuration / 2000L) < this.duration) {
                        this.this$0.mediaFileIndex = i2 - 1;
                        return this.mediaFilesStartTimes.get(i2);
                    }
                    if (Double.compare(l2 - this.targetDuration / 2000L, this.duration) != 0) continue;
                    return this.duration;
                }
            }
        }
        return -1.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getMimeType() {
        Object object = this.lock;
        synchronized (object) {
            if (this.mediaFiles.size() > 0) {
                if (HLSConnectionHolder.stripParameters(this.mediaFiles.get(0)).endsWith(".ts")) {
                    return 1;
                }
                if (HLSConnectionHolder.stripParameters(this.mediaFiles.get(0)).endsWith(".mp3")) {
                    return 2;
                }
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getMediaFileExtension() {
        Object object = this.lock;
        synchronized (object) {
            String string;
            int n2;
            if (this.mediaFiles.size() > 0 && (n2 = (string = HLSConnectionHolder.stripParameters(this.mediaFiles.get(0))).lastIndexOf(".")) != -1) {
                return string.substring(n2);
            }
        }
        return null;
    }

    private boolean setSequenceNumber(int n2) {
        if (this.sequenceNumberStart == -1) {
            this.sequenceNumberStart = n2;
        } else if (this.sequenceNumber != n2) {
            this.sequenceNumberUpdated = true;
            this.sequenceNumber = n2;
        } else {
            return false;
        }
        return true;
    }

    private void close() {
        if (this.isLive) {
            this.this$0.isPlaylistClosed = true;
            this.this$0.liveSemaphore.release();
        }
    }

    private void setBaseURI(String string, String string2) {
        if (!string2.startsWith("http://") && !string2.startsWith("https://")) {
            this.baseURI = string.substring(0, string.lastIndexOf("/") + 1);
        }
        this.needBaseURI = false;
    }
}

