/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jfxmedia.locator;

import com.sun.media.jfxmedia.locator.ConnectionHolder$FileConnectionHolder;
import com.sun.media.jfxmedia.locator.ConnectionHolder$MemoryConnectionHolder;
import com.sun.media.jfxmedia.locator.ConnectionHolder$URIConnectionHolder;
import com.sun.media.jfxmedia.locator.HLSConnectionHolder;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.util.Map;

public abstract class ConnectionHolder {
    private static int DEFAULT_BUFFER_SIZE = 4096;
    ReadableByteChannel channel;
    ByteBuffer buffer = ByteBuffer.allocateDirect(DEFAULT_BUFFER_SIZE);

    static ConnectionHolder createMemoryConnectionHolder(ByteBuffer byteBuffer) {
        return new ConnectionHolder$MemoryConnectionHolder(byteBuffer);
    }

    static ConnectionHolder createURIConnectionHolder(URI uRI, Map<String, Object> map) {
        return new ConnectionHolder$URIConnectionHolder(uRI, map);
    }

    static ConnectionHolder createFileConnectionHolder(URI uRI) {
        return new ConnectionHolder$FileConnectionHolder(uRI);
    }

    static ConnectionHolder createHLSConnectionHolder(URI uRI) {
        return new HLSConnectionHolder(uRI);
    }

    public int readNextBlock() {
        this.buffer.rewind();
        if (this.buffer.limit() < this.buffer.capacity()) {
            this.buffer.limit(this.buffer.capacity());
        }
        if (null == this.channel) {
            throw new ClosedChannelException();
        }
        return this.channel.read(this.buffer);
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    abstract int readBlock(long var1, int var3);

    abstract boolean needBuffer();

    abstract boolean isSeekable();

    abstract boolean isRandomAccess();

    public abstract long seek(long var1);

    public void closeConnection() {
        try {
            if (this.channel != null) {
                this.channel.close();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            this.channel = null;
        }
    }

    int property(int n2, int n3) {
        return 0;
    }

    int getStreamSize() {
        return -1;
    }
}

