/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jfxmedia.locator;

import com.sun.media.jfxmedia.locator.ConnectionHolder;
import com.sun.media.jfxmedia.locator.Locator;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Map;

class ConnectionHolder$URIConnectionHolder
extends ConnectionHolder {
    private URI uri;
    private URLConnection urlConnection;

    ConnectionHolder$URIConnectionHolder(URI uRI, Map<String, Object> map) {
        this.uri = uRI;
        this.urlConnection = uRI.toURL().openConnection();
        if (map != null) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                Object object = entry.getValue();
                if (!(object instanceof String)) continue;
                this.urlConnection.setRequestProperty(entry.getKey(), (String)object);
            }
        }
        this.channel = this.openChannel(null);
    }

    @Override
    boolean needBuffer() {
        String string = this.uri.getScheme().toLowerCase();
        return "http".equals(string) || "https".equals(string);
    }

    @Override
    boolean isSeekable() {
        return this.urlConnection instanceof HttpURLConnection || this.urlConnection instanceof JarURLConnection || this.isJRT() || this.isResource();
    }

    @Override
    boolean isRandomAccess() {
        return false;
    }

    @Override
    int readBlock(long l2, int n2) {
        throw new IOException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long seek(long l2) {
        if (this.urlConnection instanceof HttpURLConnection) {
            URLConnection uRLConnection = null;
            try {
                uRLConnection = this.uri.toURL().openConnection();
                HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                httpURLConnection.setRequestMethod("GET");
                httpURLConnection.setUseCaches(false);
                httpURLConnection.setRequestProperty("Range", "bytes=" + l2 + "-");
                if (httpURLConnection.getResponseCode() == 206) {
                    this.closeConnection();
                    this.urlConnection = uRLConnection;
                    uRLConnection = null;
                    this.channel = this.openChannel(null);
                    long l3 = l2;
                    return l3;
                }
                long l4 = -1L;
                return l4;
            }
            catch (IOException iOException) {
                long l5 = -1L;
                return l5;
            }
            finally {
                if (uRLConnection != null) {
                    Locator.closeConnection(uRLConnection);
                }
            }
        }
        if (this.urlConnection instanceof JarURLConnection || this.isJRT() || this.isResource()) {
            try {
                long l6;
                this.closeConnection();
                this.urlConnection = this.uri.toURL().openConnection();
                long l7 = l2;
                InputStream inputStream = this.urlConnection.getInputStream();
                while ((l7 -= (l6 = inputStream.skip(l7))) > 0L) {
                }
                this.channel = this.openChannel(inputStream);
                return l2;
            }
            catch (IOException iOException) {
                return -1L;
            }
        }
        return -1L;
    }

    @Override
    public void closeConnection() {
        super.closeConnection();
        Locator.closeConnection(this.urlConnection);
        this.urlConnection = null;
    }

    private ReadableByteChannel openChannel(InputStream inputStream) {
        return inputStream == null ? Channels.newChannel(this.urlConnection.getInputStream()) : Channels.newChannel(inputStream);
    }

    private boolean isJRT() {
        String string = this.uri.getScheme().toLowerCase();
        return "jrt".equals(string);
    }

    private boolean isResource() {
        String string = this.uri.getScheme().toLowerCase();
        return "resource".equals(string);
    }
}

