/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jfxmedia.locator;

import com.sun.media.jfxmedia.locator.ConnectionHolder;
import com.sun.media.jfxmedia.locator.ConnectionHolder$MemoryConnectionHolder$1;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;

class ConnectionHolder$MemoryConnectionHolder
extends ConnectionHolder {
    private final ByteBuffer backingBuffer;

    public ConnectionHolder$MemoryConnectionHolder(ByteBuffer byteBuffer) {
        if (null == byteBuffer) {
            throw new IllegalArgumentException("Can't connect to null buffer...");
        }
        if (byteBuffer.isDirect()) {
            this.backingBuffer = byteBuffer.duplicate();
        } else {
            this.backingBuffer = ByteBuffer.allocateDirect(byteBuffer.capacity());
            this.backingBuffer.put(byteBuffer);
        }
        this.backingBuffer.rewind();
        this.channel = new ConnectionHolder$MemoryConnectionHolder$1(this);
    }

    @Override
    int readBlock(long l2, int n2) {
        if (null == this.channel) {
            throw new ClosedChannelException();
        }
        if ((int)l2 > this.backingBuffer.capacity()) {
            return -1;
        }
        this.backingBuffer.position((int)l2);
        this.buffer = this.backingBuffer.slice();
        int n3 = Math.min(this.backingBuffer.remaining(), n2);
        this.buffer.limit(n3);
        this.backingBuffer.position(this.backingBuffer.position() + n3);
        return n3;
    }

    @Override
    boolean needBuffer() {
        return false;
    }

    @Override
    boolean isSeekable() {
        return true;
    }

    @Override
    boolean isRandomAccess() {
        return true;
    }

    @Override
    public long seek(long l2) {
        if ((int)l2 < this.backingBuffer.capacity()) {
            this.backingBuffer.limit(this.backingBuffer.capacity());
            this.backingBuffer.position((int)l2);
            return l2;
        }
        return -1L;
    }

    @Override
    public void closeConnection() {
        this.channel = null;
    }
}

