/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jfxmedia.locator;

import com.sun.media.jfxmedia.locator.ConnectionHolder;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;

class ConnectionHolder$FileConnectionHolder
extends ConnectionHolder {
    private RandomAccessFile file = null;

    ConnectionHolder$FileConnectionHolder(URI uRI) {
        this.channel = this.openFile(uRI);
    }

    @Override
    boolean needBuffer() {
        return false;
    }

    @Override
    boolean isRandomAccess() {
        return true;
    }

    @Override
    boolean isSeekable() {
        return true;
    }

    @Override
    public long seek(long l2) {
        try {
            ((FileChannel)this.channel).position(l2);
            return l2;
        }
        catch (IOException iOException) {
            return -1L;
        }
    }

    @Override
    int readBlock(long l2, int n2) {
        if (null == this.channel) {
            throw new ClosedChannelException();
        }
        if (this.buffer.capacity() < n2) {
            this.buffer = ByteBuffer.allocateDirect(n2);
        }
        this.buffer.rewind().limit(n2);
        return ((FileChannel)this.channel).read(this.buffer, l2);
    }

    private ReadableByteChannel openFile(URI uRI) {
        if (this.file != null) {
            this.file.close();
        }
        this.file = new RandomAccessFile(new File(uRI), "r");
        return this.file.getChannel();
    }

    @Override
    public void closeConnection() {
        super.closeConnection();
        if (this.file != null) {
            try {
                this.file.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.file = null;
            }
        }
    }
}

