/*
 * Decompiled with CFR 0.152.
 */
package com.sun.marlin;

import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.marlin.DPathConsumer2D;
import com.sun.marlin.MarlinConst;
import com.sun.marlin.MarlinUtils;
import com.sun.marlin.RendererContext;
import com.sun.marlin.TransformingPathConsumer2D$ClosedPathDetector;
import com.sun.marlin.TransformingPathConsumer2D$DeltaScaleFilter;
import com.sun.marlin.TransformingPathConsumer2D$DeltaTransformFilter;
import com.sun.marlin.TransformingPathConsumer2D$Path2DWrapper;
import com.sun.marlin.TransformingPathConsumer2D$PathClipFilter;
import com.sun.marlin.TransformingPathConsumer2D$PathTracer;
import java.util.Arrays;

public final class TransformingPathConsumer2D {
    static final double CLIP_RECT_PADDING = 0.25;
    private final RendererContext rdrCtx;
    private final TransformingPathConsumer2D$ClosedPathDetector cpDetector;
    private final TransformingPathConsumer2D$PathClipFilter pathClipper;
    private final TransformingPathConsumer2D$Path2DWrapper wp_Path2DWrapper = new TransformingPathConsumer2D$Path2DWrapper();
    private final TransformingPathConsumer2D$DeltaScaleFilter dt_DeltaScaleFilter = new TransformingPathConsumer2D$DeltaScaleFilter();
    private final TransformingPathConsumer2D$DeltaTransformFilter dt_DeltaTransformFilter = new TransformingPathConsumer2D$DeltaTransformFilter();
    private final TransformingPathConsumer2D$DeltaScaleFilter iv_DeltaScaleFilter = new TransformingPathConsumer2D$DeltaScaleFilter();
    private final TransformingPathConsumer2D$DeltaTransformFilter iv_DeltaTransformFilter = new TransformingPathConsumer2D$DeltaTransformFilter();
    private final TransformingPathConsumer2D$PathTracer tracerInput = new TransformingPathConsumer2D$PathTracer("[Input]");
    private final TransformingPathConsumer2D$PathTracer tracerCPDetector = new TransformingPathConsumer2D$PathTracer("ClosedPathDetector");
    private final TransformingPathConsumer2D$PathTracer tracerFiller = new TransformingPathConsumer2D$PathTracer("Filler");
    private final TransformingPathConsumer2D$PathTracer tracerStroker = new TransformingPathConsumer2D$PathTracer("Stroker");
    private final TransformingPathConsumer2D$PathTracer tracerDasher = new TransformingPathConsumer2D$PathTracer("Dasher");

    TransformingPathConsumer2D(RendererContext rendererContext) {
        this.rdrCtx = rendererContext;
        this.cpDetector = new TransformingPathConsumer2D$ClosedPathDetector(rendererContext);
        this.pathClipper = new TransformingPathConsumer2D$PathClipFilter(rendererContext);
    }

    public DPathConsumer2D wrapPath2D(Path2D path2D) {
        return this.wp_Path2DWrapper.init(path2D);
    }

    public DPathConsumer2D traceInput(DPathConsumer2D dPathConsumer2D) {
        return this.tracerInput.init(dPathConsumer2D);
    }

    public DPathConsumer2D traceClosedPathDetector(DPathConsumer2D dPathConsumer2D) {
        return this.tracerCPDetector.init(dPathConsumer2D);
    }

    public DPathConsumer2D traceFiller(DPathConsumer2D dPathConsumer2D) {
        return this.tracerFiller.init(dPathConsumer2D);
    }

    public DPathConsumer2D traceStroker(DPathConsumer2D dPathConsumer2D) {
        return this.tracerStroker.init(dPathConsumer2D);
    }

    public DPathConsumer2D traceDasher(DPathConsumer2D dPathConsumer2D) {
        return this.tracerDasher.init(dPathConsumer2D);
    }

    public DPathConsumer2D detectClosedPath(DPathConsumer2D dPathConsumer2D) {
        return this.cpDetector.init(dPathConsumer2D);
    }

    public DPathConsumer2D pathClipper(DPathConsumer2D dPathConsumer2D) {
        return this.pathClipper.init(dPathConsumer2D);
    }

    public DPathConsumer2D deltaTransformConsumer(DPathConsumer2D dPathConsumer2D, BaseTransform baseTransform) {
        if (baseTransform == null) {
            return dPathConsumer2D;
        }
        double d2 = baseTransform.getMxx();
        double d3 = baseTransform.getMxy();
        double d4 = baseTransform.getMyx();
        double d5 = baseTransform.getMyy();
        if (d3 == 0.0 && d4 == 0.0) {
            if (d2 == 1.0 && d5 == 1.0) {
                return dPathConsumer2D;
            }
            if (this.rdrCtx.doClip) {
                this.rdrCtx.clipInvScale = TransformingPathConsumer2D.adjustClipScale(this.rdrCtx.clipRect, d2, d5);
            }
            return this.dt_DeltaScaleFilter.init(dPathConsumer2D, d2, d5);
        }
        if (this.rdrCtx.doClip) {
            this.rdrCtx.clipInvScale = TransformingPathConsumer2D.adjustClipInverseDelta(this.rdrCtx.clipRect, d2, d3, d4, d5);
        }
        return this.dt_DeltaTransformFilter.init(dPathConsumer2D, d2, d3, d4, d5);
    }

    private static double adjustClipScale(double[] dArray, double d2, double d3) {
        double d4;
        double d5 = 1.0 / d3;
        dArray[0] = dArray[0] * d5;
        dArray[1] = dArray[1] * d5;
        if (dArray[1] < dArray[0]) {
            d4 = dArray[0];
            dArray[0] = dArray[1];
            dArray[1] = d4;
        }
        d4 = 1.0 / d2;
        dArray[2] = dArray[2] * d4;
        dArray[3] = dArray[3] * d4;
        if (dArray[3] < dArray[2]) {
            double d6 = dArray[2];
            dArray[2] = dArray[3];
            dArray[3] = d6;
        }
        if (MarlinConst.DO_LOG_CLIP) {
            MarlinUtils.logInfo("clipRect (ClipScale): " + Arrays.toString(dArray));
        }
        return 0.5 * (Math.abs(d4) + Math.abs(d5));
    }

    private static double adjustClipInverseDelta(double[] dArray, double d2, double d3, double d4, double d5) {
        double d6;
        double d7;
        double d8 = d2 * d5 - d3 * d4;
        double d9 = d5 / d8;
        double d10 = -d3 / d8;
        double d11 = -d4 / d8;
        double d12 = d2 / d8;
        double d13 = dArray[2] * d9 + dArray[0] * d10;
        double d14 = dArray[2] * d11 + dArray[0] * d12;
        double d15 = d7 = d13;
        double d16 = d6 = d14;
        d13 = dArray[3] * d9 + dArray[0] * d10;
        d14 = dArray[3] * d11 + dArray[0] * d12;
        if (d13 < d15) {
            d15 = d13;
        } else if (d13 > d7) {
            d7 = d13;
        }
        if (d14 < d16) {
            d16 = d14;
        } else if (d14 > d6) {
            d6 = d14;
        }
        d13 = dArray[2] * d9 + dArray[1] * d10;
        d14 = dArray[2] * d11 + dArray[1] * d12;
        if (d13 < d15) {
            d15 = d13;
        } else if (d13 > d7) {
            d7 = d13;
        }
        if (d14 < d16) {
            d16 = d14;
        } else if (d14 > d6) {
            d6 = d14;
        }
        d13 = dArray[3] * d9 + dArray[1] * d10;
        d14 = dArray[3] * d11 + dArray[1] * d12;
        if (d13 < d15) {
            d15 = d13;
        } else if (d13 > d7) {
            d7 = d13;
        }
        if (d14 < d16) {
            d16 = d14;
        } else if (d14 > d6) {
            d6 = d14;
        }
        dArray[0] = d16;
        dArray[1] = d6;
        dArray[2] = d15;
        dArray[3] = d7;
        if (MarlinConst.DO_LOG_CLIP) {
            MarlinUtils.logInfo("clipRect (ClipInverseDelta): " + Arrays.toString(dArray));
        }
        double d17 = Math.sqrt(d9 * d9 + d10 * d10);
        double d18 = Math.sqrt(d11 * d11 + d12 * d12);
        return 0.5 * (d17 + d18);
    }

    public DPathConsumer2D inverseDeltaTransformConsumer(DPathConsumer2D dPathConsumer2D, BaseTransform baseTransform) {
        if (baseTransform == null) {
            return dPathConsumer2D;
        }
        double d2 = baseTransform.getMxx();
        double d3 = baseTransform.getMxy();
        double d4 = baseTransform.getMyx();
        double d5 = baseTransform.getMyy();
        if (d3 == 0.0 && d4 == 0.0) {
            if (d2 == 1.0 && d5 == 1.0) {
                return dPathConsumer2D;
            }
            return this.iv_DeltaScaleFilter.init(dPathConsumer2D, 1.0 / d2, 1.0 / d5);
        }
        double d6 = d2 * d5 - d3 * d4;
        return this.iv_DeltaTransformFilter.init(dPathConsumer2D, d5 / d6, -d3 / d6, -d4 / d6, d2 / d6);
    }
}

