/*
 * Decompiled with CFR 0.152.
 */
package com.sun.marlin;

import com.sun.marlin.DPathConsumer2D;
import com.sun.marlin.Helpers;
import com.sun.marlin.Helpers$IndexStack;
import com.sun.marlin.MarlinConst;
import com.sun.marlin.RendererContext;
import com.sun.marlin.TransformingPathConsumer2D$CurveClipSplitter;

final class TransformingPathConsumer2D$PathClipFilter
implements DPathConsumer2D {
    private DPathConsumer2D out;
    private final double[] clipRect;
    private final double[] corners = new double[8];
    private boolean init_corners = false;
    private final Helpers$IndexStack stack;
    private int cOutCode = 0;
    private int gOutCode = 15;
    private boolean outside = false;
    private double sx0;
    private double sy0;
    private double cx0;
    private double cy0;
    private double cox0;
    private double coy0;
    private boolean subdivide = MarlinConst.DO_CLIP_SUBDIVIDER;
    private final TransformingPathConsumer2D$CurveClipSplitter curveSplitter;

    TransformingPathConsumer2D$PathClipFilter(RendererContext rendererContext) {
        this.clipRect = rendererContext.clipRect;
        this.curveSplitter = rendererContext.curveClipSplitter;
        this.stack = rendererContext.stats != null ? new Helpers$IndexStack(rendererContext, rendererContext.stats.stat_pcf_idxstack_indices, rendererContext.stats.hist_pcf_idxstack_indices, rendererContext.stats.stat_array_pcf_idxstack_indices) : new Helpers$IndexStack(rendererContext);
    }

    TransformingPathConsumer2D$PathClipFilter init(DPathConsumer2D dPathConsumer2D) {
        this.out = dPathConsumer2D;
        if (MarlinConst.DO_CLIP_SUBDIVIDER) {
            this.curveSplitter.init();
        }
        this.init_corners = true;
        this.gOutCode = 15;
        return this;
    }

    void dispose() {
        this.stack.dispose();
    }

    private void finishPath() {
        if (this.outside) {
            if (this.gOutCode == 0) {
                this.finish();
            } else {
                this.outside = false;
                this.stack.reset();
            }
        }
    }

    private void finish() {
        this.outside = false;
        if (!this.stack.isEmpty()) {
            if (this.init_corners) {
                this.init_corners = false;
                double[] dArray = this.corners;
                double[] dArray2 = this.clipRect;
                dArray[0] = dArray2[2];
                dArray[1] = dArray2[0];
                dArray[2] = dArray2[2];
                dArray[3] = dArray2[1];
                dArray[4] = dArray2[3];
                dArray[5] = dArray2[0];
                dArray[6] = dArray2[3];
                dArray[7] = dArray2[1];
            }
            this.stack.pullAll(this.corners, this.out);
        }
        this.out.lineTo(this.cox0, this.coy0);
        this.cx0 = this.cox0;
        this.cy0 = this.coy0;
    }

    @Override
    public void pathDone() {
        this.finishPath();
        this.out.pathDone();
        this.dispose();
    }

    @Override
    public void closePath() {
        this.finishPath();
        this.out.closePath();
        this.cOutCode = Helpers.outcode(this.sx0, this.sy0, this.clipRect);
        this.cx0 = this.sx0;
        this.cy0 = this.sy0;
    }

    @Override
    public void moveTo(double d2, double d3) {
        this.finishPath();
        this.out.moveTo(d2, d3);
        this.cOutCode = Helpers.outcode(d2, d3, this.clipRect);
        this.cx0 = d2;
        this.cy0 = d3;
        this.sx0 = d2;
        this.sy0 = d3;
    }

    @Override
    public void lineTo(double d2, double d3) {
        int n2 = this.cOutCode;
        int n3 = Helpers.outcode(d2, d3, this.clipRect);
        int n4 = n2 | n3;
        if (n4 != 0) {
            int n5 = n2 & n3;
            if (n5 == 0) {
                if (this.subdivide) {
                    this.subdivide = false;
                    boolean bl2 = this.outside ? this.curveSplitter.splitLine(this.cox0, this.coy0, d2, d3, n4, this) : this.curveSplitter.splitLine(this.cx0, this.cy0, d2, d3, n4, this);
                    this.subdivide = true;
                    if (bl2) {
                        return;
                    }
                }
            } else {
                this.cOutCode = n3;
                this.gOutCode &= n5;
                this.outside = true;
                this.cox0 = d2;
                this.coy0 = d3;
                this.clip(n5, n2, n3);
                return;
            }
        }
        this.cOutCode = n3;
        this.gOutCode = 0;
        if (this.outside) {
            this.finish();
        }
        this.out.lineTo(d2, d3);
        this.cx0 = d2;
        this.cy0 = d3;
    }

    private void clip(int n2, int n3, int n4) {
        if (n3 != n4 && (n2 & 0xC) != 0) {
            int n5 = n3 | n4;
            int n6 = n5 & 3;
            int n7 = n5 & 0xC;
            int n8 = n7 == 4 ? 0 : 2;
            switch (n6) {
                case 1: {
                    this.stack.push(n8);
                    return;
                }
                case 2: {
                    this.stack.push(n8 + 1);
                    return;
                }
            }
            if ((n3 & 1) != 0) {
                this.stack.push(n8);
                this.stack.push(n8 + 1);
            } else {
                this.stack.push(n8 + 1);
                this.stack.push(n8);
            }
        }
    }

    @Override
    public void curveTo(double d2, double d3, double d4, double d5, double d6, double d7) {
        int n2;
        int n3;
        int n4 = this.cOutCode;
        int n5 = Helpers.outcode(d2, d3, this.clipRect);
        int n6 = n4 | n5 | (n3 = Helpers.outcode(d4, d5, this.clipRect)) | (n2 = Helpers.outcode(d6, d7, this.clipRect));
        if (n6 != 0) {
            int n7 = n4 & n5 & n3 & n2;
            if (n7 == 0) {
                if (this.subdivide) {
                    this.subdivide = false;
                    boolean bl2 = this.outside ? this.curveSplitter.splitCurve(this.cox0, this.coy0, d2, d3, d4, d5, d6, d7, n6, this) : this.curveSplitter.splitCurve(this.cx0, this.cy0, d2, d3, d4, d5, d6, d7, n6, this);
                    this.subdivide = true;
                    if (bl2) {
                        return;
                    }
                }
            } else {
                this.cOutCode = n2;
                this.gOutCode &= n7;
                this.outside = true;
                this.cox0 = d6;
                this.coy0 = d7;
                this.clip(n7, n4, n2);
                return;
            }
        }
        this.cOutCode = n2;
        this.gOutCode = 0;
        if (this.outside) {
            this.finish();
        }
        this.out.curveTo(d2, d3, d4, d5, d6, d7);
        this.cx0 = d6;
        this.cy0 = d7;
    }

    @Override
    public void quadTo(double d2, double d3, double d4, double d5) {
        int n2;
        int n3 = this.cOutCode;
        int n4 = Helpers.outcode(d2, d3, this.clipRect);
        int n5 = n3 | n4 | (n2 = Helpers.outcode(d4, d5, this.clipRect));
        if (n5 != 0) {
            int n6 = n3 & n4 & n2;
            if (n6 == 0) {
                if (this.subdivide) {
                    this.subdivide = false;
                    boolean bl2 = this.outside ? this.curveSplitter.splitQuad(this.cox0, this.coy0, d2, d3, d4, d5, n5, this) : this.curveSplitter.splitQuad(this.cx0, this.cy0, d2, d3, d4, d5, n5, this);
                    this.subdivide = true;
                    if (bl2) {
                        return;
                    }
                }
            } else {
                this.cOutCode = n2;
                this.gOutCode &= n6;
                this.outside = true;
                this.cox0 = d4;
                this.coy0 = d5;
                this.clip(n6, n3, n2);
                return;
            }
        }
        this.cOutCode = n2;
        this.gOutCode = 0;
        if (this.outside) {
            this.finish();
        }
        this.out.quadTo(d2, d3, d4, d5);
        this.cx0 = d4;
        this.cy0 = d5;
    }
}

