/*
 * Decompiled with CFR 0.152.
 */
package com.sun.marlin;

import com.sun.marlin.Curve;
import com.sun.marlin.DPathConsumer2D;
import com.sun.marlin.Helpers;
import com.sun.marlin.MarlinConst;
import com.sun.marlin.MarlinProperties;
import com.sun.marlin.MarlinUtils;
import com.sun.marlin.RendererContext;

final class TransformingPathConsumer2D$CurveClipSplitter {
    static final double LEN_TH = MarlinProperties.getSubdividerMinLength();
    static final boolean DO_CHECK_LENGTH = LEN_TH > 0.0;
    private static final boolean TRACE = false;
    private static final int MAX_N_CURVES = 12;
    private final RendererContext rdrCtx;
    private double minLength;
    final double[] clipRect;
    final double[] clipRectPad = new double[4];
    private boolean init_clipRectPad = false;
    final double[] middle = new double[98];
    private final double[] subdivTs = new double[12];
    private final Curve curve;

    TransformingPathConsumer2D$CurveClipSplitter(RendererContext rendererContext) {
        this.rdrCtx = rendererContext;
        this.clipRect = rendererContext.clipRect;
        this.curve = rendererContext.curve;
    }

    void init() {
        this.init_clipRectPad = true;
        if (DO_CHECK_LENGTH) {
            double d2 = this.minLength = this.rdrCtx.clipInvScale == 0.0 ? LEN_TH : LEN_TH * this.rdrCtx.clipInvScale;
            if (MarlinConst.DO_LOG_CLIP) {
                MarlinUtils.logInfo("CurveClipSplitter.minLength = " + this.minLength);
            }
        }
    }

    private void initPaddedClip() {
        double[] dArray = this.clipRect;
        double[] dArray2 = this.clipRectPad;
        dArray2[0] = dArray[0] - 0.25;
        dArray2[1] = dArray[1] + 0.25;
        dArray2[2] = dArray[2] - 0.25;
        dArray2[3] = dArray[3] + 0.25;
    }

    boolean splitLine(double d2, double d3, double d4, double d5, int n2, DPathConsumer2D dPathConsumer2D) {
        if (DO_CHECK_LENGTH && Helpers.fastLineLen(d2, d3, d4, d5) <= this.minLength) {
            return false;
        }
        double[] dArray = this.middle;
        dArray[0] = d2;
        dArray[1] = d3;
        dArray[2] = d4;
        dArray[3] = d5;
        return this.subdivideAtIntersections(4, n2, dPathConsumer2D);
    }

    boolean splitQuad(double d2, double d3, double d4, double d5, double d6, double d7, int n2, DPathConsumer2D dPathConsumer2D) {
        if (DO_CHECK_LENGTH && Helpers.fastQuadLen(d2, d3, d4, d5, d6, d7) <= this.minLength) {
            return false;
        }
        double[] dArray = this.middle;
        dArray[0] = d2;
        dArray[1] = d3;
        dArray[2] = d4;
        dArray[3] = d5;
        dArray[4] = d6;
        dArray[5] = d7;
        return this.subdivideAtIntersections(6, n2, dPathConsumer2D);
    }

    boolean splitCurve(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, int n2, DPathConsumer2D dPathConsumer2D) {
        if (DO_CHECK_LENGTH && Helpers.fastCurvelen(d2, d3, d4, d5, d6, d7, d8, d9) <= this.minLength) {
            return false;
        }
        double[] dArray = this.middle;
        dArray[0] = d2;
        dArray[1] = d3;
        dArray[2] = d4;
        dArray[3] = d5;
        dArray[4] = d6;
        dArray[5] = d7;
        dArray[6] = d8;
        dArray[7] = d9;
        return this.subdivideAtIntersections(8, n2, dPathConsumer2D);
    }

    private boolean subdivideAtIntersections(int n2, int n3, DPathConsumer2D dPathConsumer2D) {
        int n4;
        double[] dArray = this.middle;
        double[] dArray2 = this.subdivTs;
        if (this.init_clipRectPad) {
            this.init_clipRectPad = false;
            this.initPaddedClip();
        }
        if ((n4 = Helpers.findClipPoints(this.curve, dArray, dArray2, n2, n3, this.clipRectPad)) == 0) {
            return false;
        }
        double d2 = 0.0;
        int n5 = 0;
        int n6 = 0;
        while (n5 < n4) {
            double d3 = dArray2[n5];
            Helpers.subdivideAt((d3 - d2) / (1.0 - d2), dArray, n6, dArray, n6, n2);
            d2 = d3;
            ++n5;
            n6 += n2;
        }
        n5 = 0;
        n6 = 0;
        while (n5 <= n4) {
            TransformingPathConsumer2D$CurveClipSplitter.emitCurrent(n2, dArray, n6, dPathConsumer2D);
            ++n5;
            n6 += n2;
        }
        return true;
    }

    static void emitCurrent(int n2, double[] dArray, int n3, DPathConsumer2D dPathConsumer2D) {
        if (n2 == 8) {
            dPathConsumer2D.curveTo(dArray[n3 + 2], dArray[n3 + 3], dArray[n3 + 4], dArray[n3 + 5], dArray[n3 + 6], dArray[n3 + 7]);
        } else if (n2 == 4) {
            dPathConsumer2D.lineTo(dArray[n3 + 2], dArray[n3 + 3]);
        } else {
            dPathConsumer2D.quadTo(dArray[n3 + 2], dArray[n3 + 3], dArray[n3 + 4], dArray[n3 + 5]);
        }
    }
}

