/*
 * Decompiled with CFR 0.152.
 */
package com.sun.marlin;

import com.sun.marlin.Curve;
import com.sun.marlin.DPathConsumer2D;
import com.sun.marlin.Helpers;
import com.sun.marlin.Helpers$PolyStack;
import com.sun.marlin.MarlinConst;
import com.sun.marlin.MarlinUtils;
import com.sun.marlin.RendererContext;
import com.sun.marlin.TransformingPathConsumer2D$CurveBasicMonotonizer;
import com.sun.marlin.TransformingPathConsumer2D$CurveClipSplitter;
import java.util.Arrays;

public final class Stroker
implements DPathConsumer2D,
MarlinConst {
    private static final int MOVE_TO = 0;
    private static final int DRAWING_OP_TO = 1;
    private static final int CLOSE = 2;
    private static final double ERR_JOIN = 1.0f / MIN_SUBPIXELS;
    private static final double ROUND_JOIN_THRESHOLD = ERR_JOIN * ERR_JOIN;
    private static final double C = 4.0 * (Math.sqrt(2.0) - 1.0) / 3.0;
    private static final double SQRT_2 = Math.sqrt(2.0);
    private DPathConsumer2D out;
    private int capStyle;
    private int joinStyle;
    private double lineWidth2;
    private double invHalfLineWidth2Sq;
    private final double[] offset0 = new double[2];
    private final double[] offset1 = new double[2];
    private final double[] offset2 = new double[2];
    private final double[] miter = new double[2];
    private double miterLimitSq;
    private int prev;
    private double sx0;
    private double sy0;
    private double sdx;
    private double sdy;
    private double cx0;
    private double cy0;
    private double cdx;
    private double cdy;
    private double smx;
    private double smy;
    private double cmx;
    private double cmy;
    private final Helpers$PolyStack reverse;
    private final double[] lp = new double[8];
    private final double[] rp = new double[8];
    final RendererContext rdrCtx;
    final Curve curve;
    private double[] clipRect;
    private int cOutCode = 0;
    private int sOutCode = 0;
    private boolean opened = false;
    private boolean capStart = false;
    private boolean monotonize;
    private boolean subdivide = false;
    private final TransformingPathConsumer2D$CurveClipSplitter curveSplitter;

    Stroker(RendererContext rendererContext) {
        this.rdrCtx = rendererContext;
        this.reverse = rendererContext.stats != null ? new Helpers$PolyStack(rendererContext, rendererContext.stats.stat_str_polystack_types, rendererContext.stats.stat_str_polystack_curves, rendererContext.stats.hist_str_polystack_curves, rendererContext.stats.stat_array_str_polystack_curves, rendererContext.stats.stat_array_str_polystack_types) : new Helpers$PolyStack(rendererContext);
        this.curve = rendererContext.curve;
        this.curveSplitter = rendererContext.curveClipSplitter;
    }

    public Stroker init(DPathConsumer2D dPathConsumer2D, double d2, int n2, int n3, double d3, boolean bl2) {
        this.out = dPathConsumer2D;
        this.lineWidth2 = d2 / 2.0;
        this.invHalfLineWidth2Sq = 1.0 / (2.0 * this.lineWidth2 * this.lineWidth2);
        this.monotonize = bl2;
        this.capStyle = n2;
        this.joinStyle = n3;
        double d4 = d3 * this.lineWidth2;
        this.miterLimitSq = d4 * d4;
        this.prev = 2;
        this.rdrCtx.stroking = 1;
        if (this.rdrCtx.doClip) {
            double d5 = this.lineWidth2;
            if (n2 == 2) {
                d5 *= SQRT_2;
            }
            if (n3 == 0 && d5 < d4) {
                d5 = d4;
            }
            double[] dArray = this.rdrCtx.clipRect;
            dArray[0] = dArray[0] - d5;
            dArray[1] = dArray[1] + d5;
            dArray[2] = dArray[2] - d5;
            dArray[3] = dArray[3] + d5;
            this.clipRect = dArray;
            if (MarlinConst.DO_LOG_CLIP) {
                MarlinUtils.logInfo("clipRect (stroker): " + Arrays.toString(this.rdrCtx.clipRect));
            }
            if (DO_CLIP_SUBDIVIDER) {
                this.subdivide = bl2;
                this.curveSplitter.init();
            } else {
                this.subdivide = false;
            }
        } else {
            this.clipRect = null;
            this.cOutCode = 0;
            this.sOutCode = 0;
        }
        return this;
    }

    public void disableClipping() {
        this.clipRect = null;
        this.cOutCode = 0;
        this.sOutCode = 0;
    }

    void dispose() {
        this.reverse.dispose();
        this.opened = false;
        this.capStart = false;
    }

    private static void computeOffset(double d2, double d3, double d4, double[] dArray) {
        double d5 = d2 * d2 + d3 * d3;
        if (d5 == 0.0) {
            dArray[0] = 0.0;
            dArray[1] = 0.0;
        } else {
            d5 = Math.sqrt(d5);
            dArray[0] = d3 * d4 / d5;
            dArray[1] = -(d2 * d4) / d5;
        }
    }

    private static boolean isCW(double d2, double d3, double d4, double d5) {
        return d2 * d5 <= d3 * d4;
    }

    private void mayDrawRoundJoin(double d2, double d3, double d4, double d5, double d6, double d7, boolean bl2) {
        if (d4 == 0.0 && d5 == 0.0 || d6 == 0.0 && d7 == 0.0) {
            return;
        }
        double d8 = d4 - d6;
        double d9 = d5 - d7;
        double d10 = d8 * d8 + d9 * d9;
        if (d10 < ROUND_JOIN_THRESHOLD) {
            return;
        }
        if (bl2) {
            d4 = -d4;
            d5 = -d5;
            d6 = -d6;
            d7 = -d7;
        }
        this.drawRoundJoin(d2, d3, d4, d5, d6, d7, bl2);
    }

    private void drawRoundJoin(double d2, double d3, double d4, double d5, double d6, double d7, boolean bl2) {
        double d8 = d4 * d6 + d5 * d7;
        if (d8 >= 0.0) {
            this.drawBezApproxForArc(d2, d3, d4, d5, d6, d7, bl2);
        } else {
            double d9 = d7 - d5;
            double d10 = d4 - d6;
            double d11 = Math.sqrt(d9 * d9 + d10 * d10);
            double d12 = this.lineWidth2 / d11;
            double d13 = d9 * d12;
            double d14 = d10 * d12;
            if (bl2) {
                d13 = -d13;
                d14 = -d14;
            }
            this.drawBezApproxForArc(d2, d3, d4, d5, d13, d14, bl2);
            this.drawBezApproxForArc(d2, d3, d13, d14, d6, d7, bl2);
        }
    }

    private void drawBezApproxForArc(double d2, double d3, double d4, double d5, double d6, double d7, boolean bl2) {
        double d8 = (d4 * d6 + d5 * d7) * this.invHalfLineWidth2Sq;
        if (d8 >= 0.5) {
            return;
        }
        double d9 = 1.3333333333333333 * Math.sqrt(0.5 - d8) / (1.0 + Math.sqrt(d8 + 0.5));
        if (bl2) {
            d9 = -d9;
        }
        double d10 = d2 + d4;
        double d11 = d3 + d5;
        double d12 = d10 - d9 * d5;
        double d13 = d11 + d9 * d4;
        double d14 = d2 + d6;
        double d15 = d3 + d7;
        double d16 = d14 + d9 * d7;
        double d17 = d15 - d9 * d6;
        this.emitCurveTo(d10, d11, d12, d13, d16, d17, d14, d15, bl2);
    }

    private void drawRoundCap(double d2, double d3, double d4, double d5) {
        double d6 = C * d4;
        double d7 = C * d5;
        this.emitCurveTo(d2 + d4 - d7, d3 + d5 + d6, d2 - d5 + d6, d3 + d4 + d7, d2 - d5, d3 + d4);
        this.emitCurveTo(d2 - d5 - d6, d3 + d4 - d7, d2 - d4 - d7, d3 - d5 + d6, d2 - d4, d3 - d5);
    }

    private static void computeMiter(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double[] dArray) {
        double d10 = d4 - d2;
        double d11 = d5 - d3;
        double d12 = d8 - d6;
        double d13 = d9 - d7;
        double d14 = d10 * d13 - d12 * d11;
        double d15 = d12 * (d3 - d7) - d13 * (d2 - d6);
        dArray[0] = d2 + (d15 /= d14) * d10;
        dArray[1] = d3 + d15 * d11;
    }

    private static void safeComputeMiter(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double[] dArray) {
        double d10 = d4 - d2;
        double d11 = d9 - d7;
        double d12 = d8 - d6;
        double d13 = d5 - d3;
        double d14 = d10 * d11 - d12 * d13;
        if (d14 == 0.0) {
            dArray[2] = (d2 + d6) / 2.0;
            dArray[3] = (d3 + d7) / 2.0;
        } else {
            double d15 = d12 * (d3 - d7) - d11 * (d2 - d6);
            dArray[2] = d2 + (d15 /= d14) * d10;
            dArray[3] = d3 + d15 * d13;
        }
    }

    private void drawMiter(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, boolean bl2) {
        if (d10 == d8 && d11 == d9 || d2 == 0.0 && d3 == 0.0 || d6 == 0.0 && d7 == 0.0) {
            return;
        }
        if (bl2) {
            d8 = -d8;
            d9 = -d9;
            d10 = -d10;
            d11 = -d11;
        }
        Stroker.computeMiter(d4 - d2 + d8, d5 - d3 + d9, d4 + d8, d5 + d9, d6 + d4 + d10, d7 + d5 + d11, d4 + d10, d5 + d11, this.miter);
        double d12 = this.miter[0];
        double d13 = this.miter[1];
        double d14 = (d12 - d4) * (d12 - d4) + (d13 - d5) * (d13 - d5);
        if (d14 < this.miterLimitSq) {
            this.emitLineTo(d12, d13, bl2);
        }
    }

    @Override
    public void moveTo(double d2, double d3) {
        this._moveTo(d2, d3, this.cOutCode);
        this.sx0 = d2;
        this.sy0 = d3;
        this.sdx = 1.0;
        this.sdy = 0.0;
        this.opened = false;
        this.capStart = false;
        if (this.clipRect != null) {
            int n2;
            this.cOutCode = n2 = Helpers.outcode(d2, d3, this.clipRect);
            this.sOutCode = n2;
        }
    }

    private void _moveTo(double d2, double d3, int n2) {
        if (this.prev == 0) {
            this.cx0 = d2;
            this.cy0 = d3;
        } else {
            if (this.prev == 1) {
                this.finish(n2);
            }
            this.prev = 0;
            this.cx0 = d2;
            this.cy0 = d3;
            this.cdx = 1.0;
            this.cdy = 0.0;
        }
    }

    @Override
    public void lineTo(double d2, double d3) {
        this.lineTo(d2, d3, false);
    }

    private void lineTo(double d2, double d3, boolean bl2) {
        int n2 = this.cOutCode;
        if (!bl2 && this.clipRect != null) {
            int n3 = Helpers.outcode(d2, d3, this.clipRect);
            int n4 = n2 | n3;
            if (n4 != 0) {
                int n5 = n2 & n3;
                if (n5 == 0) {
                    if (this.subdivide) {
                        this.subdivide = false;
                        boolean bl3 = this.curveSplitter.splitLine(this.cx0, this.cy0, d2, d3, n4, this);
                        this.subdivide = true;
                        if (bl3) {
                            return;
                        }
                    }
                } else {
                    this.cOutCode = n3;
                    this._moveTo(d2, d3, n2);
                    this.opened = true;
                    return;
                }
            }
            this.cOutCode = n3;
        }
        double d4 = d2 - this.cx0;
        double d5 = d3 - this.cy0;
        if (d4 == 0.0 && d5 == 0.0) {
            d4 = 1.0;
        }
        Stroker.computeOffset(d4, d5, this.lineWidth2, this.offset0);
        double d6 = this.offset0[0];
        double d7 = this.offset0[1];
        this.drawJoin(this.cdx, this.cdy, this.cx0, this.cy0, d4, d5, this.cmx, this.cmy, d6, d7, n2);
        this.emitLineTo(this.cx0 + d6, this.cy0 + d7);
        this.emitLineTo(d2 + d6, d3 + d7);
        this.emitLineToRev(this.cx0 - d6, this.cy0 - d7);
        this.emitLineToRev(d2 - d6, d3 - d7);
        this.prev = 1;
        this.cx0 = d2;
        this.cy0 = d3;
        this.cdx = d4;
        this.cdy = d5;
        this.cmx = d6;
        this.cmy = d7;
    }

    @Override
    public void closePath() {
        if (this.prev != 1 && !this.opened) {
            if (this.prev == 2) {
                return;
            }
            this.emitMoveTo(this.cx0, this.cy0 - this.lineWidth2);
            this.sdx = 1.0;
            this.sdy = 0.0;
            this.cdx = 1.0;
            this.cdy = 0.0;
            this.smx = 0.0;
            this.smy = -this.lineWidth2;
            this.cmx = 0.0;
            this.cmy = -this.lineWidth2;
            this.finish(this.cOutCode);
            return;
        }
        if ((this.sOutCode & this.cOutCode) == 0) {
            if (this.cx0 != this.sx0 || this.cy0 != this.sy0) {
                this.lineTo(this.sx0, this.sy0, true);
            }
            this.drawJoin(this.cdx, this.cdy, this.cx0, this.cy0, this.sdx, this.sdy, this.cmx, this.cmy, this.smx, this.smy, this.sOutCode);
            this.emitLineTo(this.sx0 + this.smx, this.sy0 + this.smy);
            if (this.opened) {
                this.emitLineTo(this.sx0 - this.smx, this.sy0 - this.smy);
            } else {
                this.emitMoveTo(this.sx0 - this.smx, this.sy0 - this.smy);
            }
        }
        this.emitReverse();
        this.prev = 2;
        this.cx0 = this.sx0;
        this.cy0 = this.sy0;
        this.cOutCode = this.sOutCode;
        if (this.opened) {
            this.opened = false;
        } else {
            this.emitClose();
        }
    }

    private void emitReverse() {
        this.reverse.popAll(this.out);
    }

    @Override
    public void pathDone() {
        if (this.prev == 1) {
            this.finish(this.cOutCode);
        }
        this.out.pathDone();
        this.prev = 2;
        this.dispose();
    }

    private void finish(int n2) {
        if (this.rdrCtx.closedPath) {
            this.emitReverse();
        } else {
            if (n2 == 0) {
                if (this.capStyle == 1) {
                    this.drawRoundCap(this.cx0, this.cy0, this.cmx, this.cmy);
                } else if (this.capStyle == 2) {
                    this.emitLineTo(this.cx0 - this.cmy + this.cmx, this.cy0 + this.cmx + this.cmy);
                    this.emitLineTo(this.cx0 - this.cmy - this.cmx, this.cy0 + this.cmx - this.cmy);
                }
            }
            this.emitReverse();
            if (!this.capStart) {
                this.capStart = true;
                if (this.sOutCode == 0) {
                    if (this.capStyle == 1) {
                        this.drawRoundCap(this.sx0, this.sy0, -this.smx, -this.smy);
                    } else if (this.capStyle == 2) {
                        this.emitLineTo(this.sx0 + this.smy - this.smx, this.sy0 - this.smx - this.smy);
                        this.emitLineTo(this.sx0 + this.smy + this.smx, this.sy0 - this.smx + this.smy);
                    }
                }
            }
        }
        this.emitClose();
    }

    private void emitMoveTo(double d2, double d3) {
        this.out.moveTo(d2, d3);
    }

    private void emitLineTo(double d2, double d3) {
        this.out.lineTo(d2, d3);
    }

    private void emitLineToRev(double d2, double d3) {
        this.reverse.pushLine(d2, d3);
    }

    private void emitLineTo(double d2, double d3, boolean bl2) {
        if (bl2) {
            this.emitLineToRev(d2, d3);
        } else {
            this.emitLineTo(d2, d3);
        }
    }

    private void emitQuadTo(double d2, double d3, double d4, double d5) {
        this.out.quadTo(d2, d3, d4, d5);
    }

    private void emitQuadToRev(double d2, double d3, double d4, double d5) {
        this.reverse.pushQuad(d2, d3, d4, d5);
    }

    private void emitCurveTo(double d2, double d3, double d4, double d5, double d6, double d7) {
        this.out.curveTo(d2, d3, d4, d5, d6, d7);
    }

    private void emitCurveToRev(double d2, double d3, double d4, double d5, double d6, double d7) {
        this.reverse.pushCubic(d2, d3, d4, d5, d6, d7);
    }

    private void emitCurveTo(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, boolean bl2) {
        if (bl2) {
            this.reverse.pushCubic(d2, d3, d4, d5, d6, d7);
        } else {
            this.out.curveTo(d4, d5, d6, d7, d8, d9);
        }
    }

    private void emitClose() {
        this.out.closePath();
    }

    private void drawJoin(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, int n2) {
        if (this.prev != 1) {
            this.emitMoveTo(d4 + d10, d5 + d11);
            if (!this.opened) {
                this.sdx = d6;
                this.sdy = d7;
                this.smx = d10;
                this.smy = d11;
            }
        } else {
            boolean bl2 = Stroker.isCW(d2, d3, d6, d7);
            if (n2 == 0) {
                if (this.joinStyle == 0) {
                    this.drawMiter(d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, bl2);
                } else if (this.joinStyle == 1) {
                    this.mayDrawRoundJoin(d4, d5, d8, d9, d10, d11, bl2);
                }
            }
            this.emitLineTo(d4, d5, !bl2);
        }
        this.prev = 1;
    }

    private static boolean within(double d2, double d3, double d4, double d5, double d6) {
        assert (d6 > 0.0) : "";
        return Helpers.within(d2, d4, d6) && Helpers.within(d3, d5, d6);
    }

    private void getLineOffsets(double d2, double d3, double d4, double d5, double[] dArray, double[] dArray2) {
        Stroker.computeOffset(d4 - d2, d5 - d3, this.lineWidth2, this.offset0);
        double d6 = this.offset0[0];
        double d7 = this.offset0[1];
        dArray[0] = d2 + d6;
        dArray[1] = d3 + d7;
        dArray[2] = d4 + d6;
        dArray[3] = d5 + d7;
        dArray2[0] = d2 - d6;
        dArray2[1] = d3 - d7;
        dArray2[2] = d4 - d6;
        dArray2[3] = d5 - d7;
    }

    private int computeOffsetCubic(double[] dArray, int n2, double[] dArray2, double[] dArray3) {
        double d2 = dArray[n2];
        double d3 = dArray[n2 + 1];
        double d4 = dArray[n2 + 2];
        double d5 = dArray[n2 + 3];
        double d6 = dArray[n2 + 4];
        double d7 = dArray[n2 + 5];
        double d8 = dArray[n2 + 6];
        double d9 = dArray[n2 + 7];
        double d10 = d8 - d6;
        double d11 = d9 - d7;
        double d12 = d4 - d2;
        double d13 = d5 - d3;
        boolean bl2 = Stroker.within(d2, d3, d4, d5, 6.0 * Math.ulp(d5));
        boolean bl3 = Stroker.within(d6, d7, d8, d9, 6.0 * Math.ulp(d9));
        if (bl2 && bl3) {
            this.getLineOffsets(d2, d3, d8, d9, dArray2, dArray3);
            return 4;
        }
        if (bl2) {
            d12 = d6 - d2;
            d13 = d7 - d3;
        } else if (bl3) {
            d10 = d8 - d4;
            d11 = d9 - d5;
        }
        double d14 = d12 * d10 + d13 * d11;
        d14 *= d14;
        double d15 = d12 * d12 + d13 * d13;
        double d16 = d10 * d10 + d11 * d11;
        if (Helpers.within(d14, d15 * d16, 4.0 * Math.ulp(d14))) {
            this.getLineOffsets(d2, d3, d8, d9, dArray2, dArray3);
            return 4;
        }
        double d17 = (d2 + 3.0 * (d4 + d6) + d8) / 8.0;
        double d18 = (d3 + 3.0 * (d5 + d7) + d9) / 8.0;
        double d19 = d6 + d8 - d2 - d4;
        double d20 = d7 + d9 - d3 - d5;
        Stroker.computeOffset(d12, d13, this.lineWidth2, this.offset0);
        Stroker.computeOffset(d19, d20, this.lineWidth2, this.offset1);
        Stroker.computeOffset(d10, d11, this.lineWidth2, this.offset2);
        double d21 = d2 + this.offset0[0];
        double d22 = d3 + this.offset0[1];
        double d23 = d17 + this.offset1[0];
        double d24 = d18 + this.offset1[1];
        double d25 = d8 + this.offset2[0];
        double d26 = d9 + this.offset2[1];
        double d27 = 4.0 / (3.0 * (d12 * d11 - d13 * d10));
        double d28 = 2.0 * d23 - d21 - d25;
        double d29 = 2.0 * d24 - d22 - d26;
        double d30 = d27 * (d11 * d28 - d10 * d29);
        double d31 = d27 * (d12 * d29 - d13 * d28);
        double d32 = d21 + d30 * d12;
        double d33 = d22 + d30 * d13;
        double d34 = d25 + d31 * d10;
        double d35 = d26 + d31 * d11;
        dArray2[0] = d21;
        dArray2[1] = d22;
        dArray2[2] = d32;
        dArray2[3] = d33;
        dArray2[4] = d34;
        dArray2[5] = d35;
        dArray2[6] = d25;
        dArray2[7] = d26;
        d21 = d2 - this.offset0[0];
        d22 = d3 - this.offset0[1];
        d25 = d8 - this.offset2[0];
        d26 = d9 - this.offset2[1];
        d28 = 2.0 * (d23 -= 2.0 * this.offset1[0]) - d21 - d25;
        d29 = 2.0 * (d24 -= 2.0 * this.offset1[1]) - d22 - d26;
        d30 = d27 * (d11 * d28 - d10 * d29);
        d31 = d27 * (d12 * d29 - d13 * d28);
        d32 = d21 + d30 * d12;
        d33 = d22 + d30 * d13;
        d34 = d25 + d31 * d10;
        d35 = d26 + d31 * d11;
        dArray3[0] = d21;
        dArray3[1] = d22;
        dArray3[2] = d32;
        dArray3[3] = d33;
        dArray3[4] = d34;
        dArray3[5] = d35;
        dArray3[6] = d25;
        dArray3[7] = d26;
        return 8;
    }

    private int computeOffsetQuad(double[] dArray, int n2, double[] dArray2, double[] dArray3) {
        double d2 = dArray[n2];
        double d3 = dArray[n2 + 1];
        double d4 = dArray[n2 + 2];
        double d5 = dArray[n2 + 3];
        double d6 = dArray[n2 + 4];
        double d7 = dArray[n2 + 5];
        double d8 = d6 - d4;
        double d9 = d7 - d5;
        double d10 = d4 - d2;
        double d11 = d5 - d3;
        boolean bl2 = Stroker.within(d2, d3, d4, d5, 6.0 * Math.ulp(d5));
        boolean bl3 = Stroker.within(d4, d5, d6, d7, 6.0 * Math.ulp(d7));
        if (bl2 || bl3) {
            this.getLineOffsets(d2, d3, d6, d7, dArray2, dArray3);
            return 4;
        }
        double d12 = d10 * d8 + d11 * d9;
        double d13 = d10 * d10 + d11 * d11;
        double d14 = d8 * d8 + d9 * d9;
        if (Helpers.within(d12 *= d12, d13 * d14, 4.0 * Math.ulp(d12))) {
            this.getLineOffsets(d2, d3, d6, d7, dArray2, dArray3);
            return 4;
        }
        Stroker.computeOffset(d10, d11, this.lineWidth2, this.offset0);
        Stroker.computeOffset(d8, d9, this.lineWidth2, this.offset1);
        double d15 = d2 + this.offset0[0];
        double d16 = d3 + this.offset0[1];
        double d17 = d6 + this.offset1[0];
        double d18 = d7 + this.offset1[1];
        Stroker.safeComputeMiter(d15, d16, d15 + d10, d16 + d11, d17, d18, d17 - d8, d18 - d9, dArray2);
        dArray2[0] = d15;
        dArray2[1] = d16;
        dArray2[4] = d17;
        dArray2[5] = d18;
        d15 = d2 - this.offset0[0];
        d16 = d3 - this.offset0[1];
        d17 = d6 - this.offset1[0];
        d18 = d7 - this.offset1[1];
        Stroker.safeComputeMiter(d15, d16, d15 + d10, d16 + d11, d17, d18, d17 - d8, d18 - d9, dArray3);
        dArray3[0] = d15;
        dArray3[1] = d16;
        dArray3[4] = d17;
        dArray3[5] = d18;
        return 6;
    }

    @Override
    public void curveTo(double d2, double d3, double d4, double d5, double d6, double d7) {
        int n2 = this.cOutCode;
        if (this.clipRect != null) {
            int n3;
            int n4;
            int n5 = Helpers.outcode(d2, d3, this.clipRect);
            int n6 = n2 | n5 | (n4 = Helpers.outcode(d4, d5, this.clipRect)) | (n3 = Helpers.outcode(d6, d7, this.clipRect));
            if (n6 != 0) {
                int n7 = n2 & n5 & n4 & n3;
                if (n7 == 0) {
                    if (this.subdivide) {
                        this.subdivide = false;
                        boolean bl2 = this.curveSplitter.splitCurve(this.cx0, this.cy0, d2, d3, d4, d5, d6, d7, n6, this);
                        this.subdivide = true;
                        if (bl2) {
                            return;
                        }
                    }
                } else {
                    this.cOutCode = n3;
                    this._moveTo(d6, d7, n2);
                    this.opened = true;
                    return;
                }
            }
            this.cOutCode = n3;
        }
        this._curveTo(d2, d3, d4, d5, d6, d7, n2);
    }

    private void _curveTo(double d2, double d3, double d4, double d5, double d6, double d7, int n2) {
        double[] dArray;
        Object object;
        double d8;
        double d9 = d2 - this.cx0;
        double d10 = d3 - this.cy0;
        double d11 = d6 - d4;
        double d12 = d7 - d5;
        if (d9 == 0.0 && d10 == 0.0) {
            d9 = d4 - this.cx0;
            d10 = d5 - this.cy0;
            if (d9 == 0.0 && d10 == 0.0) {
                d9 = d6 - this.cx0;
                d10 = d7 - this.cy0;
            }
        }
        if (d11 == 0.0 && d12 == 0.0) {
            d11 = d6 - d2;
            d12 = d7 - d3;
            if (d11 == 0.0 && d12 == 0.0) {
                d11 = d6 - this.cx0;
                d12 = d7 - this.cy0;
            }
        }
        if (d9 == 0.0 && d10 == 0.0) {
            if (this.clipRect != null) {
                this.cOutCode = n2;
            }
            this.lineTo(this.cx0, this.cy0);
            return;
        }
        if (Math.abs(d9) < 0.1 && Math.abs(d10) < 0.1) {
            d8 = Math.sqrt(d9 * d9 + d10 * d10);
            d9 /= d8;
            d10 /= d8;
        }
        if (Math.abs(d11) < 0.1 && Math.abs(d12) < 0.1) {
            d8 = Math.sqrt(d11 * d11 + d12 * d12);
            d11 /= d8;
            d12 /= d8;
        }
        Stroker.computeOffset(d9, d10, this.lineWidth2, this.offset0);
        this.drawJoin(this.cdx, this.cdy, this.cx0, this.cy0, d9, d10, this.cmx, this.cmy, this.offset0[0], this.offset0[1], n2);
        int n3 = 0;
        double[] dArray2 = this.lp;
        if (this.monotonize) {
            object = this.rdrCtx.monotonizer.curve(this.cx0, this.cy0, d2, d3, d4, d5, d6, d7);
            n3 = ((TransformingPathConsumer2D$CurveBasicMonotonizer)object).nbSplits;
            dArray = ((TransformingPathConsumer2D$CurveBasicMonotonizer)object).middle;
        } else {
            dArray = dArray2;
            dArray[0] = this.cx0;
            dArray[1] = this.cy0;
            dArray[2] = d2;
            dArray[3] = d3;
            dArray[4] = d4;
            dArray[5] = d5;
            dArray[6] = d6;
            dArray[7] = d7;
        }
        object = this.rp;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n5 <= n3) {
            n4 = this.computeOffsetCubic(dArray, n6, dArray2, (double[])object);
            this.emitLineTo(dArray2[0], dArray2[1]);
            switch (n4) {
                case 8: {
                    this.emitCurveTo(dArray2[2], dArray2[3], dArray2[4], dArray2[5], dArray2[6], dArray2[7]);
                    this.emitCurveToRev((double)object[0], (double)object[1], (double)object[2], (double)object[3], (double)object[4], (double)object[5]);
                    break;
                }
                case 4: {
                    this.emitLineTo(dArray2[2], dArray2[3]);
                    this.emitLineToRev((double)object[0], (double)object[1]);
                    break;
                }
            }
            this.emitLineToRev((double)object[n4 - 2], (double)object[n4 - 1]);
            ++n5;
            n6 += 6;
        }
        this.prev = 1;
        this.cx0 = d6;
        this.cy0 = d7;
        this.cdx = d11;
        this.cdy = d12;
        this.cmx = (dArray2[n4 - 2] - object[n4 - 2]) / 2.0;
        this.cmy = (dArray2[n4 - 1] - object[n4 - 1]) / 2.0;
    }

    @Override
    public void quadTo(double d2, double d3, double d4, double d5) {
        int n2 = this.cOutCode;
        if (this.clipRect != null) {
            int n3;
            int n4 = Helpers.outcode(d2, d3, this.clipRect);
            int n5 = n2 | n4 | (n3 = Helpers.outcode(d4, d5, this.clipRect));
            if (n5 != 0) {
                int n6 = n2 & n4 & n3;
                if (n6 == 0) {
                    if (this.subdivide) {
                        this.subdivide = false;
                        boolean bl2 = this.curveSplitter.splitQuad(this.cx0, this.cy0, d2, d3, d4, d5, n5, this);
                        this.subdivide = true;
                        if (bl2) {
                            return;
                        }
                    }
                } else {
                    this.cOutCode = n3;
                    this._moveTo(d4, d5, n2);
                    this.opened = true;
                    return;
                }
            }
            this.cOutCode = n3;
        }
        this._quadTo(d2, d3, d4, d5, n2);
    }

    private void _quadTo(double d2, double d3, double d4, double d5, int n2) {
        double[] dArray;
        Object object;
        double d6;
        double d7 = d2 - this.cx0;
        double d8 = d3 - this.cy0;
        double d9 = d4 - d2;
        double d10 = d5 - d3;
        if (d7 == 0.0 && d8 == 0.0 || d9 == 0.0 && d10 == 0.0) {
            d7 = d9 = d4 - this.cx0;
            d8 = d10 = d5 - this.cy0;
        }
        if (d7 == 0.0 && d8 == 0.0) {
            if (this.clipRect != null) {
                this.cOutCode = n2;
            }
            this.lineTo(this.cx0, this.cy0);
            return;
        }
        if (Math.abs(d7) < 0.1 && Math.abs(d8) < 0.1) {
            d6 = Math.sqrt(d7 * d7 + d8 * d8);
            d7 /= d6;
            d8 /= d6;
        }
        if (Math.abs(d9) < 0.1 && Math.abs(d10) < 0.1) {
            d6 = Math.sqrt(d9 * d9 + d10 * d10);
            d9 /= d6;
            d10 /= d6;
        }
        Stroker.computeOffset(d7, d8, this.lineWidth2, this.offset0);
        this.drawJoin(this.cdx, this.cdy, this.cx0, this.cy0, d7, d8, this.cmx, this.cmy, this.offset0[0], this.offset0[1], n2);
        int n3 = 0;
        double[] dArray2 = this.lp;
        if (this.monotonize) {
            object = this.rdrCtx.monotonizer.quad(this.cx0, this.cy0, d2, d3, d4, d5);
            n3 = ((TransformingPathConsumer2D$CurveBasicMonotonizer)object).nbSplits;
            dArray = ((TransformingPathConsumer2D$CurveBasicMonotonizer)object).middle;
        } else {
            dArray = dArray2;
            dArray[0] = this.cx0;
            dArray[1] = this.cy0;
            dArray[2] = d2;
            dArray[3] = d3;
            dArray[4] = d4;
            dArray[5] = d5;
        }
        object = this.rp;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n5 <= n3) {
            n4 = this.computeOffsetQuad(dArray, n6, dArray2, (double[])object);
            this.emitLineTo(dArray2[0], dArray2[1]);
            switch (n4) {
                case 6: {
                    this.emitQuadTo(dArray2[2], dArray2[3], dArray2[4], dArray2[5]);
                    this.emitQuadToRev((double)object[0], (double)object[1], (double)object[2], (double)object[3]);
                    break;
                }
                case 4: {
                    this.emitLineTo(dArray2[2], dArray2[3]);
                    this.emitLineToRev((double)object[0], (double)object[1]);
                    break;
                }
            }
            this.emitLineToRev((double)object[n4 - 2], (double)object[n4 - 1]);
            ++n5;
            n6 += 4;
        }
        this.prev = 1;
        this.cx0 = d4;
        this.cy0 = d5;
        this.cdx = d9;
        this.cdy = d10;
        this.cmx = (dArray2[n4 - 2] - object[n4 - 2]) / 2.0;
        this.cmy = (dArray2[n4 - 1] - object[n4 - 1]) / 2.0;
    }
}

