/*
 * Decompiled with CFR 0.152.
 */
package com.sun.marlin;

import com.sun.marlin.MarlinUtils;
import com.sun.marlin.RendererStats;
import com.sun.marlin.RendererStats$RendererStatsHolder$1;
import java.security.AccessController;
import java.util.concurrent.ConcurrentLinkedQueue;

final class RendererStats$RendererStatsHolder {
    private static volatile RendererStats$RendererStatsHolder SINGLETON = null;
    private final ConcurrentLinkedQueue<RendererStats> allStats = new ConcurrentLinkedQueue();

    static synchronized RendererStats$RendererStatsHolder getInstance() {
        if (SINGLETON == null) {
            SINGLETON = new RendererStats$RendererStatsHolder();
        }
        return SINGLETON;
    }

    static void dumpStats() {
        if (SINGLETON != null) {
            SINGLETON.dump();
        }
    }

    private RendererStats$RendererStatsHolder() {
        AccessController.doPrivileged(() -> {
            Thread thread = new Thread(MarlinUtils.getRootThreadGroup(), new RendererStats$RendererStatsHolder$1(this), "MarlinStatsHook");
            thread.setContextClassLoader(null);
            Runtime.getRuntime().addShutdownHook(thread);
            return null;
        });
    }

    void add(Object object, RendererStats rendererStats) {
        this.allStats.add(rendererStats);
        MarlinUtils.getCleaner().register(object, () -> this.remove(rendererStats));
    }

    void remove(RendererStats rendererStats) {
        rendererStats.dump();
        this.allStats.remove(rendererStats);
    }

    void dump() {
        for (RendererStats rendererStats : this.allStats) {
            rendererStats.dump();
        }
    }
}

