/*
 * Decompiled with CFR 0.152.
 */
package com.sun.marlin;

import com.sun.marlin.ArrayCacheConst;
import com.sun.marlin.IntArrayCache;
import com.sun.marlin.MarlinConst;
import com.sun.marlin.MarlinUtils;

final class IntArrayCache$Reference {
    final int[] initial;
    private final boolean clean;
    private final IntArrayCache cache;

    IntArrayCache$Reference(IntArrayCache intArrayCache, int n2) {
        this.cache = intArrayCache;
        this.clean = intArrayCache.clean;
        this.initial = IntArrayCache.createArray(n2);
        if (MarlinConst.DO_STATS) {
            intArrayCache.stats.totalInitial += (long)n2;
        }
    }

    int[] getArray(int n2) {
        if (n2 <= ArrayCacheConst.MAX_ARRAY_SIZE) {
            return this.cache.getCacheBucket(n2).getArray();
        }
        if (MarlinConst.DO_STATS) {
            ++this.cache.stats.oversize;
        }
        if (MarlinConst.DO_LOG_OVERSIZE) {
            MarlinUtils.logInfo(IntArrayCache.getLogPrefix(this.clean) + "IntArrayCache: getArray[oversize]: length=\t" + n2);
        }
        return IntArrayCache.createArray(n2);
    }

    int[] widenArray(int[] nArray, int n2, int n3) {
        int n4 = nArray.length;
        if (MarlinConst.DO_CHECKS && n4 >= n3) {
            return nArray;
        }
        if (MarlinConst.DO_STATS) {
            ++this.cache.stats.resize;
        }
        int[] nArray2 = this.getArray(ArrayCacheConst.getNewSize(n2, n3));
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        this.putArray(nArray, 0, n2);
        if (MarlinConst.DO_LOG_WIDEN_ARRAY) {
            MarlinUtils.logInfo(IntArrayCache.getLogPrefix(this.clean) + "IntArrayCache: widenArray[" + nArray2.length + "]: usedSize=\t" + n2 + "\tlength=\t" + n4 + "\tneeded length=\t" + n3);
        }
        return nArray2;
    }

    int[] putArray(int[] nArray) {
        return this.putArray(nArray, 0, nArray.length);
    }

    int[] putArray(int[] nArray, int n2, int n3) {
        if (nArray.length <= ArrayCacheConst.MAX_ARRAY_SIZE) {
            if (this.clean && n3 != 0) {
                IntArrayCache.fill(nArray, n2, n3, 0);
            }
            if (nArray != this.initial) {
                this.cache.getCacheBucket(nArray.length).putArray(nArray);
            }
        }
        return this.initial;
    }
}

