/*
 * Decompiled with CFR 0.152.
 */
package com.sun.marlin;

import com.sun.marlin.Curve;
import com.sun.marlin.MarlinConst;

final class Helpers
implements MarlinConst {
    private Helpers() {
        throw new Error("This is a non instantiable class");
    }

    static boolean within(double d2, double d3, double d4) {
        double d5 = d3 - d2;
        return d5 <= d4 && d5 >= -d4;
    }

    static double evalCubic(double d2, double d3, double d4, double d5, double d6) {
        return d6 * (d6 * (d6 * d2 + d3) + d4) + d5;
    }

    static double evalQuad(double d2, double d3, double d4, double d5) {
        return d5 * (d5 * d2 + d3) + d4;
    }

    static int quadraticRoots(double d2, double d3, double d4, double[] dArray, int n2) {
        int n3 = n2;
        if (d2 != 0.0) {
            double d5 = d3 * d3 - 4.0 * d2 * d4;
            if (d5 > 0.0) {
                double d6 = Math.sqrt(d5);
                if (d3 >= 0.0) {
                    dArray[n3++] = 2.0 * d4 / (-d3 - d6);
                    dArray[n3++] = (-d3 - d6) / (2.0 * d2);
                } else {
                    dArray[n3++] = (-d3 + d6) / (2.0 * d2);
                    dArray[n3++] = 2.0 * d4 / (-d3 + d6);
                }
            } else if (d5 == 0.0) {
                dArray[n3++] = -d3 / (2.0 * d2);
            }
        } else if (d3 != 0.0) {
            dArray[n3++] = -d4 / d3;
        }
        return n3 - n2;
    }

    static int cubicRootsInAB(double d2, double d3, double d4, double d5, double[] dArray, int n2, double d6, double d7) {
        int n3;
        double d8;
        double d9;
        double d10;
        double d11;
        double d12;
        double d13;
        if (d2 == 0.0) {
            int n4 = Helpers.quadraticRoots(d3, d4, d5, dArray, n2);
            return Helpers.filterOutNotInAB(dArray, n2, n4, d6, d7) - n2;
        }
        if ((d13 = (d12 = 0.5 * (0.07407407407407407 * (d3 /= d2) * (d11 = d3 * d3) - (d10 = 0.3333333333333333 * d3) * (d4 /= d2) + (d5 /= d2))) * d12 + (d9 = (d8 = 0.3333333333333333 * (-0.3333333333333333 * d11 + d4)) * d8 * d8)) < 0.0) {
            double d14 = 0.3333333333333333 * Math.acos(-d12 / Math.sqrt(-d9));
            double d15 = 2.0 * Math.sqrt(-d8);
            dArray[n2] = d15 * Math.cos(d14) - d10;
            dArray[n2 + 1] = -d15 * Math.cos(d14 + 1.0471975511965976) - d10;
            dArray[n2 + 2] = -d15 * Math.cos(d14 - 1.0471975511965976) - d10;
            n3 = 3;
        } else {
            double d16 = Math.sqrt(d13);
            double d17 = Math.cbrt(d16 - d12);
            double d18 = -Math.cbrt(d16 + d12);
            dArray[n2] = d17 + d18 - d10;
            n3 = 1;
            if (Helpers.within(d13, 0.0, 1.0E-8)) {
                dArray[n2 + 1] = -0.5 * (d17 + d18) - d10;
                n3 = 2;
            }
        }
        return Helpers.filterOutNotInAB(dArray, n2, n3, d6, d7) - n2;
    }

    static int filterOutNotInAB(double[] dArray, int n2, int n3, double d2, double d3) {
        int n4 = n2;
        int n5 = n2 + n3;
        for (int i2 = n2; i2 < n5; ++i2) {
            if (!(dArray[i2] >= d2) || !(dArray[i2] < d3)) continue;
            dArray[n4++] = dArray[i2];
        }
        return n4;
    }

    static double fastLineLen(double d2, double d3, double d4, double d5) {
        double d6 = d4 - d2;
        double d7 = d5 - d3;
        return Math.abs(d6) + Math.abs(d7);
    }

    static double linelen(double d2, double d3, double d4, double d5) {
        double d6 = d4 - d2;
        double d7 = d5 - d3;
        return Math.sqrt(d6 * d6 + d7 * d7);
    }

    static double fastQuadLen(double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8 = d4 - d2;
        double d9 = d6 - d4;
        double d10 = d5 - d3;
        double d11 = d7 - d5;
        return Math.abs(d8) + Math.abs(d9) + Math.abs(d10) + Math.abs(d11);
    }

    static double quadlen(double d2, double d3, double d4, double d5, double d6, double d7) {
        return (Helpers.linelen(d2, d3, d4, d5) + Helpers.linelen(d4, d5, d6, d7) + Helpers.linelen(d2, d3, d6, d7)) / 2.0;
    }

    static double fastCurvelen(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        double d10 = d4 - d2;
        double d11 = d6 - d4;
        double d12 = d8 - d6;
        double d13 = d5 - d3;
        double d14 = d7 - d5;
        double d15 = d9 - d7;
        return Math.abs(d10) + Math.abs(d11) + Math.abs(d12) + Math.abs(d13) + Math.abs(d14) + Math.abs(d15);
    }

    static double curvelen(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        return (Helpers.linelen(d2, d3, d4, d5) + Helpers.linelen(d4, d5, d6, d7) + Helpers.linelen(d6, d7, d8, d9) + Helpers.linelen(d2, d3, d8, d9)) / 2.0;
    }

    static int findSubdivPoints(Curve curve, double[] dArray, double[] dArray2, int n2, double d2) {
        double d3 = dArray[2] - dArray[0];
        double d4 = dArray[3] - dArray[1];
        if (d4 != 0.0 && d3 != 0.0) {
            double d5 = Math.sqrt(d3 * d3 + d4 * d4);
            double d6 = d3 / d5;
            double d7 = d4 / d5;
            double d8 = d6 * dArray[0] + d7 * dArray[1];
            double d9 = d6 * dArray[1] - d7 * dArray[0];
            double d10 = d6 * dArray[2] + d7 * dArray[3];
            double d11 = d6 * dArray[3] - d7 * dArray[2];
            double d12 = d6 * dArray[4] + d7 * dArray[5];
            double d13 = d6 * dArray[5] - d7 * dArray[4];
            switch (n2) {
                case 8: {
                    double d14 = d6 * dArray[6] + d7 * dArray[7];
                    double d15 = d6 * dArray[7] - d7 * dArray[6];
                    curve.set(d8, d9, d10, d11, d12, d13, d14, d15);
                    break;
                }
                case 6: {
                    curve.set(d8, d9, d10, d11, d12, d13);
                    break;
                }
            }
        } else {
            curve.set(dArray, n2);
        }
        int n3 = 0;
        n3 += curve.dxRoots(dArray2, n3);
        n3 += curve.dyRoots(dArray2, n3);
        if (n2 == 8) {
            n3 += curve.infPoints(dArray2, n3);
        }
        n3 += curve.rootsOfROCMinusW(dArray2, n3, d2, 1.0E-4);
        n3 = Helpers.filterOutNotInAB(dArray2, 0, n3, 1.0E-4, 0.9999);
        Helpers.isort(dArray2, n3);
        return n3;
    }

    static int findClipPoints(Curve curve, double[] dArray, double[] dArray2, int n2, int n3, double[] dArray3) {
        curve.set(dArray, n2);
        int n4 = 0;
        if ((n3 & 4) != 0) {
            n4 += curve.xPoints(dArray2, n4, dArray3[2]);
        }
        if ((n3 & 8) != 0) {
            n4 += curve.xPoints(dArray2, n4, dArray3[3]);
        }
        if ((n3 & 1) != 0) {
            n4 += curve.yPoints(dArray2, n4, dArray3[0]);
        }
        if ((n3 & 2) != 0) {
            n4 += curve.yPoints(dArray2, n4, dArray3[1]);
        }
        Helpers.isort(dArray2, n4);
        return n4;
    }

    static void subdivide(double[] dArray, double[] dArray2, double[] dArray3, int n2) {
        switch (n2) {
            case 8: {
                Helpers.subdivideCubic(dArray, dArray2, dArray3);
                return;
            }
            case 6: {
                Helpers.subdivideQuad(dArray, dArray2, dArray3);
                return;
            }
        }
        throw new InternalError("Unsupported curve type");
    }

    static void isort(double[] dArray, int n2) {
        for (int i2 = 1; i2 < n2; ++i2) {
            double d2 = dArray[i2];
            for (int i3 = i2 - 1; i3 >= 0 && dArray[i3] > d2; --i3) {
                dArray[i3 + 1] = dArray[i3];
            }
            dArray[i3 + 1] = d2;
        }
    }

    static void subdivideCubic(double[] dArray, double[] dArray2, double[] dArray3) {
        double d2 = dArray[0];
        double d3 = dArray[1];
        double d4 = dArray[2];
        double d5 = dArray[3];
        double d6 = dArray[4];
        double d7 = dArray[5];
        double d8 = dArray[6];
        double d9 = dArray[7];
        dArray2[0] = d2;
        dArray2[1] = d3;
        dArray3[6] = d8;
        dArray3[7] = d9;
        d2 = (d2 + d4) / 2.0;
        d3 = (d3 + d5) / 2.0;
        d8 = (d8 + d6) / 2.0;
        d9 = (d9 + d7) / 2.0;
        double d10 = (d4 + d6) / 2.0;
        double d11 = (d5 + d7) / 2.0;
        d4 = (d2 + d10) / 2.0;
        d5 = (d3 + d11) / 2.0;
        d6 = (d8 + d10) / 2.0;
        d7 = (d9 + d11) / 2.0;
        d10 = (d4 + d6) / 2.0;
        d11 = (d5 + d7) / 2.0;
        dArray2[2] = d2;
        dArray2[3] = d3;
        dArray2[4] = d4;
        dArray2[5] = d5;
        dArray2[6] = d10;
        dArray2[7] = d11;
        dArray3[0] = d10;
        dArray3[1] = d11;
        dArray3[2] = d6;
        dArray3[3] = d7;
        dArray3[4] = d8;
        dArray3[5] = d9;
    }

    static void subdivideCubicAt(double d2, double[] dArray, int n2, double[] dArray2, int n3, int n4) {
        double d3 = dArray[n2];
        double d4 = dArray[n2 + 1];
        double d5 = dArray[n2 + 2];
        double d6 = dArray[n2 + 3];
        double d7 = dArray[n2 + 4];
        double d8 = dArray[n2 + 5];
        double d9 = dArray[n2 + 6];
        double d10 = dArray[n2 + 7];
        dArray2[n3] = d3;
        dArray2[n3 + 1] = d4;
        dArray2[n4 + 6] = d9;
        dArray2[n4 + 7] = d10;
        d3 += d2 * (d5 - d3);
        d4 += d2 * (d6 - d4);
        d9 = d7 + d2 * (d9 - d7);
        d10 = d8 + d2 * (d10 - d8);
        double d11 = d5 + d2 * (d7 - d5);
        double d12 = d6 + d2 * (d8 - d6);
        d5 = d3 + d2 * (d11 - d3);
        d6 = d4 + d2 * (d12 - d4);
        d7 = d11 + d2 * (d9 - d11);
        d8 = d12 + d2 * (d10 - d12);
        d11 = d5 + d2 * (d7 - d5);
        d12 = d6 + d2 * (d8 - d6);
        dArray2[n3 + 2] = d3;
        dArray2[n3 + 3] = d4;
        dArray2[n3 + 4] = d5;
        dArray2[n3 + 5] = d6;
        dArray2[n3 + 6] = d11;
        dArray2[n3 + 7] = d12;
        dArray2[n4] = d11;
        dArray2[n4 + 1] = d12;
        dArray2[n4 + 2] = d7;
        dArray2[n4 + 3] = d8;
        dArray2[n4 + 4] = d9;
        dArray2[n4 + 5] = d10;
    }

    static void subdivideQuad(double[] dArray, double[] dArray2, double[] dArray3) {
        double d2 = dArray[0];
        double d3 = dArray[1];
        double d4 = dArray[2];
        double d5 = dArray[3];
        double d6 = dArray[4];
        double d7 = dArray[5];
        dArray2[0] = d2;
        dArray2[1] = d3;
        dArray3[4] = d6;
        dArray3[5] = d7;
        d2 = (d2 + d4) / 2.0;
        d3 = (d3 + d5) / 2.0;
        d6 = (d6 + d4) / 2.0;
        d7 = (d7 + d5) / 2.0;
        d4 = (d2 + d6) / 2.0;
        d5 = (d3 + d7) / 2.0;
        dArray2[2] = d2;
        dArray2[3] = d3;
        dArray2[4] = d4;
        dArray2[5] = d5;
        dArray3[0] = d4;
        dArray3[1] = d5;
        dArray3[2] = d6;
        dArray3[3] = d7;
    }

    static void subdivideQuadAt(double d2, double[] dArray, int n2, double[] dArray2, int n3, int n4) {
        double d3 = dArray[n2];
        double d4 = dArray[n2 + 1];
        double d5 = dArray[n2 + 2];
        double d6 = dArray[n2 + 3];
        double d7 = dArray[n2 + 4];
        double d8 = dArray[n2 + 5];
        dArray2[n3] = d3;
        dArray2[n3 + 1] = d4;
        dArray2[n4 + 4] = d7;
        dArray2[n4 + 5] = d8;
        d3 += d2 * (d5 - d3);
        d4 += d2 * (d6 - d4);
        d7 = d5 + d2 * (d7 - d5);
        d8 = d6 + d2 * (d8 - d6);
        d5 = d3 + d2 * (d7 - d3);
        d6 = d4 + d2 * (d8 - d4);
        dArray2[n3 + 2] = d3;
        dArray2[n3 + 3] = d4;
        dArray2[n3 + 4] = d5;
        dArray2[n3 + 5] = d6;
        dArray2[n4] = d5;
        dArray2[n4 + 1] = d6;
        dArray2[n4 + 2] = d7;
        dArray2[n4 + 3] = d8;
    }

    static void subdivideLineAt(double d2, double[] dArray, int n2, double[] dArray2, int n3, int n4) {
        double d3 = dArray[n2];
        double d4 = dArray[n2 + 1];
        double d5 = dArray[n2 + 2];
        double d6 = dArray[n2 + 3];
        dArray2[n3] = d3;
        dArray2[n3 + 1] = d4;
        dArray2[n4 + 2] = d5;
        dArray2[n4 + 3] = d6;
        d3 += d2 * (d5 - d3);
        d4 += d2 * (d6 - d4);
        dArray2[n3 + 2] = d3;
        dArray2[n3 + 3] = d4;
        dArray2[n4] = d3;
        dArray2[n4 + 1] = d4;
    }

    static void subdivideAt(double d2, double[] dArray, int n2, double[] dArray2, int n3, int n4) {
        if (n4 == 8) {
            Helpers.subdivideCubicAt(d2, dArray, n2, dArray2, n3, n3 + n4);
        } else if (n4 == 4) {
            Helpers.subdivideLineAt(d2, dArray, n2, dArray2, n3, n3 + n4);
        } else {
            Helpers.subdivideQuadAt(d2, dArray, n2, dArray2, n3, n3 + n4);
        }
    }

    static int outcode(double d2, double d3, double[] dArray) {
        int n2 = d3 < dArray[0] ? 1 : (d3 >= dArray[1] ? 2 : 0);
        if (d2 < dArray[2]) {
            n2 |= 4;
        } else if (d2 >= dArray[3]) {
            n2 |= 8;
        }
        return n2;
    }
}

