/*
 * Decompiled with CFR 0.152.
 */
package com.sun.marlin;

import com.sun.marlin.ArrayCacheConst;
import com.sun.marlin.ArrayCacheConst$CacheStats;
import com.sun.marlin.FloatArrayCache$Bucket;
import com.sun.marlin.FloatArrayCache$Reference;
import com.sun.marlin.MarlinConst;
import com.sun.marlin.MarlinUtils;
import java.lang.ref.WeakReference;
import java.util.Arrays;

public final class FloatArrayCache
implements MarlinConst {
    final boolean clean;
    private final int bucketCapacity;
    private WeakReference<FloatArrayCache$Bucket[]> refBuckets = null;
    final ArrayCacheConst$CacheStats stats;

    FloatArrayCache(boolean bl2, int n2) {
        this.clean = bl2;
        this.bucketCapacity = n2;
        this.stats = DO_STATS ? new ArrayCacheConst$CacheStats(FloatArrayCache.getLogPrefix(bl2) + "FloatArrayCache") : null;
    }

    FloatArrayCache$Bucket getCacheBucket(int n2) {
        int n3 = ArrayCacheConst.getBucket(n2);
        return this.getBuckets()[n3];
    }

    private FloatArrayCache$Bucket[] getBuckets() {
        FloatArrayCache$Bucket[] floatArrayCache$BucketArray;
        FloatArrayCache$Bucket[] floatArrayCache$BucketArray2 = floatArrayCache$BucketArray = this.refBuckets != null ? (FloatArrayCache$Bucket[])this.refBuckets.get() : null;
        if (floatArrayCache$BucketArray == null) {
            floatArrayCache$BucketArray = new FloatArrayCache$Bucket[8];
            for (int i2 = 0; i2 < 8; ++i2) {
                floatArrayCache$BucketArray[i2] = new FloatArrayCache$Bucket(this.clean, ArrayCacheConst.ARRAY_SIZES[i2], this.bucketCapacity, DO_STATS ? this.stats.bucketStats[i2] : null);
            }
            this.refBuckets = new WeakReference<FloatArrayCache$Bucket[]>(floatArrayCache$BucketArray);
        }
        return floatArrayCache$BucketArray;
    }

    FloatArrayCache$Reference createRef(int n2) {
        return new FloatArrayCache$Reference(this, n2);
    }

    static float[] createArray(int n2) {
        return new float[n2];
    }

    static void fill(float[] fArray, int n2, int n3, float f2) {
        Arrays.fill(fArray, n2, n3, f2);
        if (DO_CHECKS) {
            FloatArrayCache.check(fArray, n2, n3, f2);
        }
    }

    public static void check(float[] fArray, int n2, int n3, float f2) {
        if (DO_CHECKS) {
            for (int i2 = 0; i2 < fArray.length; ++i2) {
                if (fArray[i2] == f2) continue;
                MarlinUtils.logException("Invalid value at: " + i2 + " = " + fArray[i2] + " from: " + n2 + " to: " + n3 + "\n" + Arrays.toString(fArray), new Throwable());
                Arrays.fill(fArray, f2);
                return;
            }
        }
    }

    static String getLogPrefix(boolean bl2) {
        return bl2 ? "Clean" : "Dirty";
    }
}

