/*
 * Decompiled with CFR 0.152.
 */
package com.sun.marlin;

import com.sun.marlin.ArrayCacheConst;
import com.sun.marlin.FloatArrayCache;
import com.sun.marlin.MarlinConst;
import com.sun.marlin.MarlinUtils;

final class FloatArrayCache$Reference {
    final float[] initial;
    private final boolean clean;
    private final FloatArrayCache cache;

    FloatArrayCache$Reference(FloatArrayCache floatArrayCache, int n2) {
        this.cache = floatArrayCache;
        this.clean = floatArrayCache.clean;
        this.initial = FloatArrayCache.createArray(n2);
        if (MarlinConst.DO_STATS) {
            floatArrayCache.stats.totalInitial += (long)n2;
        }
    }

    float[] getArray(int n2) {
        if (n2 <= ArrayCacheConst.MAX_ARRAY_SIZE) {
            return this.cache.getCacheBucket(n2).getArray();
        }
        if (MarlinConst.DO_STATS) {
            ++this.cache.stats.oversize;
        }
        if (MarlinConst.DO_LOG_OVERSIZE) {
            MarlinUtils.logInfo(FloatArrayCache.getLogPrefix(this.clean) + "FloatArrayCache: getArray[oversize]: length=\t" + n2);
        }
        return FloatArrayCache.createArray(n2);
    }

    float[] widenArray(float[] fArray, int n2, int n3) {
        int n4 = fArray.length;
        if (MarlinConst.DO_CHECKS && n4 >= n3) {
            return fArray;
        }
        if (MarlinConst.DO_STATS) {
            ++this.cache.stats.resize;
        }
        float[] fArray2 = this.getArray(ArrayCacheConst.getNewSize(n2, n3));
        System.arraycopy(fArray, 0, fArray2, 0, n2);
        this.putArray(fArray, 0, n2);
        if (MarlinConst.DO_LOG_WIDEN_ARRAY) {
            MarlinUtils.logInfo(FloatArrayCache.getLogPrefix(this.clean) + "FloatArrayCache: widenArray[" + fArray2.length + "]: usedSize=\t" + n2 + "\tlength=\t" + n4 + "\tneeded length=\t" + n3);
        }
        return fArray2;
    }

    float[] putArray(float[] fArray) {
        return this.putArray(fArray, 0, fArray.length);
    }

    float[] putArray(float[] fArray, int n2, int n3) {
        if (fArray.length <= ArrayCacheConst.MAX_ARRAY_SIZE) {
            if (this.clean && n3 != 0) {
                FloatArrayCache.fill(fArray, n2, n3, 0.0f);
            }
            if (fArray != this.initial) {
                this.cache.getCacheBucket(fArray.length).putArray(fArray);
            }
        }
        return this.initial;
    }
}

