/*
 * Decompiled with CFR 0.152.
 */
package com.sun.marlin;

import com.sun.marlin.ArrayCacheConst$BucketStats;
import com.sun.marlin.FloatArrayCache;
import com.sun.marlin.MarlinConst;
import com.sun.marlin.MarlinUtils;

final class FloatArrayCache$Bucket {
    private int tail = 0;
    private final int arraySize;
    private final boolean clean;
    private final float[][] arrays;
    private final ArrayCacheConst$BucketStats stats;

    FloatArrayCache$Bucket(boolean bl2, int n2, int n3, ArrayCacheConst$BucketStats arrayCacheConst$BucketStats) {
        this.arraySize = n2;
        this.clean = bl2;
        this.stats = arrayCacheConst$BucketStats;
        this.arrays = new float[n3][];
    }

    float[] getArray() {
        if (MarlinConst.DO_STATS) {
            ++this.stats.getOp;
        }
        if (this.tail != 0) {
            float[] fArray = this.arrays[--this.tail];
            this.arrays[this.tail] = null;
            return fArray;
        }
        if (MarlinConst.DO_STATS) {
            ++this.stats.createOp;
        }
        return FloatArrayCache.createArray(this.arraySize);
    }

    void putArray(float[] fArray) {
        if (MarlinConst.DO_CHECKS && fArray.length != this.arraySize) {
            MarlinUtils.logInfo(FloatArrayCache.getLogPrefix(this.clean) + "FloatArrayCache: bad length = " + fArray.length);
            return;
        }
        if (MarlinConst.DO_STATS) {
            ++this.stats.returnOp;
        }
        if (this.arrays.length > this.tail) {
            this.arrays[this.tail++] = fArray;
            if (MarlinConst.DO_STATS) {
                this.stats.updateMaxSize(this.tail);
            }
        } else if (MarlinConst.DO_CHECKS) {
            MarlinUtils.logInfo(FloatArrayCache.getLogPrefix(this.clean) + "FloatArrayCache: array capacity exceeded !");
        }
    }
}

